/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_BROKEN_H__
#define __BKL_ITEM_BROKEN_H__

#include <bickley/bkl-item-extended.h>

G_BEGIN_DECLS

#define BKL_TYPE_ITEM_BROKEN                                            \
   (bkl_item_broken_get_type())
#define BKL_ITEM_BROKEN(obj)                                            \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM_BROKEN,                   \
                                BklItemBroken))
#define BKL_ITEM_BROKEN_CLASS(klass)                                    \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM_BROKEN,                      \
                             BklItemBrokenClass))
#define IS_BKL_ITEM_BROKEN(obj)                                         \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM_BROKEN))
#define IS_BKL_ITEM_BROKEN_CLASS(klass)                                 \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM_BROKEN))
#define BKL_ITEM_BROKEN_GET_CLASS(obj)                                  \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM_BROKEN,                    \
                               BklItemBrokenClass))

typedef struct _BklItemBrokenPrivate BklItemBrokenPrivate;
typedef struct _BklItemBroken      BklItemBroken;
typedef struct _BklItemBrokenClass BklItemBrokenClass;

struct _BklItemBroken
{
    BklItemExtended parent;

    BklItemBrokenPrivate *priv;
};

struct _BklItemBrokenClass
{
    BklItemExtendedClass parent_class;
};

GType bkl_item_broken_get_type (void) G_GNUC_CONST;
BklItemBroken *bkl_item_broken_new (void);
BklItemBroken *bkl_item_broken_new_from_field (KozoField *field);

GSList *bkl_item_broken_get_fields (BklItemBroken *item);

void bkl_item_broken_set_reason (BklItemBroken *broken,
                                 const char    *reason);
const char *bkl_item_broken_get_reason (BklItemBroken *broken);

G_END_DECLS

#endif /* __BKL_ITEM_BROKEN_H__ */
