/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_EXTENDED_H__
#define __BKL_ITEM_EXTENDED_H__

#include <bickley/bkl-item.h>

G_BEGIN_DECLS

#define BKL_TYPE_ITEM_EXTENDED                                          \
   (bkl_item_extended_get_type())
#define BKL_ITEM_EXTENDED(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM_EXTENDED,                 \
                                BklItemExtended))
#define BKL_ITEM_EXTENDED_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM_EXTENDED,                    \
                             BklItemExtendedClass))
#define IS_BKL_ITEM_EXTENDED(obj)                                       \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM_EXTENDED))
#define IS_BKL_ITEM_EXTENDED_CLASS(klass)                               \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM_EXTENDED))
#define BKL_ITEM_EXTENDED_GET_CLASS(obj)                                \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM_EXTENDED,                  \
                               BklItemExtendedClass))

typedef struct _BklItemExtendedPrivate BklItemExtendedPrivate;
typedef struct _BklItemExtended      BklItemExtended;
typedef struct _BklItemExtendedClass BklItemExtendedClass;

struct _BklItemExtended
{
    BklItem parent;

    BklItemExtendedPrivate *priv;
};

struct _BklItemExtendedClass
{
    BklItemClass parent_class;
};

GType bkl_item_extended_get_type (void) G_GNUC_CONST;

GSList *bkl_item_extended_get_fields (BklItemExtended *item);

void bkl_item_extended_set_thumbnail (BklItemExtended *item,
                                      const char      *thumbnail);
const char *bkl_item_extended_get_thumbnail (BklItemExtended *item);

void bkl_item_extended_set_last_used (BklItemExtended *item,
                                      glong            last_used);
glong bkl_item_extended_get_last_used (BklItemExtended *item);

void bkl_item_extended_set_use_count (BklItemExtended *item,
                                      glong            use_count);
glong bkl_item_extended_get_use_count (BklItemExtended *item);

void bkl_item_extended_set_rating (BklItemExtended *item,
                                   int              rating);
int bkl_item_extended_get_rating (BklItemExtended *item);

void bkl_item_extended_set_pinned (BklItemExtended *item,
                                   gboolean         pinned);
gboolean bkl_item_extended_get_pinned (BklItemExtended *item);

void bkl_item_extended_set_tags (BklItemExtended *item,
                                 GPtrArray       *tags);
GPtrArray *bkl_item_extended_get_tags (BklItemExtended *item);
void bkl_item_extended_set_from_field (BklItemExtended *item,
                                       KozoField       *field);
void bkl_item_extended_set_date_indexed (BklItemExtended *item,
                                         glong            date_indexed);
glong bkl_item_extended_get_date_indexed (BklItemExtended *item);
G_END_DECLS

#endif /* __BKL_ITEM_EXTENDED_H__ */
