/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <stdlib.h>

#include "bkl-entry.h"
#include "bkl-item-image.h"

enum {
    PROP_0,
    PROP_TITLE,
    PROP_CAMERA_MAKE,
    PROP_CAMERA_MODEL,
    PROP_DATE_TIME,
    PROP_DATE_TIME_ORIGINAL,
    PROP_DATE_TIME_DIGITIZED,
    PROP_LOCATION,
    PROP_ORIENTATION,
    PROP_EXPOSURE_TIME,
    PROP_APERTURE,
    PROP_METERING_MODE,
    PROP_FLASH,
    PROP_ISO,
    PROP_SOFTWARE,
    PROP_AUTHOR,
    PROP_COPYRIGHT,
    PROP_COMMENT,
    PROP_USER_COMMENT,
    PROP_KEYWORDS,
    PROP_SUBJECT,
    PROP_FOCAL_LENGTH,
    PROP_SHUTTER_SPEED,
    PROP_WIDTH,
    PROP_HEIGHT,
};

struct _BklItemImagePrivate {
    char *title;
    char *make;
    char *model;
    char *date;
    char *date_original;
    char *date_digitized;
    char *orientation;
    char *exposure;
    char *aperture;
    char *metering_mode;
    char *flash;
    char *iso;
    char *software;
    char *author;
    char *copyright;
    char *comment;
    char *user_comment;
    char *keywords;
    char *subject;
    char *focal_length;
    char *shutter_speed;

    guint width;
    guint height;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), BKL_TYPE_ITEM_IMAGE, BklItemImagePrivate))
G_DEFINE_TYPE (BklItemImage, bkl_item_image, BKL_TYPE_ITEM_EXTENDED);

static void
bkl_item_image_finalize (GObject *object)
{
    BklItemImage *self = (BklItemImage *) object;
    BklItemImagePrivate *priv = self->priv;

    g_free (priv->title);
    g_free (priv->make);
    g_free (priv->model);
    g_free (priv->date);
    g_free (priv->date_original);
    g_free (priv->date_digitized);
    g_free (priv->orientation);
    g_free (priv->exposure);
    g_free (priv->aperture);
    g_free (priv->metering_mode);
    g_free (priv->flash);
    g_free (priv->iso);
    g_free (priv->software);
    g_free (priv->author);
    g_free (priv->copyright);
    g_free (priv->comment);
    g_free (priv->user_comment);
    g_free (priv->keywords);
    g_free (priv->subject);
    g_free (priv->focal_length);
    g_free (priv->shutter_speed);

    g_signal_handlers_destroy (object);
    G_OBJECT_CLASS (bkl_item_image_parent_class)->finalize (object);
}

static void
bkl_item_image_dispose (GObject *object)
{
    G_OBJECT_CLASS (bkl_item_image_parent_class)->dispose (object);
}

static void
bkl_item_image_set_property (GObject      *object,
                          guint         prop_id,
                          const GValue *value,
                          GParamSpec   *pspec)
{
    switch (prop_id) {
    case PROP_TITLE:
        break;

    case PROP_CAMERA_MAKE:
        break;

    case PROP_CAMERA_MODEL:
        break;

    case PROP_DATE_TIME:
        break;

    case PROP_DATE_TIME_ORIGINAL:
        break;

    case PROP_DATE_TIME_DIGITIZED:
        break;

    case PROP_LOCATION:
        break;

    case PROP_ORIENTATION:
        break;

    case PROP_EXPOSURE_TIME:
        break;

    case PROP_APERTURE:
        break;

    case PROP_METERING_MODE:
        break;

    case PROP_FLASH:
        break;

    case PROP_ISO:
        break;

    case PROP_SOFTWARE:
        break;

    case PROP_AUTHOR:
        break;

    case PROP_COPYRIGHT:
        break;

    case PROP_COMMENT:
        break;

    case PROP_USER_COMMENT:
        break;

    case PROP_KEYWORDS:
        break;

    case PROP_SUBJECT:
        break;

    case PROP_FOCAL_LENGTH:
        break;

    case PROP_SHUTTER_SPEED:
        break;

    case PROP_WIDTH:
        break;

    case PROP_HEIGHT:
        break;

    default:
        break;
    }
}

static void
bkl_item_image_get_property (GObject    *object,
                          guint       prop_id,
                          GValue     *value,
                          GParamSpec *pspec)
{
    switch (prop_id) {
    case PROP_TITLE:
        break;

    case PROP_CAMERA_MAKE:
        break;

    case PROP_CAMERA_MODEL:
        break;

    case PROP_DATE_TIME:
        break;

    case PROP_DATE_TIME_ORIGINAL:
        break;

    case PROP_DATE_TIME_DIGITIZED:
        break;

    case PROP_LOCATION:
        break;

    case PROP_ORIENTATION:
        break;

    case PROP_EXPOSURE_TIME:
        break;

    case PROP_APERTURE:
        break;

    case PROP_METERING_MODE:
        break;

    case PROP_FLASH:
        break;

    case PROP_ISO:
        break;

    case PROP_SOFTWARE:
        break;

    case PROP_AUTHOR:
        break;

    case PROP_COPYRIGHT:
        break;

    case PROP_COMMENT:
        break;

    case PROP_USER_COMMENT:
        break;

    case PROP_KEYWORDS:
        break;

    case PROP_SUBJECT:
        break;

    case PROP_FOCAL_LENGTH:
        break;

    case PROP_SHUTTER_SPEED:
        break;

    case PROP_WIDTH:
        break;

    case PROP_HEIGHT:
        break;

    default:
        break;
    }
}

static void
bkl_item_image_class_init (BklItemImageClass *klass)
{
    GObjectClass *o_class = (GObjectClass *)klass;

    o_class->dispose = bkl_item_image_dispose;
    o_class->finalize = bkl_item_image_finalize;
    o_class->set_property = bkl_item_image_set_property;
    o_class->get_property = bkl_item_image_get_property;

    g_type_class_add_private (klass, sizeof (BklItemImagePrivate));

    g_object_class_install_property (o_class, PROP_TITLE,
                                     g_param_spec_string ("title", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_CAMERA_MAKE,
                                     g_param_spec_string ("camera-make", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_CAMERA_MODEL,
                                     g_param_spec_string ("camera-model", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_DATE_TIME,
                                     g_param_spec_string ("time", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_DATE_TIME_ORIGINAL,
                                     g_param_spec_string ("time-original", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_DATE_TIME_DIGITIZED,
                                     g_param_spec_string ("time-digitized", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_LOCATION,
                                     g_param_spec_string ("location", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_ORIENTATION,
                                     g_param_spec_string ("orientation", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_EXPOSURE_TIME,
                                     g_param_spec_string ("exposure",
                                                          "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_APERTURE,
                                     g_param_spec_string ("aperture", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_METERING_MODE,
                                     g_param_spec_string ("metering-mode",
                                                          "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_FLASH,
                                     g_param_spec_string ("flash", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_ISO,
                                     g_param_spec_string ("iso", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_SOFTWARE,
                                     g_param_spec_string ("software", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_AUTHOR,
                                     g_param_spec_string ("author", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_COPYRIGHT,
                                     g_param_spec_string ("copyright", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_COMMENT,
                                     g_param_spec_string ("comment", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_USER_COMMENT,
                                     g_param_spec_string ("user-comment", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_KEYWORDS,
                                     g_param_spec_string ("keywords", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_SUBJECT,
                                     g_param_spec_string ("subject", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_FOCAL_LENGTH,
                                     g_param_spec_string ("focal-length", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
    g_object_class_install_property (o_class, PROP_SHUTTER_SPEED,
                                     g_param_spec_string ("shutter-speed", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));

    g_object_class_install_property (o_class, PROP_WIDTH,
                                     g_param_spec_uint ("width", "", "",
                                                        0, G_MAXUINT, 0,
                                                        G_PARAM_READWRITE |
                                                        G_PARAM_STATIC_STRINGS));

    g_object_class_install_property (o_class, PROP_HEIGHT,
                                     g_param_spec_uint ("height", "", "",
                                                        0, G_MAXUINT, 0,
                                                        G_PARAM_READWRITE |
                                                        G_PARAM_STATIC_STRINGS));
}

static void
bkl_item_image_init (BklItemImage *self)
{
    self->priv = GET_PRIVATE (self);
    bkl_item_set_item_type ((BklItem *) self, BKL_ITEM_TYPE_IMAGE);
}

BklItemImage *
bkl_item_image_new (void)
{
    BklItemImage *image;

    image = g_object_new (BKL_TYPE_ITEM_IMAGE, NULL);
    return image;
}

#define IS_EMPTY_STRING(s) ((s) == NULL || *(s) == '\0')
BklItemImage *
bkl_item_image_new_from_field (KozoField *field)
{
    BklItemImage *image;
    const char *data;
    int number;

    image = g_object_new (BKL_TYPE_ITEM_IMAGE, NULL);

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_TITLE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_title (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_MAKE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_camera_make (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_MODEL);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_camera_model (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_DATE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_time (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_DATE_ORIGINAL);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_time_original (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_DATE_DIGITIZED);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_time_digitized (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_ORIENTATION);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_orientation (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_EXPOSURE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_exposure (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_APERTURE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_aperture (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_METERING_MODE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_metering_mode (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_FLASH);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_flash (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_ISO);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_iso (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_SOFTWARE);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_software (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_AUTHOR);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_author (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_COPYRIGHT);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_copyright (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_COMMENT);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_comment (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_USER_COMMENT);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_user_comment (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_KEYWORDS);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_keywords (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_SUBJECT);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_subject (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_FOCAL_LENGTH);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_focal_length (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_SHUTTER_SPEED);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_image_set_shutter_speed (image, data);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_WIDTH);
    if (!IS_EMPTY_STRING (data)) {
        number = atoi (data);
        bkl_item_image_set_width (image, number);
    }

    data = kozo_field_get_value_string (field, BKL_IMAGE_FIELD_HEIGHT);
    if (!IS_EMPTY_STRING (data)) {
        number = atoi (data);
        bkl_item_image_set_height (image, number);
    }

    return image;
}

GSList *
bkl_item_image_get_fields (BklItemImage *item)
{
    BklItemImagePrivate *priv = item->priv;
    GSList *fields = NULL;

    fields = g_slist_prepend (fields, g_strdup_printf ("%u", priv->height));
    fields = g_slist_prepend (fields, g_strdup_printf ("%u", priv->width));
    fields = g_slist_prepend (fields, g_strdup (priv->shutter_speed));
    fields = g_slist_prepend (fields, g_strdup (priv->focal_length));
    fields = g_slist_prepend (fields, g_strdup (priv->subject));
    fields = g_slist_prepend (fields, g_strdup (priv->keywords));
    fields = g_slist_prepend (fields, g_strdup (priv->user_comment));
    fields = g_slist_prepend (fields, g_strdup (priv->comment));
    fields = g_slist_prepend (fields, g_strdup (priv->copyright));
    fields = g_slist_prepend (fields, g_strdup (priv->author));
    fields = g_slist_prepend (fields, g_strdup (priv->software));
    fields = g_slist_prepend (fields, g_strdup (priv->iso));
    fields = g_slist_prepend (fields, g_strdup (priv->flash));
    fields = g_slist_prepend (fields, g_strdup (priv->metering_mode));
    fields = g_slist_prepend (fields, g_strdup (priv->aperture));
    fields = g_slist_prepend (fields, g_strdup (priv->exposure));
    fields = g_slist_prepend (fields, g_strdup (priv->orientation));
    fields = g_slist_prepend (fields, g_strdup (priv->date_digitized));
    fields = g_slist_prepend (fields, g_strdup (priv->date_original));
    fields = g_slist_prepend (fields, g_strdup (priv->date));
    fields = g_slist_prepend (fields, g_strdup (priv->model));
    fields = g_slist_prepend (fields, g_strdup (priv->make));
    fields = g_slist_prepend (fields, g_strdup (priv->title));

    return fields;
}

void
bkl_item_image_set_title (BklItemImage *image,
                          const char   *title)
{
    g_free (image->priv->title);
    image->priv->title = g_strdup (title);
}

const char *
bkl_item_image_get_title (BklItemImage *image)
{
    return image->priv->title;
}

void
bkl_item_image_set_camera_make (BklItemImage *image,
                                const char   *make)
{
    g_free (image->priv->make);
    image->priv->make = g_strdup (make);
}

const char *
bkl_item_image_get_camera_make (BklItemImage *image)
{
    return image->priv->make;
}

void
bkl_item_image_set_camera_model (BklItemImage *image,
                                 const char   *model)
{
    g_free (image->priv->model);
    image->priv->model = g_strdup (model);
}

const char *
bkl_item_image_get_camera_model (BklItemImage *image)
{
    return image->priv->model;
}

void
bkl_item_image_set_time (BklItemImage *image,
                          const char   *date)
{
    g_free (image->priv->date);
    image->priv->date = g_strdup (date);
}

const char *
bkl_item_image_get_time (BklItemImage *image)
{
    return image->priv->date;
}

void
bkl_item_image_set_time_original (BklItemImage *image,
                                  const char   *time_original)
{
    g_free (image->priv->date_original);
    image->priv->date_original = g_strdup (time_original);
}

const char *
bkl_item_image_get_time_original (BklItemImage *image)
{
    return image->priv->date_original;
}

void
bkl_item_image_set_time_digitized (BklItemImage *image,
                                   const char   *time_digitized)
{
    g_free (image->priv->date_digitized);
    image->priv->date_digitized = g_strdup (time_digitized);
}

const char *
bkl_item_image_get_time_digitized (BklItemImage *image)
{
    return image->priv->date_digitized;
}

void
bkl_item_image_set_orientation (BklItemImage *image,
                                const char   *orientation)
{
    g_free (image->priv->orientation);
    image->priv->orientation = g_strdup (orientation);
}

const char *
bkl_item_image_get_orientation (BklItemImage *image)
{
    return image->priv->orientation;
}

void
bkl_item_image_set_exposure (BklItemImage *image,
                             const char   *exposure)
{
    g_free (image->priv->exposure);
    image->priv->exposure = g_strdup (exposure);
}

const char *
bkl_item_image_get_exposure (BklItemImage *image)
{
    return image->priv->exposure;
}

void
bkl_item_image_set_aperture (BklItemImage *image,
                             const char   *aperture)
{
    g_free (image->priv->aperture);
    image->priv->aperture = g_strdup (aperture);
}

const char *
bkl_item_image_get_aperture (BklItemImage *image)
{
    return image->priv->aperture;
}

void
bkl_item_image_set_metering_mode (BklItemImage *image,
                                  const char   *metering_mode)
{
    g_free (image->priv->metering_mode);
    image->priv->metering_mode = g_strdup (metering_mode);
}

const char *
bkl_item_image_get_metering_mode (BklItemImage *image)
{
    return image->priv->metering_mode;
}

void
bkl_item_image_set_flash (BklItemImage *image,
                          const char   *flash)
{
    g_free (image->priv->flash);
    image->priv->flash = g_strdup (flash);
}

const char *
bkl_item_image_get_flash (BklItemImage *image)
{
    return image->priv->flash;
}

void
bkl_item_image_set_iso (BklItemImage *image,
                        const char   *iso)
{
    g_free (image->priv->iso);
    image->priv->iso = g_strdup (iso);
}

const char *
bkl_item_image_get_iso (BklItemImage *image)
{
    return image->priv->iso;
}

void
bkl_item_image_set_software (BklItemImage *image,
                             const char   *software)
{
    g_free (image->priv->software);
    image->priv->software = g_strdup (software);
}

const char *
bkl_item_image_get_software (BklItemImage *image)
{
    return image->priv->software;
}

void
bkl_item_image_set_author (BklItemImage *image,
                           const char   *author)
{
    g_free (image->priv->author);
    image->priv->author = g_strdup (author);
}

const char *
bkl_item_image_get_author (BklItemImage *image)
{
    return image->priv->author;
}

void
bkl_item_image_set_copyright (BklItemImage *image,
                              const char   *copyright)
{
    g_free (image->priv->copyright);
    image->priv->copyright = g_strdup (copyright);
}

const char *
bkl_item_image_get_copyright (BklItemImage *image)
{
    return image->priv->copyright;
}

void
bkl_item_image_set_comment (BklItemImage *image,
                            const char   *comment)
{
    g_free (image->priv->comment);
    image->priv->comment = g_strdup (comment);
}

const char *
bkl_item_image_get_comment (BklItemImage *image)
{
    return image->priv->comment;
}

void
bkl_item_image_set_user_comment (BklItemImage *image,
                                 const char   *user_comment)
{
    g_free (image->priv->user_comment);
    image->priv->user_comment = g_strdup (user_comment);
}

const char *
bkl_item_image_get_user_comment (BklItemImage *image)
{
    return image->priv->user_comment;
}

void
bkl_item_image_set_keywords (BklItemImage *image,
                             const char   *keywords)
{
    g_free (image->priv->keywords);
    image->priv->keywords = g_strdup (keywords);
}

const char *
bkl_item_image_get_keywords (BklItemImage *image)
{
    return image->priv->keywords;
}

void
bkl_item_image_set_subject (BklItemImage *image,
                            const char   *subject)
{
    g_free (image->priv->subject);
    image->priv->subject = g_strdup (subject);
}

const char *
bkl_item_image_get_subject (BklItemImage *image)
{
    return image->priv->subject;
}

void
bkl_item_image_set_focal_length (BklItemImage *image,
                                 const char   *focal_length)
{
    g_free (image->priv->focal_length);
    image->priv->focal_length = g_strdup (focal_length);
}

const char *
bkl_item_image_get_focal_length (BklItemImage *image)
{
    return image->priv->focal_length;
}

void
bkl_item_image_set_shutter_speed (BklItemImage *image,
                                  const char   *shutter_speed)
{
    g_free (image->priv->shutter_speed);
    image->priv->shutter_speed = g_strdup (shutter_speed);
}

const char *
bkl_item_image_get_shutter_speed (BklItemImage *image)
{
    return image->priv->shutter_speed;
}

void
bkl_item_image_set_width (BklItemImage *image,
                          guint         width)
{
    image->priv->width = width;
}

guint
bkl_item_image_get_width (BklItemImage *image)
{
    return image->priv->width;
}

void
bkl_item_image_set_height (BklItemImage *image,
                           guint         height)
{
    image->priv->height = height;
}

guint
bkl_item_image_get_height (BklItemImage *image)
{
    return image->priv->height;
}

char *
bkl_item_image_to_string (BklItemImage *image)
{
    BklItemImagePrivate *priv = image->priv;
    GString *contents;
    char *str, *size;

    contents = g_string_new ("");
    if (priv->title) {
        g_string_append (contents, priv->title);
        g_string_append_c (contents, ' ');
    }

    if (priv->make) {
        g_string_append (contents, priv->make);
        g_string_append_c (contents, ' ');
    }

    if (priv->model) {
        g_string_append (contents, priv->model);
        g_string_append_c (contents, ' ');
    }

    if (priv->software) {
        g_string_append (contents, priv->software);
        g_string_append_c (contents, ' ');
    }

    if (priv->author) {
        g_string_append (contents, priv->author);
        g_string_append_c (contents, ' ');
    }

    if (priv->comment) {
        g_string_append (contents, priv->comment);
        g_string_append_c (contents, ' ');
    }

    if (priv->user_comment) {
        g_string_append (contents, priv->user_comment);
        g_string_append_c (contents, ' ');
    }

    if (priv->keywords) {
        g_string_append (contents, priv->keywords);
        g_string_append_c (contents, ' ');
    }

    if (priv->subject) {
        g_string_append (contents, priv->subject);
        g_string_append_c (contents, ' ');
    }

    if (priv->focal_length) {
        g_string_append (contents, priv->focal_length);
        g_string_append_c (contents, ' ');
    }

    /* Can search on "widthxheight" (eg 1024x256) */
    size = g_strdup_printf ("%ux%u", priv->width, priv->height);
    g_string_append (contents, size);
    g_free (size);
    /* g_string_append_c (contents, ' '); */

    str = contents->str;
    g_string_free (contents, FALSE);
    return str;
}
