/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_AUDIO_H__
#define __BKL_ITEM_AUDIO_H__

#include <bickley/bkl-item-extended.h>


G_BEGIN_DECLS

#define BKL_TYPE_ITEM_AUDIO                                             \
   (bkl_item_audio_get_type())
#define BKL_ITEM_AUDIO(obj)                                             \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM_AUDIO,                    \
                                BklItemAudio))
#define BKL_ITEM_AUDIO_CLASS(klass)                                     \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM_AUDIO,                       \
                             BklItemAudioClass))
#define IS_BKL_ITEM_AUDIO(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM_AUDIO))
#define IS_BKL_ITEM_AUDIO_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM_AUDIO))
#define BKL_ITEM_AUDIO_GET_CLASS(obj)                                   \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM_AUDIO,                     \
                               BklItemAudioClass))

typedef struct _BklItemAudioPrivate BklItemAudioPrivate;
typedef struct _BklItemAudio      BklItemAudio;
typedef struct _BklItemAudioClass BklItemAudioClass;

struct _BklItemAudio
{
    BklItemExtended parent;

    BklItemAudioPrivate *priv;
};

struct _BklItemAudioClass
{
    BklItemExtendedClass parent_class;
};

GType bkl_item_audio_get_type (void) G_GNUC_CONST;

BklItemAudio *bkl_item_audio_new (void);
BklItemAudio *bkl_item_audio_new_from_field (KozoField *field);

GSList *bkl_item_audio_get_fields (BklItemAudio *item);

void bkl_item_audio_set_title (BklItemAudio *audio,
                               const char   *title);
const char *bkl_item_audio_get_title (BklItemAudio *audio);

void bkl_item_audio_set_album (BklItemAudio *audio,
                               const char   *album);
const char *bkl_item_audio_get_album (BklItemAudio *audio);

void bkl_item_audio_set_artists (BklItemAudio *audio,
                                 GPtrArray    *artists);
GPtrArray *bkl_item_audio_get_artists (BklItemAudio *audio);

void bkl_item_audio_set_performers (BklItemAudio *audio,
                                    GPtrArray    *performers);
GPtrArray *bkl_item_audio_get_performers (BklItemAudio *audio);

void bkl_item_audio_set_conductor (BklItemAudio *audio,
                                   const char   *conductor);
const char *bkl_item_audio_get_conductor (BklItemAudio *audio);

void bkl_item_audio_set_composer (BklItemAudio *audio,
                                  const char   *composer);
const char *bkl_item_audio_get_composer (BklItemAudio *audio);

void bkl_item_audio_set_genre (BklItemAudio *audio,
                               const char   *genre);
const char *bkl_item_audio_get_genre (BklItemAudio *audio);

void bkl_item_audio_set_comment (BklItemAudio *audio,
                                 const char   *comment);
const char *bkl_item_audio_get_comment (BklItemAudio *audio);

void bkl_item_audio_set_copyright (BklItemAudio *audio,
                                   const char   *copyright);
const char *bkl_item_audio_get_copyright (BklItemAudio *audio);

void bkl_item_audio_set_license (BklItemAudio *audio,
                                 const char   *license);
const char *bkl_item_audio_get_license (BklItemAudio *audio);

void bkl_item_audio_set_organisation (BklItemAudio *audio,
                                      const char   *organisation);
const char *bkl_item_audio_get_organisation (BklItemAudio *audio);

void bkl_item_audio_set_isrc (BklItemAudio *audio,
                              const char   *isrc);
const char *bkl_item_audio_get_isrc (BklItemAudio *audio);

void bkl_item_audio_set_contact (BklItemAudio *audio,
                                 const char   *contact);
const char *bkl_item_audio_get_contact (BklItemAudio *audio);

void bkl_item_audio_set_year (BklItemAudio *audio,
                              const char   *year);
const char *bkl_item_audio_get_year (BklItemAudio *audio);

void bkl_item_audio_set_track (BklItemAudio *audio,
                               guint         track);
guint bkl_item_audio_get_track (BklItemAudio *audio);

void bkl_item_audio_set_maxtracks (BklItemAudio *audio,
                                   guint         maxtracks);
guint bkl_item_audio_get_max_tracks (BklItemAudio *audio);

void bkl_item_audio_set_disc (BklItemAudio *audio,
                              guint         disc);
guint bkl_item_audio_get_disc (BklItemAudio *audio);
guint bkl_item_audio_get_maxdiscs (BklItemAudio *audio);
void bkl_item_audio_set_maxdiscs (BklItemAudio *audio,
                                  guint         maxdiscs);


void bkl_item_audio_set_duration (BklItemAudio *audio,
                                  guint         duration);
guint bkl_item_audio_get_duration (BklItemAudio *audio);

void bkl_item_audio_set_artist_image (BklItemAudio *audio,
                                      const char   *artist_image);
const char *bkl_item_audio_get_artist_image (BklItemAudio *audio);

char *bkl_item_audio_to_string (BklItemAudio *audio);

G_END_DECLS

#endif /* __BKL_ITEM_AUDIO_H__ */
