<?xml version="1.0"?>
<api version="1.0">
	<namespace name="Kozo">
		<callback name="KozoDBForeachFunc">
			<return-type type="void"/>
			<parameters>
				<parameter name="db" type="KozoDB*"/>
				<parameter name="key" type="char*"/>
				<parameter name="entry" type="KozoEntry*"/>
				<parameter name="userdata" type="gpointer"/>
			</parameters>
		</callback>
		<callback name="KozoQueryCallback">
			<return-type type="void"/>
			<parameters>
				<parameter name="query" type="KozoQuery*"/>
				<parameter name="entries" type="KozoEntry**"/>
				<parameter name="n_entries" type="guint"/>
				<parameter name="user_data" type="gpointer"/>
			</parameters>
		</callback>
		<struct name="KozoDB">
			<method name="add" symbol="kozo_db_add">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="key" type="char*"/>
					<parameter name="fields" type="GSList*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="error_quark" symbol="kozo_db_error_quark">
				<return-type type="GQuark"/>
			</method>
			<method name="flush" symbol="kozo_db_flush">
				<return-type type="void"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="foreach" symbol="kozo_db_foreach">
				<return-type type="void"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="func" type="KozoDBForeachFunc"/>
					<parameter name="userdata" type="gpointer"/>
				</parameters>
			</method>
			<method name="get" symbol="kozo_db_get">
				<return-type type="KozoDB*"/>
				<parameters>
					<parameter name="db_name" type="char*"/>
					<parameter name="version" type="guint"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="get_filename" symbol="kozo_db_get_filename">
				<return-type type="char*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="get_for_name" symbol="kozo_db_get_for_name">
				<return-type type="KozoDB*"/>
				<parameters>
					<parameter name="filename" type="char*"/>
					<parameter name="db_name" type="char*"/>
					<parameter name="version" type="guint"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="get_for_path" symbol="kozo_db_get_for_path">
				<return-type type="KozoDB*"/>
				<parameters>
					<parameter name="filename" type="char*"/>
					<parameter name="db_name" type="char*"/>
					<parameter name="version" type="guint"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="get_index" symbol="kozo_db_get_index">
				<return-type type="KozoIndex*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="field_ids" type="GSList*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="get_name" symbol="kozo_db_get_name">
				<return-type type="char*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="get_version" symbol="kozo_db_get_version">
				<return-type type="guint"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="lookup" symbol="kozo_db_lookup">
				<return-type type="KozoEntry*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="key" type="char*"/>
					<parameter name="field_ids" type="GSList*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="new_query" symbol="kozo_db_new_query">
				<return-type type="KozoQuery*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="ref" symbol="kozo_db_ref">
				<return-type type="KozoDB*"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
			<method name="register_field" symbol="kozo_db_register_field">
				<return-type type="int"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="desc" type="char*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="remove" symbol="kozo_db_remove">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="key" type="char*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="set" symbol="kozo_db_set">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="key" type="char*"/>
					<parameter name="fields" type="GSList*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="set_name" symbol="kozo_db_set_name">
				<return-type type="void"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
					<parameter name="db_name" type="char*"/>
				</parameters>
			</method>
			<method name="unref" symbol="kozo_db_unref">
				<return-type type="void"/>
				<parameters>
					<parameter name="db" type="KozoDB*"/>
				</parameters>
			</method>
		</struct>
		<struct name="KozoEntry">
			<method name="dump" symbol="kozo_entry_dump">
				<return-type type="void"/>
				<parameters>
					<parameter name="entry" type="KozoEntry*"/>
					<parameter name="n_fields" type="int"/>
				</parameters>
			</method>
			<method name="free" symbol="kozo_entry_free">
				<return-type type="void"/>
				<parameters>
					<parameter name="entry" type="KozoEntry*"/>
				</parameters>
			</method>
			<method name="get_field" symbol="kozo_entry_get_field">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="entry" type="KozoEntry*"/>
					<parameter name="field_id" type="int"/>
				</parameters>
			</method>
			<method name="get_raw_data" symbol="kozo_entry_get_raw_data">
				<return-type type="guint8*"/>
				<parameters>
					<parameter name="entry" type="KozoEntry*"/>
					<parameter name="length" type="guint32*"/>
				</parameters>
			</method>
		</struct>
		<struct name="KozoExpr">
			<method name="new_int" symbol="kozo_expr_new_int">
				<return-type type="KozoExpr*"/>
				<parameters>
					<parameter name="type" type="KozoExprType"/>
					<parameter name="field_id" type="int"/>
					<parameter name="cnst" type="gint32"/>
				</parameters>
			</method>
			<method name="new_string" symbol="kozo_expr_new_string">
				<return-type type="KozoExpr*"/>
				<parameters>
					<parameter name="type" type="KozoExprType"/>
					<parameter name="field_id" type="int"/>
					<parameter name="cnst" type="char*"/>
				</parameters>
			</method>
			<method name="new_time" symbol="kozo_expr_new_time">
				<return-type type="KozoExpr*"/>
				<parameters>
					<parameter name="type" type="KozoExprType"/>
					<parameter name="field_id" type="int"/>
					<parameter name="cnst" type="time_t"/>
				</parameters>
			</method>
			<method name="ref" symbol="kozo_expr_ref">
				<return-type type="KozoExpr*"/>
				<parameters>
					<parameter name="expr" type="KozoExpr*"/>
				</parameters>
			</method>
			<method name="unref" symbol="kozo_expr_unref">
				<return-type type="void"/>
				<parameters>
					<parameter name="expr" type="KozoExpr*"/>
				</parameters>
			</method>
		</struct>
		<struct name="KozoField">
			<method name="free" symbol="kozo_field_free">
				<return-type type="void"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</method>
			<method name="get_id" symbol="kozo_field_get_id">
				<return-type type="int"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</method>
			<method name="get_raw_data" symbol="kozo_field_get_raw_data">
				<return-type type="guint8*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
					<parameter name="length" type="guint32*"/>
				</parameters>
			</method>
			<method name="get_value_count" symbol="kozo_field_get_value_count">
				<return-type type="guint32"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
				</parameters>
			</method>
			<method name="get_value_int" symbol="kozo_field_get_value_int">
				<return-type type="gint32"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
					<parameter name="n" type="int"/>
				</parameters>
			</method>
			<method name="get_value_string" symbol="kozo_field_get_value_string">
				<return-type type="char*"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
					<parameter name="n" type="int"/>
				</parameters>
			</method>
			<method name="get_value_time" symbol="kozo_field_get_value_time">
				<return-type type="time_t"/>
				<parameters>
					<parameter name="field" type="KozoField*"/>
					<parameter name="n" type="int"/>
				</parameters>
			</method>
			<method name="list_free" symbol="kozo_field_list_free">
				<return-type type="void"/>
				<parameters>
					<parameter name="field_list" type="GSList*"/>
				</parameters>
			</method>
			<method name="new_int" symbol="kozo_field_new_int">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="value" type="gint32"/>
				</parameters>
			</method>
			<method name="new_int_list" symbol="kozo_field_new_int_list">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="values" type="GSList*"/>
				</parameters>
			</method>
			<method name="new_string" symbol="kozo_field_new_string">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="value" type="char*"/>
				</parameters>
			</method>
			<method name="new_string_list" symbol="kozo_field_new_string_list">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="values" type="GSList*"/>
				</parameters>
			</method>
			<method name="new_time" symbol="kozo_field_new_time">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="value" type="time_t"/>
				</parameters>
			</method>
			<method name="new_time_list" symbol="kozo_field_new_time_list">
				<return-type type="KozoField*"/>
				<parameters>
					<parameter name="field_id" type="int"/>
					<parameter name="values" type="GSList*"/>
				</parameters>
			</method>
		</struct>
		<struct name="KozoIndex">
			<method name="get_field_ids" symbol="kozo_index_get_field_ids">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="index" type="KozoIndex*"/>
				</parameters>
			</method>
			<method name="lookup" symbol="kozo_index_lookup">
				<return-type type="KozoEntry*"/>
				<parameters>
					<parameter name="index" type="KozoIndex*"/>
					<parameter name="key" type="guint8*"/>
					<parameter name="key_length" type="guint32"/>
					<parameter name="field_ids" type="GSList*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="new_query" symbol="kozo_index_new_query">
				<return-type type="KozoQuery*"/>
				<parameters>
					<parameter name="index" type="KozoIndex*"/>
				</parameters>
			</method>
			<method name="ref" symbol="kozo_index_ref">
				<return-type type="KozoIndex*"/>
				<parameters>
					<parameter name="index" type="KozoIndex*"/>
				</parameters>
			</method>
			<method name="unref" symbol="kozo_index_unref">
				<return-type type="void"/>
				<parameters>
					<parameter name="index" type="KozoIndex*"/>
				</parameters>
			</method>
		</struct>
		<struct name="KozoQuery">
			<method name="add_expr" symbol="kozo_query_add_expr">
				<return-type type="void"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
					<parameter name="expr" type="KozoExpr*"/>
				</parameters>
			</method>
			<method name="add_field" symbol="kozo_query_add_field">
				<return-type type="void"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
					<parameter name="field_id" type="int"/>
				</parameters>
			</method>
			<method name="get_exprs" symbol="kozo_query_get_exprs">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
				</parameters>
			</method>
			<method name="get_fields" symbol="kozo_query_get_fields">
				<return-type type="GSList*"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
				</parameters>
			</method>
			<method name="get_op" symbol="kozo_query_get_op">
				<return-type type="KozoOperator"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
				</parameters>
			</method>
			<method name="ref" symbol="kozo_query_ref">
				<return-type type="KozoQuery*"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
				</parameters>
			</method>
			<method name="run" symbol="kozo_query_run">
				<return-type type="gboolean"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
					<parameter name="error" type="GError**"/>
				</parameters>
			</method>
			<method name="set_funcs" symbol="kozo_query_set_funcs">
				<return-type type="void"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
					<parameter name="entries_added" type="KozoQueryCallback"/>
					<parameter name="entries_changed" type="KozoQueryCallback"/>
					<parameter name="entries_removed" type="KozoQueryCallback"/>
					<parameter name="user_data" type="gpointer"/>
				</parameters>
			</method>
			<method name="set_op" symbol="kozo_query_set_op">
				<return-type type="void"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
					<parameter name="op" type="KozoOperator"/>
				</parameters>
			</method>
			<method name="unref" symbol="kozo_query_unref">
				<return-type type="void"/>
				<parameters>
					<parameter name="query" type="KozoQuery*"/>
				</parameters>
			</method>
		</struct>
		<enum name="KozoDBError">
			<member name="KOZO_DB_ERROR_BACKEND" value="0"/>
			<member name="KOZO_DB_ERROR_IO" value="1"/>
			<member name="KOZO_DB_ERROR_KEY_NOT_FOUND" value="2"/>
			<member name="KOZO_DB_ERROR_KEY_EXISTS" value="3"/>
			<member name="KOZO_DB_ERROR_VERSION_MISMATCH" value="4"/>
		</enum>
		<enum name="KozoExprType">
			<member name="KOZO_EXPR_CONTAINS" value="0"/>
			<member name="KOZO_EXPR_DOES_NOT_CONTAIN" value="1"/>
			<member name="KOZO_EXPR_EQ" value="2"/>
			<member name="KOZO_EXPR_NE" value="3"/>
			<member name="KOZO_EXPR_GE" value="4"/>
			<member name="KOZO_EXPR_GT" value="5"/>
			<member name="KOZO_EXPR_LE" value="6"/>
			<member name="KOZO_EXPR_LT" value="7"/>
		</enum>
		<enum name="KozoOperator">
			<member name="KOZO_OPERATOR_AND" value="0"/>
			<member name="KOZO_OPERATOR_OR" value="1"/>
		</enum>
		<constant name="KOZO_FIELD_INDEX_KEY" type="int" value="-2"/>
		<constant name="KOZO_FIELD_KEY" type="int" value="-1"/>
	</namespace>
</api>
