#!/bin/bash

echo "SPP Paring & Connection Script"

echo -e "SCANNING BLUETOOTH DEVICES ...."
echo -n "Please Put SPP device in Pairing mode...Press Enter.."

read nil
hcitool scan

echo "If device is not in the list press Enter"
echo "Copy the bluetooth address of the SPP Device and paste it below ="
read bdaddr
if [[ -z "${bdaddr}" ]]; then
   echo "Not a valid BD_ADDR"
   exit 0
fi

echo -e "Adding SPP to SDP server"
sdptool add SP
echo -e " Done."

echo "Starting- Pairing with SPP Device"
python /usr/local/sbin/agent.py hci0 $bdaddr 

echo "Pairing Done"

#echo -e "Creating a rfcomm connection\n"
#python /usr/local/sbin/serial.py $bdaddr spp
#echo -e "Connection Done"

echo "Creating a connection\n"

echo "Enter a number for the <dev> rfcomm id to be used"
echo "make sure that /dev/rfcomm id not being used before, OTHERWISE enter number 2 "
echo "Example to use /dev/rfcomm2, enter number 2"

read rfcommId
if [[ -z "${rfcommId}" ]]; then
   rfcommId=2
fi

sdptool browse $bdaddr

echo "Scroll and find the RFCOMM channel for SPP"
echo "Enter the channel id for SPP"
read channel

sudo rfcomm connect $rfcommId $bdaddr $channel 

echo -e "Rfcomm channel created:"
hcitool con
echo -e "Rfcomm channel configuration:"
rfcomm -a
echo "/dev/rfcomm$rfcommId created"

echo "Start your SPP application !"
