<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>Cairomm: A C++ wrapper for the cairo graphics library</title>
    <filename>index</filename>
    <docanchor file="index">Introduction</docanchor>
    <docanchor file="index">License</docanchor>
  </compound>
  <compound kind="class">
    <name>cairo_matrix_t</name>
    <filename>classcairo__matrix__t.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Cairo</name>
    <filename>namespaceCairo.html</filename>
    <class kind="class">Cairo::Context</class>
    <class kind="class">Cairo::logic_error</class>
    <class kind="class">Cairo::FontFace</class>
    <class kind="class">Cairo::ToyFontFace</class>
    <class kind="class">Cairo::UserFontFace</class>
    <class kind="class">Cairo::FtFontFace</class>
    <class kind="class">Cairo::FontOptions</class>
    <class kind="class">Cairo::Matrix</class>
    <class kind="class">Cairo::Path</class>
    <class kind="struct">Cairo::ColorStop</class>
    <class kind="class">Cairo::Pattern</class>
    <class kind="class">Cairo::SolidPattern</class>
    <class kind="class">Cairo::SurfacePattern</class>
    <class kind="class">Cairo::Gradient</class>
    <class kind="class">Cairo::LinearGradient</class>
    <class kind="class">Cairo::RadialGradient</class>
    <class kind="class">Cairo::QuartzFontFace</class>
    <class kind="class">Cairo::QuartzSurface</class>
    <class kind="class">Cairo::RefPtr</class>
    <class kind="class">Cairo::ScaledFont</class>
    <class kind="class">Cairo::FtScaledFont</class>
    <class kind="class">Cairo::Surface</class>
    <class kind="class">Cairo::ImageSurface</class>
    <class kind="class">Cairo::PdfSurface</class>
    <class kind="class">Cairo::PsSurface</class>
    <class kind="class">Cairo::SvgSurface</class>
    <class kind="class">Cairo::GlitzSurface</class>
    <class kind="class">Cairo::Win32FontFace</class>
    <class kind="class">Cairo::Win32ScaledFont</class>
    <class kind="class">Cairo::Win32Surface</class>
    <class kind="class">Cairo::Win32PrintingSurface</class>
    <class kind="class">Cairo::XlibSurface</class>
    <member kind="typedef">
      <type>cairo_rectangle_t</type>
      <name>Rectangle</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>5a956a3226f8c0cece695c49f453e124</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cairo_font_extents_t</type>
      <name>FontExtents</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>a7da46c699a67bfbdd5400af7e6b7b39</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cairo_text_extents_t</type>
      <name>TextExtents</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f6d8a4744616383984c99f8f052c7a5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cairo_text_cluster_t</type>
      <name>TextCluster</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>3c23510889078c8a75d66add004ab288</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cairo_glyph_t</type>
      <name>Glyph</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2483f165322e844c095c7be95849fdc2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Operator</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_CLEAR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1a2c5cc98949fc510d058a40e4b5d28ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_SOURCE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d159b66a5b95d6e3ed8cdebaf57717c623</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_OVER</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1efa21fe990e27b2c19017fbf827691e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_IN</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d150643bd3d909e6dd6f59bf8a3d7b1305</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_OUT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d199d0e17305e6e3837eff89e87e17dd3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_ATOP</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1138d827bff22a56ea542e19a08839471</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_DEST</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d12a8b28a5adfcccaed2a3257ef3953f5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_DEST_OVER</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d16183d6187a356c0083f44484d63f814b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_DEST_IN</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1ceb620b25d955ac8c2c95b3af2b8d51f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_DEST_OUT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1b4844d149fd4bb37bfba21db1357593d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_DEST_ATOP</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1d75365e1f469f43920f05dd0658313ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_XOR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d11450e8ce1f45caa62f88849b6f806424</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_ADD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1ccd32a58444054921ba8ab4989e0186d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OPERATOR_SATURATE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2d612c31d146fc32d486f9614560c8d1c0bf6e068ff1d96ca21b75e92ef482c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Antialias</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2cb381e7f63bef767a7d697fc5af13b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANTIALIAS_DEFAULT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2cb381e7f63bef767a7d697fc5af13b43735c7a91b6357b95387b58665734ba3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANTIALIAS_NONE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2cb381e7f63bef767a7d697fc5af13b494e3797b8dcda3573e739c3276b9c77a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANTIALIAS_GRAY</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2cb381e7f63bef767a7d697fc5af13b4981aa2b3f2aef2f0f2e490cea6c3639a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ANTIALIAS_SUBPIXEL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>2cb381e7f63bef767a7d697fc5af13b43ee3d2f0eea97db29139eac7950269aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FillRule</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1ba15b0a2e22c87c14af044801006c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILL_RULE_WINDING</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1ba15b0a2e22c87c14af044801006c8564d7bbc3c2d92a1ce8b5e3ec7ea050f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILL_RULE_EVEN_ODD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1ba15b0a2e22c87c14af044801006c8525292f6e401747a4323ca3b83e3d4f0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>LineCap</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>bbb9aae64ef26733965e6d500ae76f1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_CAP_BUTT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>bbb9aae64ef26733965e6d500ae76f1ef3facd37abd0619faf1efe6c3b37ef72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_CAP_ROUND</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>bbb9aae64ef26733965e6d500ae76f1e05298af325e119d8cfbb6bf7f81f8255</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_CAP_SQUARE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>bbb9aae64ef26733965e6d500ae76f1e8462f35d238cdc413a90cf2ac37c35f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>LineJoin</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>dbc632404edaa736e01c12122239de73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_JOIN_MITER</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>dbc632404edaa736e01c12122239de73a63cde0bfd47a1d5a80f2db93b0de823</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_JOIN_ROUND</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>dbc632404edaa736e01c12122239de73b4e1dd72513958e037306b1fddab6440</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LINE_JOIN_BEVEL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>dbc632404edaa736e01c12122239de7363352551259f61a5e379589315a30de9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontSlant</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>0a2c19fefac301a702a6b7fdb368bf55</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_SLANT_NORMAL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>0a2c19fefac301a702a6b7fdb368bf55428cfea8fca5951033f3d433855cb97d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_SLANT_ITALIC</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>0a2c19fefac301a702a6b7fdb368bf55ffa4510656348999982452cab35cd50d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_SLANT_OBLIQUE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>0a2c19fefac301a702a6b7fdb368bf55b59432f2187bad6573e559810fe91727</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontWeight</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d8514818fb9292a5864b57f4b8a1e546</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_WEIGHT_NORMAL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d8514818fb9292a5864b57f4b8a1e546ccd31c17af7e0acce29f5d9df1b74e70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_WEIGHT_BOLD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d8514818fb9292a5864b57f4b8a1e546438bd2ac850ef23ce7a537ae3395f398</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Content</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1f0f5d82599dfeabbeb2396dbfd767d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONTENT_COLOR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1f0f5d82599dfeabbeb2396dbfd767d0a9223b86246bd608b91a8881e47cbf1a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONTENT_ALPHA</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1f0f5d82599dfeabbeb2396dbfd767d097d17d3896a8e8089b54f113bef09b4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONTENT_COLOR_ALPHA</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>1f0f5d82599dfeabbeb2396dbfd767d08c89da251cfcc2093c8f12c2f047b8bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Format</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b8759166</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORMAT_ARGB32</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b8759166fc97f1888578477fd656cf72d3421fbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORMAT_RGB24</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b8759166d8bdac2cab4a41442aa9a65a861a1f8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORMAT_A8</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b8759166014ebd0c5ac40d95635f498719d3be81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORMAT_A1</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b8759166562e3f4d6672c1d1d713805c1a1d0e2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FORMAT_RGB16_565</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>d3f86970e1bd354b263303c9b875916602af37bc588eaf452132b45eae083980</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Extend</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>e98882fd000921907007555a36a432a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTEND_NONE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>e98882fd000921907007555a36a432a5bc537645a0ee134db9f85b840ff31ecc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTEND_REPEAT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>e98882fd000921907007555a36a432a5441fb6974fa3eb7d20a8c4a23bac5b3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTEND_REFLECT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>e98882fd000921907007555a36a432a58d3a371a30c6ed16f370f3c1198f5f0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXTEND_PAD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>e98882fd000921907007555a36a432a5962ebab53840cfa2c8e2a6534c93a70d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Filter</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_FAST</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6a53741dee114adbbc9860ff6979044ee9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_GOOD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6a94fe587cf45f2ca0941eb81edc247a5c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_BEST</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6aa20fe9f49ecb50a8ca50adb840404bb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_NEAREST</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6a4c9be1534f351531eb1c70deb690926b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_BILINEAR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6ad2418ba123c6a441aefc0b22cba59758</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILTER_GAUSSIAN</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>92b32ad7db301e18386477566c1caa6a9681c5deb5aeac89bfcbec9734421169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SubpixelOrder</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b288783</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPIXEL_ORDER_DEFAULT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b288783d3e1bfde4f4ef4072fe7241151a9b400</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPIXEL_ORDER_RGB</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b288783b131d2776a0835afb077a46222056b86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPIXEL_ORDER_BGR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b28878391d7c3c2c36d11561d3bb4edc80f4754</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPIXEL_ORDER_VRGB</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b2887834a33b2508ecb3c7727993c642581ec89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBPIXEL_ORDER_VBGR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>4a23dc1a6008ac7395bd44767b288783c4aa9ec4bf74374f5114eeb4dbe8531e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>HintStyle</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_STYLE_DEFAULT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e4accef9b38249b23be976d7cf3c830511</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_STYLE_NONE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e46c6c834f7a2a4a916467cc56faf87899</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_STYLE_SLIGHT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e4622ff5142bc1ed463de74c10b094d7de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_STYLE_MEDIUM</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e486913e7e6f6e4a47a2ac9ffccc307be0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_STYLE_FULL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>42c908e3a6e1e7e402081b36659b42e42f1fbcf0e711122f6488788b93b64746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>HintMetrics</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>36aea516c8dd84609f7e5f5968a3d7c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_METRICS_DEFAULT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>36aea516c8dd84609f7e5f5968a3d7c00033f53b7ebd8d5080f2072e706c49eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_METRICS_OFF</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>36aea516c8dd84609f7e5f5968a3d7c04a0455b3f2057678f18f0bb468a480d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HINT_METRICS_ON</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>36aea516c8dd84609f7e5f5968a3d7c09df9bac60d68417bbc63d17075890d45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SurfaceType</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_IMAGE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe925490ecba6c968b41e0f20c04da907a9015c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_PDF</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549779d4582e7e57cc7fe8febe22d01c8f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_PS</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549965157adefd504ddb33443bae86bdaf0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_XLIB</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549557b12264bea7e9291a88a237006bb3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_XCB</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe9254996a97d03b0110b9f2eb1fa9940b3dd37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_GLITZ</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549ee5fa464493ed2f61f22873c3e5b9093</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_QUARTZ</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe9254937e0a949af7b4739b9bef045f60b4d0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_WIN32</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549c30d738b509c7fb082e8d7ba37f21203</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_BEOS</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe925495a984da99a0b5e90a0f0c28ef05b64af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_DIRECTFB</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe925498c4a28995e8ea61cc44386ffd4d4ed48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_SVG</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549abfee100acdb2044b01af44bf6a3441e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_OS2</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549a126fd2dfdb86c1671807f9c23bba160</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_WIN32_PRINTING</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549b516fc39323a2df146423d9eb9018c11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURFACE_TYPE_QUARTZ_IMAGE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>f11d962e38a38a2d92fc1473fbe92549fe4724b60fb5cd4d67187385c1160338</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PatternType</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>feff18f1043713479dd6ceb4aa4d4f02</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATTERN_TYPE_SOLID</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>feff18f1043713479dd6ceb4aa4d4f02cc00394b686b5a51707eb50507d0ff98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATTERN_TYPE_SURFACE</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>feff18f1043713479dd6ceb4aa4d4f02a3d3d979bffbe8abace7427d2b75f286</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATTERN_TYPE_LINEAR</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>feff18f1043713479dd6ceb4aa4d4f029e26bb15e701bef4ddd597c56dd9f3df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PATTERN_TYPE_RADIAL</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>feff18f1043713479dd6ceb4aa4d4f02e3d2664b903efd92b03cabe25a7467c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontType</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab522</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_TOY</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab52211badc6cb73857e765b9d08ae75d10e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_FT</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab5227780824d70ec08548798c075928e121c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_WIN32</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab522322154b778271602a36b8a777888cd30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_ATSUI</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab522e959d2d48f5b0f2110762d15eadf6ba9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_QUARTZ</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab522900b0adf7ea2cfed16956be0a26d3cff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FONT_TYPE_USER</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>23e1a9a5be49d16cf3871e841e8ab522d87ea398fb66e3b0df5b8a15685c2ea1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TextClusterFlags</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>61b770cf36c555a4098b5428e030542a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEXT_CLUSTER_FLAG_BACKWARD</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>61b770cf36c555a4098b5428e030542ad1fc31baabb2eaa7661a0b8a91ad3b03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PsLevel</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>452db49f19542c791e4a331f052a9a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PS_LEVEL_2</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>452db49f19542c791e4a331f052a9a007fba4425a32994189848015369c71db1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PS_LEVEL_3</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>452db49f19542c791e4a331f052a9a00e540de6bec8cf457548756a83457223b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SvgVersion</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>853a6353847b8cd86001a98d36b245ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SVG_VERSION_1_1</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>853a6353847b8cd86001a98d36b245caa2342af6873626640d2126f75fe0ab48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SVG_VERSION_1_2</name>
      <anchorfile>namespaceCairo.html</anchorfile>
      <anchor>853a6353847b8cd86001a98d36b245cac9a963a188f21ab16da513d4482fb7bd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Context</name>
    <filename>classCairo_1_1Context.html</filename>
    <member kind="typedef">
      <type>cairo_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>14e54b45199452f9916ebcafcd4a629e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Context</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>db2361743a9f017e662c3c6809dfc765</anchor>
      <arglist>(cairo_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Context</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>35d214d3ad4d29bd5993d683333a9791</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>5249fa850f6adc1cb743e60a65a1ddb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restore</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>45a80032b95d87eafe72dc2ab235f815</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_operator</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>61f276527b921cbd4fd81880ac372e2a</anchor>
      <arglist>(Operator op)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_source</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>534d571d5aa4b500782036202a3e2aea</anchor>
      <arglist>(const RefPtr&lt; const Pattern &gt; &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_source_rgb</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ff3f3fc62bdf862646bb8cc568c30b2a</anchor>
      <arglist>(double red, double green, double blue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_source_rgba</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>f9267aed8eb866701178dcada6c7e51a</anchor>
      <arglist>(double red, double green, double blue, double alpha)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_source</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d88c0ef8700410920b37833b8e6ed329</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; &amp;surface, double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_tolerance</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>01481a915f4086051f1c200f0f7a33d1</anchor>
      <arglist>(double tolerance)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_antialias</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>79220a6785490688fdea41750d8933d6</anchor>
      <arglist>(Antialias antialias)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fill_rule</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d15693ae817e3229409d831c7dd96bed</anchor>
      <arglist>(FillRule fill_rule)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_width</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>9ad2649d95e81a65aa0c581c4345375e</anchor>
      <arglist>(double width)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_cap</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>07fd8fc2c75558484e960c5ff63a61cc</anchor>
      <arglist>(LineCap line_cap)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_line_join</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>23b5ba9363f568cacc1abf5e79a0200d</anchor>
      <arglist>(LineJoin line_join)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dash</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>aa0b483d3f36facb1c9f2aa7f0a0ac13</anchor>
      <arglist>(std::valarray&lt; double &gt; &amp;dashes, double offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dash</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>de74abb6db86a97ff3800e431e27ba45</anchor>
      <arglist>(std::vector&lt; double &gt; &amp;dashes, double offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_dash</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>b20ad42403add42a9388b281074b77d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_miter_limit</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>583445ca963769d3f31613bc55b1e8ad</anchor>
      <arglist>(double limit)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translate</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>3058f50f915d9c43d165dfcd1a940cdc</anchor>
      <arglist>(double tx, double ty)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>45543fb03fb740fe4c013492f348e084</anchor>
      <arglist>(double sx, double sy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>332811cd74028c20b5832501ec46d67e</anchor>
      <arglist>(double angle_radians)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate_degrees</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>0ae251ef83d7c2985f4306abc905934d</anchor>
      <arglist>(double angle_degres)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>c520512061fa271fff3b1f922f94c9cb</anchor>
      <arglist>(const Matrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>1bb46fed0df67873bef36e8d7c515c5a</anchor>
      <arglist>(const cairo_matrix_t &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>c2eafbac5591e569d22495f7920d60d2</anchor>
      <arglist>(const Matrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>6d94c400c393d7e40bf2d2bbf4e6dcba</anchor>
      <arglist>(const cairo_matrix_t &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_identity_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a3e9b13312b6ef331830b5348093e19e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>user_to_device</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a9cc3eeb14b515b184be6a401c0993a4</anchor>
      <arglist>(double &amp;x, double &amp;y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>user_to_device_distance</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>b0daccfeaa8b173b26473e79271f7e88</anchor>
      <arglist>(double &amp;dx, double &amp;dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>device_to_user</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>0c7acaaf16d4740cd7fee2298bf2b5c4</anchor>
      <arglist>(double &amp;x, double &amp;y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>device_to_user_distance</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2f396567b0504d1421abb5f7ed38cd97</anchor>
      <arglist>(double &amp;dx, double &amp;dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>begin_new_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>527efe9a3a5bf48f768e223d5f4fecca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>begin_new_sub_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>8cb4b961893563c585ed05a67126b0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>4086700b5f780fd3fb94bea941895022</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>line_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>e305a9f8a79cc0e0693393a940ee1de8</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>curve_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>9bdb6a5e2ea0e4bc9441bdc5704805f7</anchor>
      <arglist>(double x1, double y1, double x2, double y2, double x3, double y3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>arc</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>aa96080beea581244f0a3838fb7c9ee6</anchor>
      <arglist>(double xc, double yc, double radius, double angle1, double angle2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>arc_negative</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>1a9e7517cd5afd49d729b8a87539a305</anchor>
      <arglist>(double xc, double yc, double radius, double angle1, double angle2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rel_move_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>3c739ac7e8e43d395f24dff0a0a83c0d</anchor>
      <arglist>(double dx, double dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rel_line_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>35f2d0f7e9afcb59eef83af3d2831f2b</anchor>
      <arglist>(double dx, double dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rel_curve_to</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d7660dac997d5db2f7ce1539c20345e2</anchor>
      <arglist>(double dx1, double dy1, double dx2, double dy2, double dx3, double dy3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rectangle</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>85ee124b89c43dc29ff0d964bd005c11</anchor>
      <arglist>(double x, double y, double width, double height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>32211b0684b1d264c17402b5289fcba0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paint</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d919eae3bc3b9827a3c1ceff2d86833e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paint_with_alpha</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>34208a6c6868cdcd65866cb8a2349525</anchor>
      <arglist>(double alpha)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mask</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2ad3ea59afb6bb4fa04d000f5e9c3cf2</anchor>
      <arglist>(const RefPtr&lt; const Pattern &gt; &amp;pattern)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mask</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2f76e3b13027efc4c8745de5e04e00ec</anchor>
      <arglist>(const RefPtr&lt; const Surface &gt; &amp;surface, double surface_x, double surface_y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stroke</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>8e4acbb44f4b3fac00ee93f6251d6d17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stroke_preserve</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>b10d89295e122b04ff1bbda425ae069c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>0a484790884dd138108b07c0ebbbe21d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_preserve</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>0ef3f887f91527a485ce1300972ac8e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_page</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>7ccbeacb2a7f2d787b3daf31a69383fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_page</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>525cac95b4d4c2abea12b82c433adba9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>in_stroke</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>15e153f40f02aaccd0aed27f7720bf6a</anchor>
      <arglist>(double x, double y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>in_fill</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>3d50e91f8ed135cee8741fef805df070</anchor>
      <arglist>(double x, double y) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_stroke_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>fbcad49bf4f75eca485fa4d728255ae0</anchor>
      <arglist>(double &amp;x1, double &amp;y1, double &amp;x2, double &amp;y2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_fill_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>80bceb0e11be82c365b4606efe3a8d30</anchor>
      <arglist>(double &amp;x1, double &amp;y1, double &amp;x2, double &amp;y2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_clip</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>82d001967dc8ba3e45f4d7a06c4b9ff2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clip</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>423077b911738772807cc8bc24c25488</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clip_preserve</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2987c4ecac0438ee808c34d3c35c7f2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_clip_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>7211a6110201b959ee46c47aa173b12a</anchor>
      <arglist>(double &amp;x1, double &amp;y1, double &amp;x2, double &amp;y2) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_clip_rectangle_list</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>7dc19917311f812e667d71102b0d986b</anchor>
      <arglist>(std::vector&lt; Rectangle &gt; &amp;rectangles) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>select_font_face</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>cb1da5f3949195f76424e11be923fbfd</anchor>
      <arglist>(const std::string &amp;family, FontSlant slant, FontWeight weight)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_size</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>c8a04a09c2e871a470fd030edb45b024</anchor>
      <arglist>(double size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>7981bd1109ec5538fb505b36ec377757</anchor>
      <arglist>(const Matrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ada6eda8880143f16721d6311206b25f</anchor>
      <arglist>(Matrix &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_options</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2d7f465d946804a8fe9877d7f7f4bbcb</anchor>
      <arglist>(const FontOptions &amp;options)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>8d44b4f4e45a4fb2a794f3486f895640</anchor>
      <arglist>(const cairo_matrix_t &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>34be6fb9a99354259d3944b1b31c634b</anchor>
      <arglist>(cairo_matrix_t &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_options</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>b69217658ea7fa4e859aa305e3bc3ebc</anchor>
      <arglist>(FontOptions &amp;options) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scaled_font</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>aa8c0b24d9338d392c18435babeb4263</anchor>
      <arglist>(const RefPtr&lt; const ScaledFont &gt; &amp;scaled_font)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; ScaledFont &gt;</type>
      <name>get_scaled_font</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>511ca42d6c21a4cfc9ce4c4b1116ddad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_text</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>584596d6f12dbea30519b908cacce038</anchor>
      <arglist>(const std::string &amp;utf8)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_glyphs</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>f51f2c2ff72e8af66abeea3d15d25553</anchor>
      <arglist>(const std::vector&lt; Glyph &gt; &amp;glyphs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_text_glyphs</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>45723fd605cc2343ab46cf603d330002</anchor>
      <arglist>(const std::string &amp;utf8, const std::vector&lt; Glyph &gt; &amp;glyphs, const std::vector&lt; TextCluster &gt; &amp;clusters, TextClusterFlags cluster_flags)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; FontFace &gt;</type>
      <name>get_font_face</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a3606d313d54bc1b26938a8dfadc1e94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; const FontFace &gt;</type>
      <name>get_font_face</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>02c602da267ff6c0b29d638f4a59a158</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>cbe72f83295624f8905a350c589e7209</anchor>
      <arglist>(FontExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_font_face</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>9b344db51097aba30e36452e1364faef</anchor>
      <arglist>(const RefPtr&lt; const FontFace &gt; &amp;font_face)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_text_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>837ff58a69e3e74f6a6ef9da8454af2b</anchor>
      <arglist>(const std::string &amp;utf8, TextExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_glyph_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>fa37e5c6559f2573cfc55bb6fa5f6ef6</anchor>
      <arglist>(const std::vector&lt; Glyph &gt; &amp;glyphs, TextExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>text_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>5613b4202f82f6a53f1aeac6c58e5521</anchor>
      <arglist>(const std::string &amp;utf8)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>glyph_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d3372fc30d9a26c8d26c440a21464ce5</anchor>
      <arglist>(const std::vector&lt; Glyph &gt; &amp;glyphs)</arglist>
    </member>
    <member kind="function">
      <type>Operator</type>
      <name>get_operator</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a5683fc9da28916cb237b4868a9c5d97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; Pattern &gt;</type>
      <name>get_source</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>0b6eeda4d80f3d591a770cbbbf8a0c87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; const Pattern &gt;</type>
      <name>get_source</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a17cc0c92671d0d4c2d48bc3a79858d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_tolerance</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>216632e43aa061890c0a637ea41f7960</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Antialias</type>
      <name>get_antialias</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>3269ed87a45ce150d1b7bd00c1c18a80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_current_point</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>69b25af8a2bac826a330e1bfeb2f1a1f</anchor>
      <arglist>(double &amp;x, double &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_current_point</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>1db62850e9879589bacd463e54406b50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FillRule</type>
      <name>get_fill_rule</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>21a26ea9c08bb3c9c4180635f58fa7f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_line_width</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>2aacb5cd843266b708ae47bc9a4f7014</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>LineCap</type>
      <name>get_line_cap</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>af84f561587f41a6cdaffe8024ebf96c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>LineJoin</type>
      <name>get_line_join</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>543677421cced4e1eca10f70dd36220f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_miter_limit</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>55c7e2c0533e35635c31c34ec498a4a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_dash</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>aa43d0034e155d3c0244e0b4fdaf6af9</anchor>
      <arglist>(std::vector&lt; double &gt; &amp;dashes, double &amp;offset) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>03b21f4a3a44e28086c3a25075fdcea1</anchor>
      <arglist>(Matrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ea651404be2fa942033c636e2665cd7e</anchor>
      <arglist>(cairo_matrix_t &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>99cadcdd63e366bc793306e8d3cfee37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; Surface &gt;</type>
      <name>get_target</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ea76bccc09bdab482f96469a4e7f94f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; const Surface &gt;</type>
      <name>get_target</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>39f36fa1f1460ca8a7f0504f01cb4d90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Path *</type>
      <name>copy_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>48743c731a58fb25524593dc90b567b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_path_extents</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>28d0fa55e1d478ec05975b3c9f545c53</anchor>
      <arglist>(double &amp;x1, double &amp;y1, double &amp;x2, double &amp;y2) const </arglist>
    </member>
    <member kind="function">
      <type>Path *</type>
      <name>copy_path_flat</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>5213dad7e0b0054d631053abe0df1c7d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_path</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ee34ef17540ad11f33176e8897d73203</anchor>
      <arglist>(const Path &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_group</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>a0a5a1ee48ff742d87480a689dca51c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_group_with_content</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d08812ecb59891f92e79a3d4dbca2d97</anchor>
      <arglist>(Content content)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; Pattern &gt;</type>
      <name>pop_group</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>ece6278f4d71ce652557c80788415711</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_group_to_source</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>bd11fa1d3a582e0975ebb0155b9d4467</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; Surface &gt;</type>
      <name>get_group_target</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>d75b7d22f76958a6651e9f02172525f8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; const Surface &gt;</type>
      <name>get_group_target</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>6908784c77134e45b09bd1ff4bcb34c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>614bcb4e9570c5b5c54b3bfc304c194a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>e99b48b6e596f42a7ccb90ab4ae94074</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Context &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>9a27f6ec57d788fd3ecbc310aeb24d99</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; &amp;target)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Context</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>c3c5491dbf6e57a26369e987361f6cd8</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; &amp;target)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1Context.html</anchorfile>
      <anchor>620db06ff96d42e8e1db12ada0435fcc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::logic_error</name>
    <filename>classCairo_1_1logic__error.html</filename>
    <base>std::logic_error</base>
    <member kind="function">
      <type></type>
      <name>logic_error</name>
      <anchorfile>classCairo_1_1logic__error.html</anchorfile>
      <anchor>11d3b1f7a00aa8cdb44107949f305648</anchor>
      <arglist>(ErrorStatus status)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~logic_error</name>
      <anchorfile>classCairo_1_1logic__error.html</anchorfile>
      <anchor>67fb59dc50e4ddf1bd0725e98bd47683</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ErrorStatus</type>
      <name>get_status_code</name>
      <anchorfile>classCairo_1_1logic__error.html</anchorfile>
      <anchor>271e6fb7ffdf4c7e517e5b1468cbf1c6</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::FontFace</name>
    <filename>classCairo_1_1FontFace.html</filename>
    <member kind="typedef">
      <type>cairo_font_face_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>b1631f7eb6458a98be291880a1dde3d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FontFace</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>f464d8f051930da555fcbf632add755d</anchor>
      <arglist>(cairo_font_face_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FontFace</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>a5d84dba43cd09c1710b458132a9ab8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FontType</type>
      <name>get_type</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>201bec9a38120a2f77b56c2e61c0a481</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>c8b43511916adc955411051e3a29b53a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>af59eb8a1bd2a51e4d9c850279ae6bd6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>33876cc188930bf2ecbcd43c8604267b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>603f1045e7fed08f9e3001be69c2bb56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1FontFace.html</anchorfile>
      <anchor>e2d03f09adca1b8f9008680f0e831b0c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::ToyFontFace</name>
    <filename>classCairo_1_1ToyFontFace.html</filename>
    <base>Cairo::FontFace</base>
    <member kind="function">
      <type>std::string</type>
      <name>get_family</name>
      <anchorfile>classCairo_1_1ToyFontFace.html</anchorfile>
      <anchor>9574c9445d16c98bd23c9a1d9360c75e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FontSlant</type>
      <name>get_slant</name>
      <anchorfile>classCairo_1_1ToyFontFace.html</anchorfile>
      <anchor>377f091bdfa7695f97e0e7b0ca044854</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FontWeight</type>
      <name>get_weight</name>
      <anchorfile>classCairo_1_1ToyFontFace.html</anchorfile>
      <anchor>bb186cefab7692e5e2d9f9029797ff87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ToyFontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1ToyFontFace.html</anchorfile>
      <anchor>07c0ca7fd0dc54c31bfa1d8a813aff59</anchor>
      <arglist>(const std::string &amp;family, FontSlant slant, FontWeight weight)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ToyFontFace</name>
      <anchorfile>classCairo_1_1ToyFontFace.html</anchorfile>
      <anchor>78612cc2a17fda1953c54ef15bc84dcf</anchor>
      <arglist>(const std::string &amp;family, FontSlant slant, FontWeight weight)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::UserFontFace</name>
    <filename>classCairo_1_1UserFontFace.html</filename>
    <base>Cairo::FontFace</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UserFontFace</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>e62d6b0a239f47fd67bda4b182187d62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ErrorStatus</type>
      <name>init</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>f3f1d3a53a7be1d84a20609984473e07</anchor>
      <arglist>(const RefPtr&lt; ScaledFont &gt; &amp;scaled_font, const RefPtr&lt; Context &gt; &amp;cr, FontExtents &amp;extents)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ErrorStatus</type>
      <name>unicode_to_glyph</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>43cd65b62eab686477d3773e6fd98b46</anchor>
      <arglist>(const RefPtr&lt; ScaledFont &gt; &amp;scaled_font, unsigned long unicode, unsigned long &amp;glyph)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual ErrorStatus</type>
      <name>render_glyph</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>2e53435e92f9975213bd19969cb69375</anchor>
      <arglist>(const RefPtr&lt; ScaledFont &gt; &amp;scaled_font, unsigned long glyph, const RefPtr&lt; Context &gt; &amp;cr, TextExtents &amp;metrics)=0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual ErrorStatus</type>
      <name>text_to_glyphs</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>467db4c4a08c8cced992045d791e65f2</anchor>
      <arglist>(const RefPtr&lt; ScaledFont &gt; &amp;scaled_font, const std::string &amp;utf8, std::vector&lt; Glyph &gt; &amp;glyphs, std::vector&lt; TextCluster &gt; &amp;clusters, TextClusterFlags &amp;cluster_flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UserFontFace</name>
      <anchorfile>classCairo_1_1UserFontFace.html</anchorfile>
      <anchor>a63810b6ea9db5b62986e6ce9b7fa13a</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::FtFontFace</name>
    <filename>classCairo_1_1FtFontFace.html</filename>
    <base>Cairo::FontFace</base>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; FtFontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1FtFontFace.html</anchorfile>
      <anchor>f0c442d25f8615efb7655a6ae9279d3e</anchor>
      <arglist>(FT_Face face, int load_flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; FtFontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1FtFontFace.html</anchorfile>
      <anchor>eedb6692fef3a1c4d13dd52792a2267b</anchor>
      <arglist>(FcPattern *pattern)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FtFontFace</name>
      <anchorfile>classCairo_1_1FtFontFace.html</anchorfile>
      <anchor>82d1ff7fb040ba4209511c4e4fbc57f5</anchor>
      <arglist>(FT_Face face, int load_flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FtFontFace</name>
      <anchorfile>classCairo_1_1FtFontFace.html</anchorfile>
      <anchor>76879f412bddbfa3b6c2350c3fa69aa6</anchor>
      <arglist>(FcPattern *pattern)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::FontOptions</name>
    <filename>classCairo_1_1FontOptions.html</filename>
    <member kind="typedef">
      <type>cairo_font_options_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>458ecd8eb6ab6cbe9d0f70720504dc19</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FontOptions</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>2b818a9af6d23ad39fb4e2ce74d24df6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FontOptions</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>475377dfa1550fbaed93e3b3a79d96e8</anchor>
      <arglist>(cairo_font_options_t *cobject, bool take_ownership=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FontOptions</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>3b10ebfd94fc8f8c047a85d4400ced7b</anchor>
      <arglist>(const FontOptions &amp;src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FontOptions</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>27f29f5bb5191d6202eeeaa6c5485cbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FontOptions &amp;</type>
      <name>operator=</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>b89251971e798b5998fba7cfd73d8d93</anchor>
      <arglist>(const FontOptions &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>941cd1d37b4058f1b48b2752fc0cf07f</anchor>
      <arglist>(const FontOptions &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>merge</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>e64b209cc8200f786d07185fc93552ed</anchor>
      <arglist>(const FontOptions &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>hash</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>941f12713ba5f746b47fdc2b91ad01c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_antialias</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>c4805f8378e318a2ad52803285b7e7de</anchor>
      <arglist>(Antialias antialias)</arglist>
    </member>
    <member kind="function">
      <type>Antialias</type>
      <name>get_antialias</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>e93654769d65365c4110e8ce8a56cf7c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_subpixel_order</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>e0d566a662586651501920525bfb7dcd</anchor>
      <arglist>(SubpixelOrder subpixel_order)</arglist>
    </member>
    <member kind="function">
      <type>SubpixelOrder</type>
      <name>get_subpixel_order</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>30a7fe796cfe5c9d6ea4bdeb535834f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hint_style</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>58b4368e78a15f4c63766b5a47fd951b</anchor>
      <arglist>(HintStyle hint_style)</arglist>
    </member>
    <member kind="function">
      <type>HintStyle</type>
      <name>get_hint_style</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>840678ca69c3e852b6ed05a1e35329e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_hint_metrics</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>c8ab52d886380075adc27d86ade70c01</anchor>
      <arglist>(HintMetrics hint_metrics)</arglist>
    </member>
    <member kind="function">
      <type>HintMetrics</type>
      <name>get_hint_metrics</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>f74acf1959d5e96800ff43a393e34308</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>substitute</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>e42f40768de7a6f0da085a4940dc6ce3</anchor>
      <arglist>(FcPattern *pattern)</arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>dd7c818b1a6c6bff15199407d8b18a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>f826edc2b8a7b6c3cf4a44940f135d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1FontOptions.html</anchorfile>
      <anchor>e64f21fb1def665db48a8d3adfe5db56</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Matrix</name>
    <filename>classCairo_1_1Matrix.html</filename>
    <base>cairo_matrix_t</base>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>69297a4b8adc2bdecece4c372edc1e63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>90a6fe36d7744bfd607c2b37435ca8e6</anchor>
      <arglist>(double xx, double yx, double xy, double yy, double x0, double y0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translate</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>ec65d01b5251144dc20708f0b05940f6</anchor>
      <arglist>(double tx, double ty)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>697c488fb323f4a6edda4edd0533c95c</anchor>
      <arglist>(double sx, double sy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotate</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>98b3feae5ff15937c764ebec846efb33</anchor>
      <arglist>(double radians)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invert</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>3ad532fa3b90ac4019d6a535ffde0cd4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multiply</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>748df1dafe6a35422fa51b31f6932587</anchor>
      <arglist>(Matrix &amp;a, Matrix &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform_distance</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>7966181b002249878a895bb3911f39e8</anchor>
      <arglist>(double &amp;dx, double &amp;dy) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform_point</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>f0b0ac8dd645036fdd4a3ee54cdcaca6</anchor>
      <arglist>(double &amp;x, double &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>identity_matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>293cbaf13eb86244648cb558b2cf7dd3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>translation_matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>e638d4c68c7f26f9760335eb42680cea</anchor>
      <arglist>(double tx, double ty)</arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>scaling_matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>c217befdf043bdb5f1c29632e60cbdef</anchor>
      <arglist>(double sx, double sy)</arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>rotation_matrix</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>324cadc45a2fe7424cb0d0d6b73ccbe8</anchor>
      <arglist>(double radians)</arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>operator*</name>
      <anchorfile>classCairo_1_1Matrix.html</anchorfile>
      <anchor>b0bbb2ec9c1451f42f0270652df8cada</anchor>
      <arglist>(const Matrix &amp;a, const Matrix &amp;b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Path</name>
    <filename>classCairo_1_1Path.html</filename>
    <member kind="typedef">
      <type>cairo_path_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>2cd038a379ec386714ca49c9ab4c830b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Path</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>a4d8ed387279e475eaca70cc80fbb8f3</anchor>
      <arglist>(cairo_path_t *cobject, bool take_ownership=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Path</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>92f1cc9c567db4b76fa45a7f5a2cbbe5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>946d943be638ee1fa8a25ad88adad0a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>62d785be49961bd1bfe1a47605454770</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1Path.html</anchorfile>
      <anchor>e0b434d3681baf1ad366acd762a9f780</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Cairo::ColorStop</name>
    <filename>structCairo_1_1ColorStop.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>offset</name>
      <anchorfile>structCairo_1_1ColorStop.html</anchorfile>
      <anchor>f72e052087d61385d988b7134107a1a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>red</name>
      <anchorfile>structCairo_1_1ColorStop.html</anchorfile>
      <anchor>dbdcec948c42c467bdbfb9aa61427356</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>green</name>
      <anchorfile>structCairo_1_1ColorStop.html</anchorfile>
      <anchor>06929ffc17da4af254cc2f2a4cc09f1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>blue</name>
      <anchorfile>structCairo_1_1ColorStop.html</anchorfile>
      <anchor>dcd9c23cf18fc73cf10045a05b8f4e16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>alpha</name>
      <anchorfile>structCairo_1_1ColorStop.html</anchorfile>
      <anchor>524397babe94f70ed6205433066e2649</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Pattern</name>
    <filename>classCairo_1_1Pattern.html</filename>
    <member kind="typedef">
      <type>cairo_pattern_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>430a261a68ae70ca1bd818c781178abc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Pattern</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>2da16a5296c06b65867a1a99e47a4d82</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Pattern</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>62ac06285957869744411527bfb25298</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_matrix</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>09dbb1295ba0a4f8a92b571aa6e425af</anchor>
      <arglist>(const Matrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>bc04baecc72eb1feda0c96592a22276a</anchor>
      <arglist>(Matrix &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>Matrix</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>04dd241769520a787dbebd5907b55f87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_matrix</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>a50a29b9d4c669766355c917ab30b858</anchor>
      <arglist>(const cairo_matrix_t &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_matrix</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>1a5a5ecfee3f2878c5a96ed6f1e9f11c</anchor>
      <arglist>(cairo_matrix_t &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>PatternType</type>
      <name>get_type</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>9e82fd8de9147e0b6bdb70e5186d1d80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>27bde17e9c41b6c826999f0f1a50aa8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>685e45ce1f593980d0037e7f780d2601</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>4755e9b4ad8fb4bb760abe81438f553a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>4cd12b946da697a673bc02b73eca0a04</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Pattern</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>41846b1a43050f7ea9aed51bba572247</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1Pattern.html</anchorfile>
      <anchor>24fdc166f53a833ba1e1104a5690efbc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::SolidPattern</name>
    <filename>classCairo_1_1SolidPattern.html</filename>
    <base>Cairo::Pattern</base>
    <member kind="function">
      <type></type>
      <name>SolidPattern</name>
      <anchorfile>classCairo_1_1SolidPattern.html</anchorfile>
      <anchor>ac3f148e302049ae30954f946efda12a</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_rgba</name>
      <anchorfile>classCairo_1_1SolidPattern.html</anchorfile>
      <anchor>fd6474afeed00c78e2a1ca064ca0a981</anchor>
      <arglist>(double &amp;red, double &amp;green, double &amp;blue, double &amp;alpha) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SolidPattern</name>
      <anchorfile>classCairo_1_1SolidPattern.html</anchorfile>
      <anchor>54df18171d8c26bece8b4beb51437ae0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SolidPattern &gt;</type>
      <name>create_rgb</name>
      <anchorfile>classCairo_1_1SolidPattern.html</anchorfile>
      <anchor>1eb2059ce24fc259675dadb23eb26ced</anchor>
      <arglist>(double red, double green, double blue)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SolidPattern &gt;</type>
      <name>create_rgba</name>
      <anchorfile>classCairo_1_1SolidPattern.html</anchorfile>
      <anchor>721c328ab43da6f23192bf4b18facd6e</anchor>
      <arglist>(double red, double green, double blue, double alpha)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::SurfacePattern</name>
    <filename>classCairo_1_1SurfacePattern.html</filename>
    <base>Cairo::Pattern</base>
    <member kind="function">
      <type></type>
      <name>SurfacePattern</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>9461babece82be067b48e6491c7ab1ad</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; const Surface &gt;</type>
      <name>get_surface</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>ad4763fd999ca2dc1094b07e5f357646</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; Surface &gt;</type>
      <name>get_surface</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>c830d137dad794e71d7bf83df22f06ae</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SurfacePattern</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>a1796fde1cf9f134387057d03df83a61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_extend</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>8b238004a061f34425ee61a2ba494632</anchor>
      <arglist>(Extend extend)</arglist>
    </member>
    <member kind="function">
      <type>Extend</type>
      <name>get_extend</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>45055101fc89432f9ce1438878a6d0c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_filter</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>4d1517f554ffb2821e939aed01899022</anchor>
      <arglist>(Filter filter)</arglist>
    </member>
    <member kind="function">
      <type>Filter</type>
      <name>get_filter</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>cbaef3a3961c04c275b6e44fea323b42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SurfacePattern &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>eb0cd6f03f993c6c9e64b32cc805fd77</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; &amp;surface)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SurfacePattern</name>
      <anchorfile>classCairo_1_1SurfacePattern.html</anchorfile>
      <anchor>69b713eb59cec9ef25f586d6f14c2dda</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; &amp;surface)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Gradient</name>
    <filename>classCairo_1_1Gradient.html</filename>
    <base>Cairo::Pattern</base>
    <member kind="function">
      <type></type>
      <name>Gradient</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>85f7dabff18993648a3e920eb7a8eb04</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Gradient</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>b14387f9054c5c8222452743d72d616b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_color_stop_rgb</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>fe5e5167dd48fc684c7e88ea07340a6c</anchor>
      <arglist>(double offset, double red, double green, double blue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_color_stop_rgba</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>688da07943fa37f8ccbe33c379544d9f</anchor>
      <arglist>(double offset, double red, double green, double blue, double alpha)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; ColorStop &gt;</type>
      <name>get_color_stops</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>bce464810b8a65c5804146fb5474c5cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Gradient</name>
      <anchorfile>classCairo_1_1Gradient.html</anchorfile>
      <anchor>e50ccbfd16c1a03cd26b574ac4cd7533</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::LinearGradient</name>
    <filename>classCairo_1_1LinearGradient.html</filename>
    <base>Cairo::Gradient</base>
    <member kind="function">
      <type></type>
      <name>LinearGradient</name>
      <anchorfile>classCairo_1_1LinearGradient.html</anchorfile>
      <anchor>2dea1c14f7c79bac3daa271a3ddbcca6</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_linear_points</name>
      <anchorfile>classCairo_1_1LinearGradient.html</anchorfile>
      <anchor>f885258cb4833bec0e0a84476b52340f</anchor>
      <arglist>(double &amp;x0, double &amp;y0, double &amp;x1, double &amp;y1) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LinearGradient</name>
      <anchorfile>classCairo_1_1LinearGradient.html</anchorfile>
      <anchor>4a31b3447c1e3370bd9ec6d72f4324be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; LinearGradient &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1LinearGradient.html</anchorfile>
      <anchor>da4b398d3c60dec6f650e940b2117f71</anchor>
      <arglist>(double x0, double y0, double x1, double y1)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>LinearGradient</name>
      <anchorfile>classCairo_1_1LinearGradient.html</anchorfile>
      <anchor>f6b8e8e36eca93bbc6abbd85955299fe</anchor>
      <arglist>(double x0, double y0, double x1, double y1)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::RadialGradient</name>
    <filename>classCairo_1_1RadialGradient.html</filename>
    <base>Cairo::Gradient</base>
    <member kind="function">
      <type></type>
      <name>RadialGradient</name>
      <anchorfile>classCairo_1_1RadialGradient.html</anchorfile>
      <anchor>6388284de673c81f1d535ff866ce11ca</anchor>
      <arglist>(cairo_pattern_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_radial_circles</name>
      <anchorfile>classCairo_1_1RadialGradient.html</anchorfile>
      <anchor>16ec007a620a4836c2fcea7107f480a1</anchor>
      <arglist>(double &amp;x0, double &amp;y0, double &amp;r0, double &amp;x1, double &amp;y1, double &amp;r1) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~RadialGradient</name>
      <anchorfile>classCairo_1_1RadialGradient.html</anchorfile>
      <anchor>8f39d07709792f5abd75705e5852d3dd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; RadialGradient &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1RadialGradient.html</anchorfile>
      <anchor>6cf02d90cf1099cfaf085799547db02d</anchor>
      <arglist>(double cx0, double cy0, double radius0, double cx1, double cy1, double radius1)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>RadialGradient</name>
      <anchorfile>classCairo_1_1RadialGradient.html</anchorfile>
      <anchor>59e11d5b13e489bcb590db3152dcfb4f</anchor>
      <arglist>(double cx0, double cy0, double radius0, double cx1, double cy1, double radius1)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::QuartzFontFace</name>
    <filename>classCairo_1_1QuartzFontFace.html</filename>
    <base>Cairo::FontFace</base>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; QuartzFontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1QuartzFontFace.html</anchorfile>
      <anchor>4a9543947dccafb7c08e8a10c0b0a7fa</anchor>
      <arglist>(CGFontRef font)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; QuartzFontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1QuartzFontFace.html</anchorfile>
      <anchor>cf2559b93b2026dbb5dec7fc2e9e510a</anchor>
      <arglist>(ATSUFontID font_id)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>QuartzFontFace</name>
      <anchorfile>classCairo_1_1QuartzFontFace.html</anchorfile>
      <anchor>ce6647ef3cb71b1cae90be9bcc32e973</anchor>
      <arglist>(CGFontRef font)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>QuartzFontFace</name>
      <anchorfile>classCairo_1_1QuartzFontFace.html</anchorfile>
      <anchor>c7df53f82e992f2db387295f8b1d91a1</anchor>
      <arglist>(ATSUFontID font_id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::QuartzSurface</name>
    <filename>classCairo_1_1QuartzSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>QuartzSurface</name>
      <anchorfile>classCairo_1_1QuartzSurface.html</anchorfile>
      <anchor>14fa4758ee13f117df028455c434c950</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~QuartzSurface</name>
      <anchorfile>classCairo_1_1QuartzSurface.html</anchorfile>
      <anchor>bc137ab5872ea08b8cb487a026b87321</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>CGContextRef</type>
      <name>get_cg_context</name>
      <anchorfile>classCairo_1_1QuartzSurface.html</anchorfile>
      <anchor>db20c77cc96f4716ef0b3634d3689d63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; QuartzSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1QuartzSurface.html</anchorfile>
      <anchor>c8d11fe174bd9e4480da10a1696d6297</anchor>
      <arglist>(CGContextRef cg_context, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; QuartzSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1QuartzSurface.html</anchorfile>
      <anchor>d83e737c882fb32811a1adcb4832721f</anchor>
      <arglist>(Format format, int width, int height)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::RefPtr</name>
    <filename>classCairo_1_1RefPtr.html</filename>
    <templarg>T_CppObject</templarg>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>ff19258db23434b3d41db0488b9249ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>227899cc9f00a7f4fce1f14cf73249d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>15f8fd5fdb043ef974e8f56b2fcc3d67</anchor>
      <arglist>(T_CppObject *pCppObject)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>cb129373ab925b608bb542edc4a35e07</anchor>
      <arglist>(T_CppObject *pCppObject, int *refcount)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>2abb53dbe20af15dcfb9903df9c336d5</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RefPtr</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>9f908e85eb371b62739fc04df304ab0e</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>52edce24b7b132ba4ff2f8ef0571bb46</anchor>
      <arglist>(RefPtr&lt; T_CppObject &gt; &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; T_CppObject &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>f02d3fb424f50e0f0ed1443709d38c5e</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; T_CppObject &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>c82b7f2edd6f88c60be74b12af8e717a</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>8270e1280138a5e2c1ec7775a05b9ded</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>70e5c59dcd60f1fe8b0e2fb33d9bae31</anchor>
      <arglist>(const RefPtr&lt; T_CppObject &gt; &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>T_CppObject *</type>
      <name>operator-&gt;</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>e46ca4c9c90e3dd6a01e2d06a9b7504d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>391b39a970de38580e3dc074b08f225f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>9c00d0d5e9a924520413869bcf162d2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_dynamic</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>6858cff2dc6fbe3b44cad59589d73628</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_static</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>d94b14307bcb276fa9fa2ea69bb57e43</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; T_CppObject &gt;</type>
      <name>cast_const</name>
      <anchorfile>classCairo_1_1RefPtr.html</anchorfile>
      <anchor>95662b0f276cecb068bb6027f34e3b9b</anchor>
      <arglist>(const RefPtr&lt; T_CastFrom &gt; &amp;src)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::ScaledFont</name>
    <filename>classCairo_1_1ScaledFont.html</filename>
    <member kind="typedef">
      <type>cairo_scaled_font_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>2d6be7ee16b4cbdcff67e6fdf3682b2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>db6a80b560e695f10e39810bfede01b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>59b9ad6357e84be0e020ae163eeb7ffc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScaledFont</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>4407baae7eda0bf820e7c38596edcf7f</anchor>
      <arglist>(cobject *cobj, bool has_reference=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ScaledFont</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>09ca7c3ff04102bd54c3898f740eea3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>bd99255e4eb802e9350143ec81a197af</anchor>
      <arglist>(FontExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>a64969e519ce44fba35f2061594e6f81</anchor>
      <arglist>(FontExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_text_extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>757a8effcae445a5c46bf4501424abae</anchor>
      <arglist>(const std::string &amp;utf8, TextExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>text_extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>396afc516d53234a04e81693a75b0203</anchor>
      <arglist>(const std::string &amp;utf8, TextExtents &amp;extents) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_glyph_extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>abfe38c6ca3e1c575b85aa7094e8601d</anchor>
      <arglist>(const std::vector&lt; Glyph &gt; &amp;glyphs, TextExtents &amp;extents)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>glyph_extents</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>859bbee5886b15e1d8ab599dabab9833</anchor>
      <arglist>(const std::vector&lt; Glyph &gt; &amp;glyphs, TextExtents &amp;extents)</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; FontFace &gt;</type>
      <name>get_font_face</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>c20c70e78e70276842ab460bdc75513e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_options</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>77b387d0cd3f23a71997d3719e270fd6</anchor>
      <arglist>(FontOptions &amp;options) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_matrix</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>3f4c3924cc10b3cffb025b6f6fa2e13b</anchor>
      <arglist>(Matrix &amp;font_matrix) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_matrix</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>ba264e1844f7fe7704115a984a39f437</anchor>
      <arglist>(cairo_matrix_t &amp;font_matrix) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_ctm</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>2ecb41822d51284c2f52a83b05cede8e</anchor>
      <arglist>(Matrix &amp;ctm) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_ctm</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>86b6d3179b10491e2c755b886ef49b9e</anchor>
      <arglist>(cairo_matrix_t &amp;ctm) const </arglist>
    </member>
    <member kind="function">
      <type>FontType</type>
      <name>get_type</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>eabb462f690ec9e22fc0096af38c46bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>text_to_glyphs</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>bf1bb0d07de65cc8d8f7e64d83f0be26</anchor>
      <arglist>(double x, double y, const std::string &amp;utf8, std::vector&lt; Glyph &gt; &amp;glyphs, std::vector&lt; TextCluster &gt; &amp;clusters, TextClusterFlags &amp;cluster_flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_scale_matrix</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>c31d37dc06c1a95830cb9e30425f609c</anchor>
      <arglist>(Matrix &amp;scale_matrix) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ScaledFont &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>dddf87ea689711ddbbee3028ed30e02b</anchor>
      <arglist>(const RefPtr&lt; FontFace &gt; &amp;font_face, const Matrix &amp;font_matrix, const Matrix &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ScaledFont &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>2d422798461d1ad67d0191b71df1c25e</anchor>
      <arglist>(const RefPtr&lt; FontFace &gt; &amp;font_face, const cairo_matrix_t &amp;font_matrix, const cairo_matrix_t &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ScaledFont</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>ca31f49f3121d2a6673205bebe7720c0</anchor>
      <arglist>(const RefPtr&lt; FontFace &gt; &amp;font_face, const cairo_matrix_t &amp;font_matrix, const cairo_matrix_t &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1ScaledFont.html</anchorfile>
      <anchor>a6f45de0a89807dd6678029807227757</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::FtScaledFont</name>
    <filename>classCairo_1_1FtScaledFont.html</filename>
    <base>Cairo::ScaledFont</base>
    <member kind="function">
      <type>FT_Face</type>
      <name>lock_face</name>
      <anchorfile>classCairo_1_1FtScaledFont.html</anchorfile>
      <anchor>8b1153077c36a983a8f9176e554ce980</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlock_face</name>
      <anchorfile>classCairo_1_1FtScaledFont.html</anchorfile>
      <anchor>3b56b2e107f3119bca0a934926dce66e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; FtScaledFont &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1FtScaledFont.html</anchorfile>
      <anchor>3c247841af3702cd28ab89b9f843a67e</anchor>
      <arglist>(const RefPtr&lt; FtFontFace &gt; &amp;font_face, const Matrix &amp;font_matrix, const Matrix &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FtScaledFont</name>
      <anchorfile>classCairo_1_1FtScaledFont.html</anchorfile>
      <anchor>809853982f391540df5ac1c124477d65</anchor>
      <arglist>(const RefPtr&lt; FtFontFace &gt; &amp;font_face, const Matrix &amp;font_matrix, const Matrix &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Surface</name>
    <filename>classCairo_1_1Surface.html</filename>
    <member kind="typedef">
      <type>sigc::slot&lt; ErrorStatus, const unsigned char *, unsigned int &gt;</type>
      <name>SlotWriteFunc</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>02fb9416d466b762bc5845b0ae204f49</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; ErrorStatus, unsigned char *, unsigned int &gt;</type>
      <name>SlotReadFunc</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>f66be8453e3fc558ea1282a911bf60e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cairo_surface_t</type>
      <name>cobject</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>d176eb7343b5902df3c19f9f56e59fb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Surface</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>47b90669a5a85d187cc0d28dc99915c8</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Surface</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>64ca52e9e8e9a64358ff85e6ef0d93c1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_font_options</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>7e3dd712e398719315bbd89efe9af0b2</anchor>
      <arglist>(FontOptions &amp;options) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>finish</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>8d8afee4ddb4935b85698f27099646a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>8f95678918fb40bae15f8aad2adb6ef2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark_dirty</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>77b1f860cc55f4ad168e100108e0b7bb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark_dirty</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>1dbf3a036b7dc7c09fc86996ea1ee61f</anchor>
      <arglist>(int x, int y, int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_device_offset</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>957e290a548d3cba65aa9e3fd0c86180</anchor>
      <arglist>(double x_offset, double y_offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_device_offset</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>5861783d0f5f3b396f52791a93e668fe</anchor>
      <arglist>(double &amp;x_offset, double &amp;y_offset) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_fallback_resolution</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>c8caca30702fe2bd69ae89929ee784e8</anchor>
      <arglist>(double x_pixels_per_inch, double y_pixels_per_inch)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_fallback_resolution</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>a3a8d5a2b5c91d11f7758d0a67f6093a</anchor>
      <arglist>(double &amp;x_pixels_per_inch, double &amp;y_pixels_per_inch) const </arglist>
    </member>
    <member kind="function">
      <type>SurfaceType</type>
      <name>get_type</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>7ee0760ea1895f5e6c8f6673f83cc072</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Content</type>
      <name>get_content</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>5fe39669b1d4239f3e4f73a8bf5105a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_page</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>ae22bcaa9becbf3ca703a380f70c2c0a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show_page</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>d318acd86c1875854ef4e1e2867052c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_show_text_glyphs</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>e4e133bf758c85195db6d3ccfbe1d54a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_to_png</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>153405d271814ab4d47b90a1c36d2370</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_to_png_stream</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>b3eca5bc13abe27f470fdf08134269bb</anchor>
      <arglist>(const SlotWriteFunc &amp;write_func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_to_png</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>83763b7906a666b095ce376271455457</anchor>
      <arglist>(cairo_write_func_t write_func, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>17d8f600aedba416bb640ac841494bde</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const cobject *</type>
      <name>cobj</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>f45e0ec675af4bb7259df99d202ac83c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Surface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>c471fbf586ba579565c6d876f9164717</anchor>
      <arglist>(const RefPtr&lt; Surface &gt; other, Content content, int width, int height)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>cobject *</type>
      <name>m_cobject</name>
      <anchorfile>classCairo_1_1Surface.html</anchorfile>
      <anchor>8c9aea28f0d1f6c2dcb507a2c7bb027c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::ImageSurface</name>
    <filename>classCairo_1_1ImageSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>ImageSurface</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>19a7d3c6f4320c4d812629b3c18925ac</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ImageSurface</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>489f33357db18c23bdf8ebd5d07d8264</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_width</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>f75b30cde988ad6959bb75862f5b6e2a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_height</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>a0e17bed71b125fd4725386ee1f14d07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned char *</type>
      <name>get_data</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>94ba52fe4a201579c8a5541717822bdb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const unsigned char *</type>
      <name>get_data</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>8858eb704ebe2118baf83f2a104b9140</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Format</type>
      <name>get_format</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>edccf9d08b3e5852c0bbb195cf1379a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_stride</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>4b33c7f1c03197eb66dac3e909c5a39a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>format_stride_for_width</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>c74f130a3bb36bd9fd70003cd8562ce5</anchor>
      <arglist>(Cairo::Format format, int width)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ImageSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>82887e1a0480ab16aa891e135f2b28d6</anchor>
      <arglist>(Format format, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ImageSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>feb1b8203f9fa23ff4bca7b70723f370</anchor>
      <arglist>(unsigned char *data, Format format, int width, int height, int stride)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ImageSurface &gt;</type>
      <name>create_from_png</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>ac35bcd255347574036746810f8a2978</anchor>
      <arglist>(std::string filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ImageSurface &gt;</type>
      <name>create_from_png_stream</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>7ac275170e7235457c9806aec7cf6f6a</anchor>
      <arglist>(const SlotReadFunc &amp;read_func)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; ImageSurface &gt;</type>
      <name>create_from_png</name>
      <anchorfile>classCairo_1_1ImageSurface.html</anchorfile>
      <anchor>43a9cf2aaaa8b2ef91da00bb244c7098</anchor>
      <arglist>(cairo_read_func_t read_func, void *closure)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::PdfSurface</name>
    <filename>classCairo_1_1PdfSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>PdfSurface</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>b2da398a2c5b4d0489964eff3adad638</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PdfSurface</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>e2a9198838ff56d5f46cd28becffdd48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>aae35e5e41a731d3f16f3b238b364bdc</anchor>
      <arglist>(double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PdfSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>92403fe5ad8ae6862e005c3d185e9123</anchor>
      <arglist>(std::string filename, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PdfSurface &gt;</type>
      <name>create_for_stream</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>a8537c400b7b212550dd4091099a8b2a</anchor>
      <arglist>(const SlotWriteFunc &amp;write_func, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PdfSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1PdfSurface.html</anchorfile>
      <anchor>a9fc3e58c824a3fe4428b556f6938382</anchor>
      <arglist>(cairo_write_func_t write_func, void *closure, double width_in_points, double height_in_points)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::PsSurface</name>
    <filename>classCairo_1_1PsSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>PsSurface</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>0b84b39dd7188da7e785ee8af85374f1</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PsSurface</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>118c07206670cc3535c739599d4d10d3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>9de17b1a3db7227a4f16fbf08a4cef2a</anchor>
      <arglist>(double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dsc_comment</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>9cd275173ea5dd88eeb485aab614cf92</anchor>
      <arglist>(std::string comment)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dsc_begin_setup</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>2c72ddaa92aaf109511586e445309131</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dsc_begin_page_setup</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>dcaaa1cf7f554e71f85039424726f6c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_eps</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>a2424e42623eb0c410573b465f7b0f00</anchor>
      <arglist>(bool eps)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_eps</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>f31ab624b15d1d8a36ee6e06e3980cc9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restrict_to_level</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>2db7043f9b80e2d2082a66ba419b5d46</anchor>
      <arglist>(PsLevel level)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PsSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>0d7a34b58211563e2b1f2f4f85818e90</anchor>
      <arglist>(std::string filename, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PsSurface &gt;</type>
      <name>create_for_stream</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>aa633e9ca0c424eae66d63826684f4d4</anchor>
      <arglist>(const SlotWriteFunc &amp;write_func, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; PsSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>108e885033a7a6c2697f7a94b40bb113</anchor>
      <arglist>(cairo_write_func_t write_func, void *closure, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const std::vector&lt; PsLevel &gt;</type>
      <name>get_levels</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>63de398067f3af5e6179e057063cc76d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>level_to_string</name>
      <anchorfile>classCairo_1_1PsSurface.html</anchorfile>
      <anchor>7afd98b03c189f1761cbe7e90db334dc</anchor>
      <arglist>(PsLevel level)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::SvgSurface</name>
    <filename>classCairo_1_1SvgSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>SvgSurface</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>67303207546ee57abfa62d4d0892575f</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SvgSurface</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>f782712407e736ea1d5c4e4c272ff7f1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restrict_to_version</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>4ac854641fe28b16c5e01582d91e22dc</anchor>
      <arglist>(SvgVersion version)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SvgSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>54d98ee27aa6274627335d8ccbd34a6e</anchor>
      <arglist>(std::string filename, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SvgSurface &gt;</type>
      <name>create_for_stream</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>3cc1ca3b8191ab2366b20fea664c2ce9</anchor>
      <arglist>(const SlotWriteFunc &amp;write_func, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; SvgSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>88fc030bd0b9ffa7f3455fcdf383ea16</anchor>
      <arglist>(cairo_write_func_t write_func, void *closure, double width_in_points, double height_in_points)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const std::vector&lt; SvgVersion &gt;</type>
      <name>get_versions</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>25403772072f28f7c40e6478332babaa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::string</type>
      <name>version_to_string</name>
      <anchorfile>classCairo_1_1SvgSurface.html</anchorfile>
      <anchor>3a15a5df131a8ef6cc8786342c7e6dfc</anchor>
      <arglist>(SvgVersion version)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::GlitzSurface</name>
    <filename>classCairo_1_1GlitzSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>GlitzSurface</name>
      <anchorfile>classCairo_1_1GlitzSurface.html</anchorfile>
      <anchor>5cac88d99e13f65090f25ed28983b8ad</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~GlitzSurface</name>
      <anchorfile>classCairo_1_1GlitzSurface.html</anchorfile>
      <anchor>b84419874031e8e7b465f185e317b9c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; GlitzSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1GlitzSurface.html</anchorfile>
      <anchor>4856fa658883d3a972dd54263f016a70</anchor>
      <arglist>(glitz_surface_t *surface)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Win32FontFace</name>
    <filename>classCairo_1_1Win32FontFace.html</filename>
    <base>Cairo::FontFace</base>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32FontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>f494a9cc048461b0dbd8e6789c20b9b4</anchor>
      <arglist>(LOGFONTW *logfont)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32FontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>9fe45f8a4ae6329e26d2472211c430a9</anchor>
      <arglist>(HFONT font)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32FontFace &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>69aef61b50a464318228bfb4a6a1de0c</anchor>
      <arglist>(LOGFONTW *logfont, HFONT font)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Win32FontFace</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>b1a4b0a5dd995ae84c35823b8fa801c3</anchor>
      <arglist>(LOGFONTW *logfont)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Win32FontFace</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>0ed6f8b28cd345795785436211a54673</anchor>
      <arglist>(HFONT font)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Win32FontFace</name>
      <anchorfile>classCairo_1_1Win32FontFace.html</anchorfile>
      <anchor>4a6934587e6ee36ec489299c40ac97d8</anchor>
      <arglist>(LOGFONTW *logfont, HFONT font)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Win32ScaledFont</name>
    <filename>classCairo_1_1Win32ScaledFont.html</filename>
    <base>Cairo::ScaledFont</base>
    <member kind="function">
      <type>void</type>
      <name>select_font</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>c6212da0cd1703a735c327480c4342cf</anchor>
      <arglist>(HDC hdc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>done_font</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>b06d5966b259ee21db5da72eb3726afd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_metrics_factor</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>fdb579126ac08de40624567c18088e40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_logical_to_device</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>d3c3ef003def222634fecee16e8e4139</anchor>
      <arglist>(Matrix &amp;logical_to_device) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_device_to_logical</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>1d559473b01a1446eca422bc77154e54</anchor>
      <arglist>(Matrix &amp;device_to_logical) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32ScaledFont &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>5571af577942771c07bf33e46ff4e715</anchor>
      <arglist>(const RefPtr&lt; Win32FontFace &gt; &amp;font_face, const Matrix &amp;font_matrix, const Matrix &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Win32ScaledFont</name>
      <anchorfile>classCairo_1_1Win32ScaledFont.html</anchorfile>
      <anchor>6257a1be5c290dedad297f34db488211</anchor>
      <arglist>(const RefPtr&lt; Win32FontFace &gt; &amp;font_face, const Matrix &amp;font_matrix, const Matrix &amp;ctm, const FontOptions &amp;options=FontOptions())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Win32Surface</name>
    <filename>classCairo_1_1Win32Surface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>Win32Surface</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>74e9cee0ea5f89bcc5dc7444217b1f1d</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Win32Surface</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>04fd3568ffc9a969d7f625f28ae1e584</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HDC</type>
      <name>get_dc</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>cdcc018282d8cfed8bc992233a378aa4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; ImageSurface &gt;</type>
      <name>get_image</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>e34550ff9da8de1739327291c73a9f73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32Surface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>6e5658b32a2d2083d0fddf81428ca1fb</anchor>
      <arglist>(HDC hdc)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32Surface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>bd2b5f85390a34531a0c40e6e6c692d8</anchor>
      <arglist>(Format format, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32Surface &gt;</type>
      <name>create_with_dib</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>78cfec22533db4a28356dedf7a82163e</anchor>
      <arglist>(Format format, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32Surface &gt;</type>
      <name>create_with_ddb</name>
      <anchorfile>classCairo_1_1Win32Surface.html</anchorfile>
      <anchor>8797038d60b767e538f7302e46471817</anchor>
      <arglist>(HDC hdc, Format format, int width, int height)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::Win32PrintingSurface</name>
    <filename>classCairo_1_1Win32PrintingSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>Win32PrintingSurface</name>
      <anchorfile>classCairo_1_1Win32PrintingSurface.html</anchorfile>
      <anchor>c487a4537e12408e1420051976477032</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Win32PrintingSurface</name>
      <anchorfile>classCairo_1_1Win32PrintingSurface.html</anchorfile>
      <anchor>bacc406740bec0fe5d1b4a9f50642af1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; Win32PrintingSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1Win32PrintingSurface.html</anchorfile>
      <anchor>433dfdbac69b4ca3428f9b7d1066a317</anchor>
      <arglist>(HDC hdc)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Cairo::XlibSurface</name>
    <filename>classCairo_1_1XlibSurface.html</filename>
    <base>Cairo::Surface</base>
    <member kind="function">
      <type></type>
      <name>XlibSurface</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>fe45b69c03a79879b0e1b1cabb13a6da</anchor>
      <arglist>(cairo_surface_t *cobject, bool has_reference=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~XlibSurface</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>362141c504db6742c4e09af52945709f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>69b6337fa91dd53a054427e9a8235f16</anchor>
      <arglist>(int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_drawable</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>92f59aab3ce0a113df0f6de18f306816</anchor>
      <arglist>(Drawable drawable, int width, int height)</arglist>
    </member>
    <member kind="function">
      <type>Drawable</type>
      <name>get_drawable</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>e72506a16c6865a5709d38e2e33b1771</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Display *</type>
      <name>get_display</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>d073af9affb7338e9b78589e7565a320</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Display *</type>
      <name>get_display</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>fe98ccb169fe84f05ff7f2c1fb413a5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Screen *</type>
      <name>get_screen</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>95da96899c1098dae4dc34d0b489d4b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Screen *</type>
      <name>get_screen</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>e0a1ccd477c2e5691b5a748c71191338</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Visual *</type>
      <name>get_visual</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>da56c72e6f48420340a0bc4ae0ae22b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Visual *</type>
      <name>get_visual</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>2e1b0cc64bd149a141a08112236726a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_depth</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>476e5ddd3deee79c8f47be01e1e0f7e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_height</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>5ebd424f0c526c82141051a9824f3c69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_width</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>8cce1064a3f867657eb31e83d1dd464d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>XRenderPictFormat *</type>
      <name>get_xrender_format</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>285b8e6394c22f395cca79c92dc17429</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; XlibSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>e4c1ee03939f091bc5f1bc75e8b35dcb</anchor>
      <arglist>(Display *dpy, Drawable drawable, Visual *visual, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RefPtr&lt; XlibSurface &gt;</type>
      <name>create</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>8ece252d2269f2f73c9f436dbc6c8a30</anchor>
      <arglist>(Display *dpy, Pixmap bitmap, Screen *screen, int width, int height)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Cairo::RefPtr&lt; Cairo::XlibSurface &gt;</type>
      <name>create_with_xrender_format</name>
      <anchorfile>classCairo_1_1XlibSurface.html</anchorfile>
      <anchor>88149191bb6cef8fbe5dded45be35355</anchor>
      <arglist>(Display *dpy, Drawable drawable, Screen *screen, XRenderPictFormat *format, int width, int height)</arglist>
    </member>
  </compound>
</tagfile>
