#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2008-2009, Darko Miletic <darko.miletic at gmail.com>'
'''
juventudrebelde.cu
'''

from calibre import strftime
from calibre.web.feeds.news import BasicNewsRecipe

class Juventudrebelde(BasicNewsRecipe):
    title                 = 'Juventud Rebelde'
    __author__            = 'Darko Miletic'
    description           = 'Diario de la Juventud Cubana'
    publisher             = 'Juventud rebelde'
    category              = 'news, politics, Cuba'
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = False
    encoding              = 'cp1252'
    language = 'es'

    cover_url             = strftime('http://www.juventudrebelde.cu/UserFiles/File/impreso/iportada-%Y-%m-%d.jpg')
    remove_javascript     = True

    html2lrf_options = [
                          '--comment'  , description
                        , '--category' , category
                        , '--publisher', publisher
                        , '--ignore-tables'
                        ]

    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"\nlinearize_tables=True'

    keep_only_tags = [dict(name='div', attrs={'id':'noticia'})]

    feeds = [
               (u'Generales', u'http://www.juventudrebelde.cu/rss/generales.php' )
              ,(u'Cuba', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=cuba' )
              ,(u'Internacionales', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=internacionales' )
              ,(u'Opinion', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=opinion' )
              ,(u'Cultura', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=cultura' )
              ,(u'Deportes', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=deportes' )
              ,(u'Lectura', u'http://www.juventudrebelde.cu/rss/generales.php?seccion=lectura' )
            ]

    def preprocess_html(self, soup):
        mtag = '<meta http-equiv="Content-Language" content="es-CU"/>'
        soup.head.insert(0,mtag)
        for item in soup.findAll(style=True):
            del item['style']
        return soup

