#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from terra.core.manager import Manager
import datetime

mger = Manager()
AudioPlayerController = mger.get_class("Controller/Media/Audio")
IRadioStationModel = mger.get_class("Model/Media/Audio/IRadio/Station")


class IRadioBasePlayerController(AudioPlayerController):
    def __init__(self, model, canvas, parent):
        AudioPlayerController.__init__(self, model, canvas, parent)

    def options_model_get(self):
        return None

    # Dummy implementations for repeat and shuffle. Both are
    # always false and setting them never affects the prefs, so
    # this won't harm the normal Audio Player.

    def __get_repeat(self):
        return False

    def __set_repeat(self, value):
        pass

    repeat = property(__get_repeat, __set_repeat)

    def __get_shuffle(self):
        return False

    def __set_shuffle(self, value):
        pass

    shuffle = property(__get_shuffle, __set_shuffle)

    # Reimplement get_duration and get_position as they don't exist
    # for streams and thus atabake stalls when calling the functions
    # Get position now returns the current time, which makes more sense.

    def get_duration(self):
        self.duration = None
        return self.duration

    def get_position(self):
        t = datetime.datetime.now()
        self.position = t.second + 60 * t.minute + 3600 * t.hour
        return self.position

    def update_trackbar(self):
        pos = self.disable_trackbar()


class IRadioStationPlayerController(IRadioBasePlayerController):
    terra_type = "Controller/Media/Audio/IRadio/Station"


class IRadioFeedPlayerController(IRadioBasePlayerController):
    terra_type = "Controller/Folder/Media/Audio/IRadio/Feed/DirectPlay"

    def __init__(self, model, canvas, parent):
        model.load()
        station = model.children[0]
        self.parent_model = model
        IRadioBasePlayerController.__init__(self, station, canvas, parent)

    def delete(self):
        self.parent_model.unload()
        del self.parent_model
        IRadioBasePlayerController.delete(self)
