#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from terra.ui.grid import KineticGrid
from terra.ui.vgrid import KineticVerticalGrid
from terra.ui.base import Widget
from terra.core.plugin_prefs import PluginPrefs
from terra.core.terra_object import TerraObject


class KineticGridWidget(KineticGrid, Widget, TerraObject):
    terra_type = "Widget/KineticGrid"

    def __init__(self, parent, renderer_new, elements, theme=None, v_align=0.5):
        Widget.__init__(self, parent, theme)
        cell_renderer = renderer_new(parent.evas)
        size = cell_renderer.size_min
        cell_renderer.delete()
        KineticGrid.__init__(self, parent.evas, renderer_new, elements, size,
                             v_align)

        prefs = PluginPrefs("settings")
        self.click_constant = int(prefs.get("grid_click_constant", 25))
        self.move_constant = int(prefs.get("grid_move_constant", 20))
        self.click_block_time = float(prefs.get("grid_click_block_time", 0.30))

    def theme_changed(self):
        for row in self.renderers:
            for c in row:
                c.theme_changed()
        self._refill_renderers()

    def force_redraw(self):
        for row in self.renderers:
            for c in row:
                c.force_redraw()


class KineticVGridWidget(KineticVerticalGrid, Widget, TerraObject):
    terra_type = "Widget/KineticVGrid"

    def __init__(self, parent, renderer_new, elements, theme=None):
        Widget.__init__(self, parent, theme)
        cell_renderer = renderer_new(parent.evas)
        size = cell_renderer.size_min
        cell_renderer.delete()
        KineticVerticalGrid.__init__(self, parent.evas, renderer_new, elements, size)

    def theme_changed(self):
        for row in self.renderers:
            for c in row:
                c.theme_changed()
        self._refill_renderers()

    def force_redraw(self):
        for row in self.renderers:
            for c in row:
                c.force_redraw()
