#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from logging import getLogger

from terra.core.manager import Manager


mger = Manager()
db = mger.canola_db
ScrollableTextBlock = mger.get_class("Widget/ScrollableTextBlock")
BasicPanelController = mger.get_class("Controller/BasicPanel")
VideoPlayerController = mger.get_class("Controller/Media/Video")
OnDemandPlayerOptionsModel = \
mger.get_class("Model/Options/Folder/Player/OnDemand")

log = getLogger("plugins.canola-core.ondemand.video.ui")

class OnDemandVideoPlayerController(VideoPlayerController):
    terra_type = "Controller/Media/Video/OnDemand"
    name = "podcast"

    def _commit_pos(self, pos):
        try:
            db.execute("UPDATE videocast_episodes SET pos = ?"
                       "WHERE id = ?", (pos, self.model.id))
        except Exception, e:
            self.log.error("Error commiting position: %s", e)
        mger.canola_db.commit()

    def _get_pos(self):
        pos = 0
        try:
            rows = db.execute("SELECT pos FROM videocast_episodes WHERE "
                              "id == ?", (self.model.id,))
            pos = rows[0][0]
        except Exception, e:
            self.log.error("Error getting initial position: %s", e)
        self.log.info("Returning pos for videocast id (%s): %s",
                      self.model.id, pos)
        return pos

    saved_pos = property(_get_pos, _commit_pos)

    def play(self):
        # On demand audio playback always go to the last position if one exists
        self.pos = self.saved_pos
        self.model.unheard = False
        VideoPlayerController.play(self)

    def prev(self):
        self.saved_pos = self.pos
        VideoPlayerController.prev(self)

    def next(self):
        self.saved_pos = self.pos
        VideoPlayerController.next(self)

    def delete(self):
        self.saved_pos = self.pos
        VideoPlayerController.delete(self)

    def options_model_get(self):
        return OnDemandPlayerOptionsModel(None, self)
