/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */
/** 
 * SECTION:ctk-utils
 * @short_description: Utility functions
 *
 * Utility functions
 */


#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>

#include <GL/glew.h>
#include <GL/glxew.h>

#include <clutter/clutter.h>
#include "ctk-utils.h"
#include <gio/gio.h>

gint
CheckGLError (const gchar *glCall, const gchar *file, gint line)
{
  GLenum glErr;
  gint   ret_code = 0;

  while ((glErr=glGetError()) != GL_NO_ERROR)
    {
      switch(glErr)
        {
        case GL_INVALID_ENUM:
          g_warning ("[CheckGLError] "
                    "GL_INVALID_ENUM error in File %s at line: %d",
                    file,
                    line);
          break;

        case GL_INVALID_VALUE:
          g_warning ("[CheckGLError] "
                     "GL_INVALID_VALUE error in File %s at line: %d",
                     file,
                     line);
          break;

        case GL_INVALID_OPERATION:
          g_warning ("[CheckGLError] "
                     "GL_INVALID_OPERATION error in File %s at line: %d", 
                     file,
                     line);
          break;
        
        case GL_STACK_OVERFLOW:
          g_warning ("[CheckGLError] "
                     "GL_STACK_OVERFLOW error in File %s at line: %d",
                     file,
                     line);
          break;
        
        case GL_STACK_UNDERFLOW:
          g_warning ("[CheckGLError] "
                     "GL_STACK_UNDERFLOW error in File %s at line: %d",
                     file,
                     line);
          break;
        
        case GL_OUT_OF_MEMORY:
          g_warning ("[CheckGLError] "
                     "GL_OUT_OF_MEMORY error in File %s at line: %d",
                     file,
                     line);
          break;
        
        default:
          g_warning ("[CheckGLError] "
                     "UNKNOWN ERROR in File %s at line: %d",
                     file,
                     line);
        }

      g_warning ("[CheckGLError] OpenGL Error %d in File %s at line: %d \n",
                 glErr,
                 file,
                 line);
      ret_code = 1;
      exit (-1);
    }
  
  return ret_code;
}


