/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <stdlib.h>
#include <unistd.h>
#include <clutk/clutk.h>

static void test_icon_view (void);

void
test_icon_view_create_suite (void)
{
#define DOMAIN "/IconView"

  g_test_add_func (DOMAIN"/AutoFadeChildren", test_icon_view);
}

static void
test_icon_view (void)
{
  ClutterActor *stage;
  ClutterActor *icon_view;
  gint          i;

  stage = clutter_stage_get_default ();

  icon_view = ctk_icon_view_new ();
  g_object_set (icon_view, "auto-fade-children", TRUE, NULL);
  clutter_container_add_actor (CLUTTER_CONTAINER (stage), icon_view);
  clutter_actor_set_size (icon_view, 400, 400);
  clutter_actor_set_position (icon_view, 0, 0);

  for (i = 0; i < 4; i ++)
    {
      ClutterActor *icon = ctk_image_new_from_stock (48, "gtk-apply");
      clutter_actor_set_size (icon, 48, 48);
      clutter_container_add_actor (CLUTTER_CONTAINER (icon_view), icon);
    }

  clutter_actor_show_all (stage);

  while (gtk_events_pending ())
    gtk_main_iteration ();

  GList *children = clutter_container_get_children (CLUTTER_CONTAINER (icon_view));
  GList *c;
  for (c = children; c; c = c->next)
    {
      guint opacity = clutter_actor_get_opacity (c->data);
      g_assert (opacity == 255);
    }

  clutter_actor_set_size (icon_view, 50, 50);

  while (gtk_events_pending ())
    gtk_main_iteration ();

  i = 0;
  for (c = children; c; c = c->next)
    {
      guint opacity = clutter_actor_get_opacity (c->data);
      if (i < 1)
        g_assert (opacity == 255);
      else
        g_assert (opacity == 0);

      i++;
    }

  clutter_actor_hide (stage);
}

