/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_HBOX_H_
#define _CTK_HBOX_H_

#include <glib.h>
#include <clutter/clutter.h>

#include <ctk/ctk-box.h>

#define CTK_TYPE_HBOX (ctk_hbox_get_type ())

#define CTK_HBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_HBOX, CtkHBox))

#define CTK_HBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_HBOX, CtkHBoxClass))

#define CTK_IS_HBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_HBOX))

#define CTK_IS_HBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_HBOX))

#define CTK_HBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_HBOX, CtkHBoxClass))

typedef struct _CtkHBox        CtkHBox;
typedef struct _CtkHBoxClass   CtkHBoxClass;
 
struct _CtkHBox
{
  CtkBox        parent;	
};

struct _CtkHBoxClass
{
  CtkBoxClass   parent_class;
};

GType          ctk_hbox_get_type  (void) G_GNUC_CONST;

ClutterActor * ctk_hbox_new       (guint spacing);

#endif /* _CTK_HBOX_H_ */

