/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_SCROLL_VIEW_H_
#define _CTK_SCROLL_VIEW_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <ctk/ctk-bin.h>

G_BEGIN_DECLS

#define CTK_TYPE_SCROLL_VIEW (ctk_scroll_view_get_type ())

#define CTK_SCROLL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_SCROLL_VIEW, CtkScrollView))

#define CTK_SCROLL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_SCROLL_VIEW, CtkScrollViewClass))

#define CTK_IS_SCROLL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_SCROLL_VIEW))

#define CTK_IS_SCROLL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_SCROLL_VIEW))

#define CTK_SCROLL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_SCROLL_VIEW, CtkScrollViewClass))

typedef struct _CtkScrollView        CtkScrollView;
typedef struct _CtkScrollViewClass   CtkScrollViewClass;
typedef struct _CtkScrollViewPrivate CtkScrollViewPrivate;
 
struct _CtkScrollView
{
  CtkBin parent;	

  CtkScrollViewPrivate *priv;
};

struct _CtkScrollViewClass
{
  /*< private >*/
  CtkBinClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

typedef enum
{
  CTK_SCROLLBAR_INSET,
  CTK_SCROLLBAR_OVERLAY,
  CTK_SCROLLBAR_HIDDEN

} CtkScrollbarType;

GType             ctk_scroll_view_get_type      (void) G_GNUC_CONST;

ClutterActor *    ctk_scroll_view_new           (void);

CtkScrollbarType ctk_scroll_view_get_bar_type   (CtkScrollView      *view);

void             ctk_scroll_view_set_bar_type   (CtkScrollView      *view,
                                                 CtkScrollbarType    type);

gboolean         ctk_scroll_view_scroll         (CtkScrollView      *view,
                                                 ClutterScrollEvent *event);

void             ctk_scroll_view_set_value      (CtkScrollView      *view,
                                                 gfloat              value);

gfloat           ctk_scroll_view_get_value      (CtkScrollView      *view);

void             ctk_scroll_view_set_scroll_bar (CtkScrollView      *view,
                                                 ClutterActor       *trough,
                                                 ClutterActor       *slider);

void             ctk_scroll_view_get_scroll_bar (CtkScrollView      *view,
                                                 ClutterActor      **trough,
                                                 ClutterActor      **slider);

gboolean         ctk_scroll_view_can_scroll     (CtkScrollView      *view);

G_END_DECLS

#endif /* _CTK_SCROLL_VIEW_H_ */

