/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#include <cstdio>
#include <cassert>
#include <DcsPlugin.h>
#include <ENMPlugin.h>
#include <ENMApi.h>
#include "ENMUtil.h"
#include "ENMDataManager.h"
#include <string>
using namespace std;

FILE* enm_log = NULL;
/**
 * Gets the module ID.
 */
DCSAPI int DP_GetModuleID()
{
    return DCS_EASY_NETWORK_MANAGER;
}

/**
 * Gets the description of the module.
 */
DCSAPI const char *DP_GetDescription()
{
    return "ENM plug in";
}

/**
 * Initializes the module and passes the host function pointers.
 *
 * @param pFuncs	pointer to the DCS function interface
 */
DCSAPI int DP_Initialize(DCS_Funcs *pFuncs)
{
    ENMDataManager* pDataManager = ENMDataManager::GetInstance();

	if(!enm_log)
	{

		enm_log=fopen("/tmp/EnmPlugin.txt", "w");

	}

	fprintf(enm_log, "DP_Initialize \n");
    fflush(enm_log);

    pDataManager->InitializeDCS_Funcs(pFuncs);

    if ((DCS_VERSION != (pFuncs->version)) || (NULL == pFuncs))
    {
        return 0;
    }

    return 0;
}

/**
 * Uninitializes the module and cleans up.
 */
DCSAPI int DP_Uninitialize()
{
    fprintf(enm_log, "ENM DP_Uninitialize \n");
    fflush(enm_log);

    return 0;
}

/**
 * Handles the function request.
 *
 * @param pRequest	pointer to request data
 */
DCSAPI DCS_Return_Code DP_HandleRequest(DCS_RequestData *pRequest)
{
    fprintf(enm_log, "enm_Plugin ..... Begin DP_HandleRequest \n");
    fflush(enm_log);

    if ( NULL == pRequest )
    {
        return DCS_FUNC_NOTEXIST;
    }

    fprintf(enm_log, "DP_HandleRequest %d \n", pRequest->funcId);
    fflush(enm_log);


    ENMDataManager* pDataManager = ENMDataManager::GetInstance();

    DCS_Return_Code ret = DCS_SUCCESS;

    switch (pRequest->funcId)
    {
    case ENM_INIT_USER_INFO:
    {

        ENM_InitUserInfo* pInitUserInfo = (ENM_InitUserInfo *)(pRequest->pParams);
        ret = pDataManager->InitUserInfo(*pInitUserInfo); //1

        fprintf(enm_log, "ENM ENM_INIT_USER_INFO %s\n",pInitUserInfo->userPath.dcsString);
        fflush(enm_log);

    }
    break;
	case ENM_ALLOCATE_DH_IP:
	{
	    fprintf(enm_log, "ENM ENM_ALLOCATE_DH_IP \n");
        fflush(enm_log);

        ret = pDataManager->AllocateDhIP();
	}
	break;
    case ENM_CLOSE_WLAN_CONNECTION:
    {
        fprintf(enm_log, "ENM ENM_CLOSE_WLAN_CONNECTION \n");
        fflush(enm_log);


        ret = pDataManager->CloseWlanConnection();
    }
    break;
    case ENM_SEARCH_ADAPTER:
    {
         fprintf(enm_log, "ENM ENM_SEARCH_ADAPTER \n");
         fflush(enm_log);


         ret = ENMDataManager::GetInstance()->SearchAdapter();//2
    }
    break;
    case ENM_UP_ADAPTER:
    {

        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        fprintf(enm_log, "ENM ENM_UP_ADAPTER %d\n" , (int)*pAdapterType);
        fflush(enm_log);
        ret = pDataManager->UpAdapter(*pAdapterType);
    }
    break;
    case ENM_DOWN_ADAPTER:
    {
        fprintf(enm_log, "ENM ENM_DOWN_ADAPTER \n");
        fflush(enm_log);

        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        ret = pDataManager->DownAdapter(*pAdapterType);

    }
    break;
    case ENM_IS_EXIST_UP_ADAPTER:
    {
        fprintf(enm_log, "ENM ENM_IS_EXIST_UP_ADAPTER \n");
        fflush(enm_log);


        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        ret = pDataManager->IsExistUpAdapter(*pAdapterType,(BOOL *)(pRequest->pReturnData));//3
        pRequest->pReturnDataLen = sizeof(BOOL);
    }
    break;
    case ENM_IS_EXIST_CONNECT_ADAPTER:
    {
        fprintf(enm_log, "ENM ENM_IS_EXIST_CONNECT_ADAPTER \n");
        fflush(enm_log);


        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        ret  = pDataManager->IsExistConnectAdapter(*pAdapterType,(BOOL *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(BOOL);
    }
    break;
    case ENM_CONNECT_AP:
    {
        fprintf(enm_log, "ENM ENM_CONNECT_AP \n");
        fflush(enm_log);


        ENM_ConnectAP* pConnectAP = (ENM_ConnectAP*)(pRequest->pParams);

        pDataManager->ConnectAP(*pConnectAP);
    }
    break;
    case ENM_GET_AP_LIST:
    {
        fprintf(enm_log, "ENM ENM_GET_AP_LIST \n");
        fflush(enm_log);


        ret = pDataManager->GetAPList((AccessPointList *)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(AccessPointList);

    }
    break;
    case ENM_GET_CURRENT_AP:
    {
        fprintf(enm_log, "ENM ENM_GET_CURRENT_AP \n");
        fflush(enm_log);


        ret = pDataManager->GetCurrentAP((APStatus*)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(APStatus);

    }
    break;
    case ENM_GET_IP_ADDRESS_HLAN:
    {
        fprintf(enm_log, "ENM ENM_GET_IP_ADDRESS_HLAN \n");
        fflush(enm_log);

        ret = pDataManager->GetIPAddressHLAN((ENM_String*)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(ENM_String);
    }
    break;
    case ENM_GET_IP_ADDRESS_LAN:
    {
        fprintf(enm_log, "ENM ENM_GET_IP_ADDRESS_LAN \n");
        fflush(enm_log);

        ret = pDataManager->GetIPAddressHLAN((ENM_String*)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(ENM_String);
    }
    break;
    case ENM_GET_CONNECT_TYPE_HLAN:
    {
        ret = pDataManager->GetConnectTypeHLAN((ENM_String*)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(ENM_String);
        fprintf(enm_log, "ENM ENM_GET_CONNECT_TYPE_HLAN \n");
        fflush(enm_log);
    }
    break;
    case ENM_GET_CONNECT_TYPE_LAN:
    {
        ret = pDataManager->GetConnectTypeHLAN((ENM_String*)(pRequest->pReturnData));
        pRequest->pReturnDataLen = sizeof(ENM_String);
        fprintf(enm_log, "ENM ENM_GET_CONNECT_TYPE_LAN \n");
        fflush(enm_log);
    }
    break;
    case ENM_ENABLE_8021X_AUTHENTICATION:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_ENABLE_8021X_AUTHENTICATION\n");
        fflush(enm_log);
        bool* bIsEnable = (bool*)pRequest->pParams;
        ret = pDataManager->Enable8021xAuthentication(bIsEnable);
    }
        break;

    case ENM_ENABLE_INTERNET_SHARING:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_ENABLE_INTERNET_SHARING\n");
        fflush(enm_log);
        bool* bIsEnable = (bool*)pRequest->pParams;
        ret = pDataManager->EnableInternetSharing(bIsEnable);
    }
        break;

    case ENM_OVERWRITE_HOMEPAGE:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_OVERWRITE_HOMEPAGE\n");
        fprintf(enm_log, "ENM_Plugin Enter ENM_OVERWRITE_PROXY %s\n", ((ENM_String*)pRequest->pParams)->dcsString);
        fflush(enm_log);
        ENM_String* strHomePage = (ENM_String*)pRequest->pParams;
        ret = pDataManager->OverwriteHomePage(strHomePage);
    }
        break;

    case ENM_OVERWRITE_PROXY:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_OVERWRITE_PROXY\n");
        fprintf(enm_log, "ENM_Plugin Enter ENM_OVERWRITE_PROXY %s\n", ((ENM_ProxyInfo*)pRequest->pParams)->host.dcsString);
        fprintf(enm_log, "ENM_Plugin Enter ENM_OVERWRITE_PROXY %s\n", ((ENM_ProxyInfo*)pRequest->pParams)->port.dcsString);

        fflush(enm_log);
        ret = pDataManager->OverwriteProxy((ENM_ProxyInfo*)pRequest->pParams);
        pRequest->pReturnDataLen = sizeof(ENM_ProxyInfo);
    }
        break;

    case ENM_CHANGE_ADDRESS:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_CHANGE_ADDRESS\n");
        fflush(enm_log);
        ENM_AddressInfo* enmAddressInfo = (ENM_AddressInfo*)pRequest->pParams;
        ret = pDataManager->ChangeAddress(enmAddressInfo);
    }
        break;

    case ENM_IS_EXIST_ADAPTER:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_IS_EXIST_ADAPTER\n");
        fflush(enm_log);
        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        ret = pDataManager->IsExistAdapter(*pAdapterType,(BOOL *)(pRequest->pReturnData));//3
        pRequest->pReturnDataLen = sizeof(BOOL);
    }
        break;

    case ENM_GET_NEIGHBORS_INFO:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_GET_NEIGHBORS_INFO\n");
        fflush(enm_log);
        ret = pDataManager->ExecSmbtree();
    }
        break;

    case ENM_GET_NEIGHBOR_INFO:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_GET_NEIGHBOR_INFO\n");
        fflush(enm_log);
        ret = pDataManager->ExecSmbtree();
    }
        break;

    case ENM_WRITE_FILE:
    {
        fprintf(enm_log, "ENM_Plugin Enter ENM_WRITE_FILE\n");
        fflush(enm_log);
        ENM_String* strHostName = (ENM_String*)pRequest->pParams;
        ret = pDataManager->ExecNmblookup(strHostName);
    }
        break;

    case ENM_DISPATCH_DISABLE_EVENT:
    {
        fprintf(enm_log, "ENM ENM_DISPATCH_DISABLE_EVENT \n");
        fflush(enm_log);

        ENM_ADAPTER_TYPE* pAdapterType = (ENM_ADAPTER_TYPE*)(pRequest->pParams);
        ret = pDataManager->DispatchDisableEvent(*pAdapterType);
    }
    break;

	default:
	   break;
    }

    fprintf(enm_log, "enm_Plugin ..... End DP_HandleRequest \n \n");
    fflush(enm_log);

    return ret;
}
/**
 * Destroys data related to a client.
 * DCS will call this function when DCS detects that a client exits.
 *
 * @param cliId	the client process ID
 */
DCSAPI int DP_DestroyClient(int cliId)
{
    return 0;
}

