/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_POWERMANAGEMENT_DEF_H
#define DCS_POWERMANAGEMENT_DEF_H

/** Definition of CPU speeds. */
typedef enum DCS_CPUSpeed_E {
	DCS_CPUSPEED_LOWEST,
	DCS_CPUSPEED_LOW,
	DCS_CPUSPEED_ADAPTIVE,
	DCS_CPUSPEED_HIGHEST
} DCS_CPUSpeed;

/** Definition of LAN speeds. */
typedef enum DCS_Lan_Speed_E {
	DCS_LAN_SPEED_10M_HALF_DUPLEX,
	DCS_LAN_SPEED_10M_FULL_DUPLEX,
	DCS_LAN_SPEED_100M_HALF_DUPLEX,
	DCS_LAN_SPEED_100M_FULL_DUPLEX,
	DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE
} DCS_Lan_Speed;

/** Definition of DPST levels. */
typedef enum DCS_DPST_E {
	HIGHEST_POWER_SAVING,
	MEDIUM_POWER_SAVING,
	LOWER_POWER_SAVING,
	DISABLED_POWER_SAVING
} DCS_DPST;

/** Definition of battery information. */
typedef struct DCS_BATTERY_INFO_S {
/* The battery status includes: */
#define BATTERY_POWER_ON_LINE   0x00000001
#define BATTERY_DISCHARGING     0x00000002
#define BATTERY_CHARGING        0x00000004
#define BATTERY_CRITICAL        0x00000008
	UINT BatteryStatus;			/**< The battery status */
    UINT RemainPercent;		/**< The approximate percentage of full battery time remaining */
	UINT RemainTime;		/**< The approximate number of seconds of battery time remaining */
//	UINT Capabilities;		/**< The capacity of the given battery*/
	UINT DesignedCapacity;	/**< The theoretical capacity of the battery when new, in milliwatt-hours.*/
	UINT FullChargedCapacity;/**< The battery's current fully charged capacity, in milliwatt-hours.*/
//	UCHAR Technology;		/**< \c 0 for a primary, nonrechargeable battery; \c 1 for a secondary, rechargeable battery */
	UCHAR Reserved[3];
	UCHAR Chemistry[4];		/**< A four-character string indicating the type of chemistry used in the battery. Possible values include PbAc (Lead Acid), LION (Lithium Ion), NiCd (Nickel Cadmium), NiMH (Nickel Metal Hydride), NiZn (Nickel Zinc), and RAM (Rechargeable Alkaline-Manganese). */
//	UINT DefaultAlert1;		/**< The capacity (in milliwatt-hours) at which a low battery alert should occur */
//	UINT DefaultAlert2;		/**< The capacity (in milliwatt-hours) at which a warning battery alert should occur */
//	UINT CriticalBias;		/**< The amount (in milliwatt-hours) of any small reserved charge that remains when the critical battery level shows zero */
//	UINT CycleCount;		/**< The number of charge/discharge cycles the battery has experienced, or zero if the battery does not support a cycle counter */
	UINT Current;			/**< The current of battery */
	UINT Voltage;			/**< The voltage of battery */
	UINT Temperature;		/**< The temperature of battery */
} DCS_Battery_Info, *PDCS_Battery_Info;



/** Definition of power scheme data infomation. */
typedef struct PM_Power_Scheme_Data_S{
	char pName[256];
	char pDesc[256];
	int copyFrom;
	int schemeId;
}PM_Power_Scheme_Data;

/** Definition of power manager variable data infomation. */
typedef struct PM_Variable_Data_S{
	int schemeId;
	BOOL isAC;
	char pVarName[256];
	int value;
}PM_Variable_Data;

/** Definition of battery realtime status. */
typedef struct DCS_POWER_STATUS_S {
/* The battery status includes: */
#define POWER_AC_ONLINE			0x00000001
#define POWER_DC_DISCHARGING	0x00000002
#define POWER_DC_CHARGING		0x00000004	
#define POWER_DC_CRITICAL		0x00000008	
	UINT BatteryStatus;		/**< The battery status */
    UINT RemainPercent;		/**< The approximate percentage of full battery time remaining */
	UINT RemainTime;		/**< The approximate number of seconds of battery time remaining */
} DCS_Power_Status, *PDCS_Power_Status;

/** Definition of enum power scheme structure. */
typedef struct Enum_Scheme_Proc_Param_S{
	void * lpfnPwrSchemesEnumProc;	/**< The callback function used to enum power scheme.*/
	void * lParam;					/**< A user-defined value to be passed to the callback function.*/
}Enum_Scheme_Proc_Param;

/** Definition of PM configuration structure. */
typedef struct PM_Configure_Data_S{
	int nFlag;				/**< The flag to indicate whether it is private or public configuration */
	char pFile[256];		/**< The configuration file name */
	char pSec[256];			/**< The section name */
	char pItem[256];		/**< The item name */
	char pValue[256];		/**< The string value */
	int defValue;			/**< The default value returned if get from configruation file failed */
	int value;				/**< The int value.*/
}PM_Configure_Data;
 
#endif /* DCS_POWERMANAGEMENT_DEF_H */
