/****************************************************************************
Copyright (c) 2008 Intel Corporation.  All rights reserved. 

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS. 
****************************************************************************/
/**
 * This is the header file of Virtual Keyboard driver IOCTL definition.
 * @file virkbdio.h
 */

#ifndef VIRKBDIO_H
#define VIRKBDIO_H

#include <windows.h>
#include <winioctl.h>

#define IOCTL_VKBD_EVENT \
    CTL_CODE(FILE_DEVICE_ACPI, 0x901, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VKBD_START \
    CTL_CODE(FILE_DEVICE_ACPI, 0x902, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VKBD_STOP \
    CTL_CODE(FILE_DEVICE_ACPI, 0x903, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_VKBD_GET_KEY \
    CTL_CODE(FILE_DEVICE_ACPI, 0x904, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define VKBD_KEY_FNF1_PRESS			0x81
#define VKBD_KEY_FNF8_PRESS			0x82
#define VKBD_KEY_FNF10_PRESS		0x83
#define VKBD_KEY_FNF11_PRESS		0x84
#define VKBD_KEY_BEZEL_PRESS		0x85
#define VKBD_KEY_FNF1_RELEASE		0x91
#define VKBD_KEY_FNF8_RELEASE		0x92
#define VKBD_KEY_FNF10_RELEASE		0x93
#define VKBD_KEY_FNF11_RELEASE		0x94
#define VKBD_KEY_BEZEL_RELEASE		0x95

#endif // VIRKBDIO_H
