/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.Serializable;

public class QName
implements Serializable {
    private final String namespaceURI;
    private final String localPart;
    private final String prefix;

    public QName(String pNamespaceURI, String pLocalPart) {
        if (pLocalPart == null) {
            throw new IllegalArgumentException("The local part must not be null");
        }
        this.namespaceURI = pNamespaceURI == null ? "" : pNamespaceURI;
        this.localPart = pLocalPart;
        this.prefix = "";
    }

    public QName(String pNamespaceURI, String pLocalPart, String pPrefix) {
        if (pLocalPart == null) {
            throw new IllegalArgumentException("The local part must not be null");
        }
        if (pPrefix == null) {
            throw new IllegalArgumentException("The prefix must not be null");
        }
        this.namespaceURI = pNamespaceURI == null ? "" : pNamespaceURI;
        this.localPart = pLocalPart;
        this.prefix = pPrefix;
    }

    public QName(String pLocalPart) {
        if (pLocalPart == null) {
            throw new IllegalArgumentException("The local part must not be null");
        }
        this.namespaceURI = "";
        this.localPart = pLocalPart;
        this.prefix = "";
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object pOther) {
        if (!(pOther instanceof QName)) {
            return false;
        }
        QName other = (QName)pOther;
        return this.namespaceURI.equals(other.namespaceURI) && this.localPart.equals(other.localPart);
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() + this.localPart.hashCode();
    }

    public String toString() {
        return this.namespaceURI.length() == 0 ? this.localPart : "{" + this.namespaceURI + "}" + this.localPart;
    }

    public static QName valueOf(String pQName) {
        if (pQName == null) {
            throw new IllegalArgumentException("The string representation of a QName must not be null.");
        }
        if (pQName.charAt(0) == '{') {
            int end = pQName.indexOf(125, 1);
            if (end == -1) {
                throw new IllegalArgumentException("Expected a terminator ('}') of the namespace URI.");
            }
            return new QName(pQName.substring(1, end), pQName.substring(end + 1));
        }
        return new QName(pQName);
    }
}

