/*
 * vim:ts=8:sw=3:sts=8:noexpandtab:cino=>5n-3f0^-2{2
 */
#ifndef ELEMENTARY_H
#define ELEMENTARY_H

/**
 * @file Elementary.h
 * @brief Elementary's API
 *
 * Elementary API.
 */

#define ELM_UNIX
#undef ELM_WIN32
#undef ELM_WINCE
#define ELM_EDBUS
#define ELM_ALLOCA_H
#define ELM_LIBINTL_H

/* Standard headers for standard system calls etc. */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/param.h>
#include <dlfcn.h>
#include <math.h>
#include <fnmatch.h>
#include <limits.h>
#include <ctype.h>
#include <time.h>
#include <dirent.h>
#include <pwd.h>
#include <errno.h>

#ifdef ELM_UNIX
# include <locale.h>
#ifdef ELM_LIBINTL_H
# include <libintl.h>
#endif
# include <signal.h>
# include <grp.h>
# include <glob.h>
#endif

#ifdef ELM_ALLOCA_H
# include <alloca.h>
#endif

#if defined (ELM_WIN32) || defined (ELM_WINCE)
# include <malloc.h>
# ifndef alloca
#  define alloca _alloca
# endif
#endif

  
/* EFL headers */
#include <Eina.h>
#include <Eet.h>
#include <Evas.h>
#include <Ecore.h>
#include <Ecore_Evas.h>
#include <Ecore_Job.h>
#include <Ecore_Txt.h>
#include <Ecore_File.h>
#include <Edje.h>

#ifdef ELM_EDBUS
# include <E_DBus.h>
# include <E_Hal.h>
#endif

#ifdef EAPI
# undef EAPI
#endif

#ifdef _WIN32
# ifdef ELEMENTARY_BUILD
#  ifdef DLL_EXPORT
#   define EAPI __declspec(dllexport)
#  else
#   define EAPI
#  endif /* ! DLL_EXPORT */
# else
#  define EAPI __declspec(dllimport)
# endif /* ! EFL_EVAS_BUILD */
#else
# ifdef __GNUC__
#  if __GNUC__ >= 4
#   define EAPI __attribute__ ((visibility("default")))
#  else
#   define EAPI
#  endif
# else
#  define EAPI
# endif
#endif /* ! _WIN32 */


/* allow usage from c++ */
#ifdef __cplusplus
extern "C" {
#endif

/* handy macros */
#define ELM_RECTS_INTERSECT(x, y, w, h, xx, yy, ww, hh) (((x) < ((xx) + (ww))) && ((y) < ((yy) + (hh))) && (((x) + (w)) > (xx)) && (((y) + (h)) > (yy)))
   
/**************************************************************************/   
   /* Objects */
   typedef enum _Elm_Win_Type
     {
	ELM_WIN_BASIC,
	ELM_WIN_DIALOG_BASIC,
	ELM_WIN_DESKTOP,
	ELM_WIN_DOCK,
	ELM_WIN_TOOLBAR,
	ELM_WIN_MENU,
	ELM_WIN_UTILITY,
	ELM_WIN_SPLASH
     } Elm_Win_Type;

   typedef enum _Elm_Win_Keyboard_Mode
     {
	ELM_WIN_KEYBOARD_UNKNOWN,
          ELM_WIN_KEYBOARD_OFF,
          ELM_WIN_KEYBOARD_ON,
          ELM_WIN_KEYBOARD_ALPHA,
          ELM_WIN_KEYBOARD_NUMERIC,
          ELM_WIN_KEYBOARD_PIN,
          ELM_WIN_KEYBOARD_PHONE_NUMBER,
          ELM_WIN_KEYBOARD_HEX,
          ELM_WIN_KEYBOARD_TERMINAL,
          ELM_WIN_KEYBOARD_PASSWORD
     } Elm_Win_Keyboard_Mode;

#ifndef ELM_LIB_QUICKLAUNCH   
#define ELM_MAIN() int main(int argc, char **argv) {elm_init(argc, argv); return elm_main(argc, argv);}
#else
#define ELM_MAIN() int main(int argc, char **argv) {return elm_quicklaunch_fallback(argc, argv);}
#endif
   
/**************************************************************************/   
   /* General calls */
   EAPI void         elm_init(int argc, char **argv);
   EAPI void         elm_shutdown(void);
   EAPI void         elm_run(void);
   EAPI void         elm_exit(void);
   
   EAPI void         elm_quicklaunch_init(int argc, char **argv);
   EAPI void         elm_quicklaunch_sub_init(int argc, char **argv);
   EAPI void         elm_quicklaunch_sub_shutdown(void);
   EAPI void         elm_quicklaunch_shutdown(void);
   EAPI void         elm_quicklaunch_seed(void);
   EAPI Evas_Bool    elm_quicklaunch_prepare(int argc, char **argv);
   EAPI Evas_Bool    elm_quicklaunch_fork(int argc, char **argv, char *cwd, void (postfork_func) (void *data), void *postfork_data);
   EAPI void         elm_quicklaunch_cleanup(void);
   EAPI int          elm_quicklaunch_fallback(int argc, char **argv);
   EAPI char        *elm_quicklaunch_exe_path_get(const char *exe);
       
   EAPI void         elm_object_scale_set(Evas_Object *obj, double scale);
   EAPI double       elm_object_scale_get(const Evas_Object *obj);
   EAPI void         elm_object_style_set(Evas_Object *obj, const char *style);
   EAPI const char  *elm_object_style_get(const Evas_Object *obj);

   EAPI double       elm_scale_get(void);
   EAPI void         elm_scale_set(double scale);
   EAPI Evas_Coord   elm_finger_size_get(void);
   EAPI void         elm_finger_size_set(Evas_Coord size);
       
   EAPI void         elm_object_focus(Evas_Object *obj);
   
   EAPI void         elm_coords_finger_size_adjust(int times_w, Evas_Coord *w, int times_h, Evas_Coord *h);
   
   EAPI void         elm_theme_overlay_add(const char *item);
   EAPI void         elm_theme_extension_add(const char *item);
       
   EAPI Evas_Object *elm_win_add(Evas_Object *parent, const char *name, Elm_Win_Type type);
   EAPI void         elm_win_resize_object_add(Evas_Object *obj, Evas_Object *subobj);
   EAPI void         elm_win_resize_object_del(Evas_Object *obj, Evas_Object *subobj);
   EAPI void         elm_win_title_set(Evas_Object *obj, const char *title);
   EAPI void         elm_win_autodel_set(Evas_Object *obj, Evas_Bool autodel);
   EAPI void         elm_win_activate(Evas_Object *obj);
   EAPI void         elm_win_lower(Evas_Object *obj);
   EAPI void         elm_win_raise(Evas_Object *obj);
   EAPI void         elm_win_borderless_set(Evas_Object *obj, Evas_Bool borderless);
   EAPI void         elm_win_shaped_set(Evas_Object *obj, Evas_Bool shaped);
   EAPI void         elm_win_alpha_set(Evas_Object *obj, Evas_Bool alpha);
   EAPI void         elm_win_override_set(Evas_Object *obj, Evas_Bool override);
   EAPI void         elm_win_fullscreen_set(Evas_Object *obj, Evas_Bool fullscreen);
   EAPI void         elm_win_maximized_set(Evas_Object *obj, Evas_Bool maximized);
   EAPI void         elm_win_iconified_set(Evas_Object *obj, Evas_Bool iconified);
   EAPI void         elm_win_layer_set(Evas_Object *obj, int layer);
   EAPI void         elm_win_rotation_set(Evas_Object *obj, int rotation);
   EAPI void         elm_win_sticky_set(Evas_Object *obj, Eina_Bool sticky);

   /*...
    * ecore_x_icccm_hints_set -> accepts_focus (add to ecore_evas)
    * ecore_x_icccm_hints_set -> window_group (add to ecore_evas)
    * ecore_x_icccm_size_pos_hints_set -> request_pos (add to ecore_evas)
    * ecore_x_icccm_client_leader_set -> l (add to ecore_evas)
    * ecore_x_icccm_window_role_set -> role (add to ecore_evas)
    * ecore_x_icccm_transient_for_set -> forwin (add to ecore_evas)
    * ecore_x_netwm_window_type_set -> type (add to ecore_evas)
    * 
    * (add to ecore_x) set netwm argb icon! (add to ecore_evas)
    * (blank mouse, private mouse obj, defaultmouse)
    *
    */
   EAPI void         elm_win_keyboard_mode_set(Evas_Object *obj, Elm_Win_Keyboard_Mode mode);
   EAPI void         elm_win_keyboard_win_set(Evas_Object *obj, Evas_Bool is_keyboard);

   EAPI Evas_Object *elm_win_inwin_add(Evas_Object *obj);
   EAPI void         elm_win_inwin_activate(Evas_Object *obj);
   EAPI void         elm_win_inwin_style_set(Evas_Object *obj, const char *style);
   EAPI void         elm_win_inwin_content_set(Evas_Object *obj, Evas_Object *content);
   /* available styles: 
    * default
    * minimal
    * minimal_vertical
    */
       
   /* X specific calls - won't work on non-x engines (return 0) */
   EAPI Ecore_X_Window elm_win_xwindow_get(const Evas_Object *obj);   
   /* smart callbacks called:
    * "delete-request" - the user requested to delete the window
    * "focus-in" - window got focus
    * "focus-out" - window lost focus
    */

   EAPI Evas_Object *elm_bg_add(Evas_Object *parent);
   EAPI void         elm_bg_file_set(Evas_Object *obj, const char *file, const char *group);
   /* smart callbacks called:
    */

   EAPI Evas_Object *elm_icon_add(Evas_Object *parent);
   EAPI Eina_Bool    elm_icon_file_set(Evas_Object *obj, const char *file, const char *group);
   EAPI void         elm_icon_standard_set(Evas_Object *obj, const char *name);
   EAPI void         elm_icon_smooth_set(Evas_Object *obj, Evas_Bool smooth);
   EAPI void         elm_icon_no_scale_set(Evas_Object *obj, Evas_Bool no_scale);
   EAPI void         elm_icon_scale_set(Evas_Object *obj, Evas_Bool scale_up, Evas_Bool scale_down);
   EAPI void         elm_icon_fill_outside_set(Evas_Object *obj, Evas_Bool fill_outside);
   EAPI void         elm_icon_prescale_set(Evas_Object *obj, int size);
   /* smart callbacks called:
    * "clicked" - the user clicked the icon
    */

   typedef enum _Elm_Image_Orient
     {
	ELM_IMAGE_ORIENT_NONE,
	ELM_IMAGE_ROTATE_90_CW,
	ELM_IMAGE_ROTATE_180_CW,
	ELM_IMAGE_ROTATE_90_CCW,
	ELM_IMAGE_FLIP_HORIZONTAL,
	ELM_IMAGE_FLIP_VERTICAL,
	ELM_IMAGE_FLIP_TRANSPOSE,
	ELM_IMAGE_FLIP_TRANSVERSE
     } Elm_Image_Orient;

   EAPI Evas_Object *elm_image_add(Evas_Object *parent);
   EAPI Eina_Bool    elm_image_file_set(Evas_Object *obj, const char *file, const char *group);
   EAPI void         elm_image_smooth_set(Evas_Object *obj, Evas_Bool smooth);
   EAPI void         elm_image_no_scale_set(Evas_Object *obj, Evas_Bool no_scale);
   EAPI void         elm_image_scale_set(Evas_Object *obj, Evas_Bool scale_up, Evas_Bool scale_down);
   EAPI void         elm_image_fill_outside_set(Evas_Object *obj, Evas_Bool fill_outside);
   EAPI void         elm_image_prescale_set(Evas_Object *obj, int size);
   EAPI void         elm_image_orient_set(Evas_Object *obj, Elm_Image_Orient orient);
   /* smart callbacks called:
    * "clicked" - the user clicked the image
    */

   EAPI Evas_Object *elm_box_add(Evas_Object *parent);
   EAPI void         elm_box_horizontal_set(Evas_Object *obj, Evas_Bool horizontal);
   EAPI void         elm_box_homogenous_set(Evas_Object *obj, Evas_Bool homogenous);
   EAPI void         elm_box_pack_start(Evas_Object *obj, Evas_Object *subobj);
   EAPI void         elm_box_pack_end(Evas_Object *obj, Evas_Object *subobj);
   EAPI void         elm_box_pack_before(Evas_Object *obj, Evas_Object *subobj, Evas_Object *before);
   EAPI void         elm_box_pack_after(Evas_Object *obj, Evas_Object *subobj, Evas_Object *after);
   /* smart callbacks called:
    */
   
   EAPI Evas_Object *elm_button_add(Evas_Object *parent);
   EAPI void         elm_button_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_button_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_button_style_set(Evas_Object *obj, const char *style);
   /* available styles: 
    * default 
    * hoversel_vertical 
    * hoversel_vertical_entry
    */
   /* smart callbacks called:
    * "clicked" - the user clicked the button
    */

   typedef enum _Elm_Scroller_Policy
     {
        ELM_SCROLLER_POLICY_AUTO,
          ELM_SCROLLER_POLICY_ON,
          ELM_SCROLLER_POLICY_OFF
     }
   Elm_Scroller_Policy;
   
   EAPI Evas_Object *elm_scroller_add(Evas_Object *parent);
   EAPI void         elm_scroller_content_set(Evas_Object *obj, Evas_Object *child);
   EAPI void         elm_scroller_content_min_limit(Evas_Object *obj, Evas_Bool w, Evas_Bool h);
   EAPI void         elm_scroller_region_show(Evas_Object *obj, Evas_Coord x, Evas_Coord y, Evas_Coord w, Evas_Coord h);
   EAPI void         elm_scroller_policy_set(Evas_Object *obj, Elm_Scroller_Policy policy_h, Elm_Scroller_Policy policy_v);
   EAPI void         elm_scroller_region_get(Evas_Object *obj, Evas_Coord *x, Evas_Coord *y, Evas_Coord *w, Evas_Coord *h);
   EAPI void         elm_scroller_child_size_get(Evas_Object *obj, Evas_Coord *w, Evas_Coord *h);
   EAPI void         elm_scroller_bounce_set(Evas_Object *obj, Evas_Bool h_bounce, Evas_Bool v_bounce);
   /* smart callbacks called:
    * "edge_left"
    * "edge_right"
    * "edge_top"
    * "edge_bottom"
    * "scroll"
    */

   EAPI Evas_Object *elm_label_add(Evas_Object *parent);
   EAPI void         elm_label_label_set(Evas_Object *obj, const char *label);
   /* smart callbacks called:
    */
       
   EAPI Evas_Object *elm_toggle_add(Evas_Object *parent);
   EAPI void         elm_toggle_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_toggle_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_toggle_states_labels_set(Evas_Object *obj, const char *onlabel, const char *offlabel);
   EAPI void         elm_toggle_state_set(Evas_Object *obj, Evas_Bool state);
   EAPI Evas_Bool    elm_toggle_state_get(const Evas_Object *obj);
   EAPI void         elm_toggle_state_pointer_set(Evas_Object *obj, Evas_Bool *statep);
   /* smart callbacks called:
    * "changed" - the user toggled the state
    */
   
   EAPI Evas_Object *elm_frame_add(Evas_Object *parent);
   EAPI void         elm_frame_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_frame_content_set(Evas_Object *obj, Evas_Object *content);
   EAPI void         elm_frame_style_set(Evas_Object *obj, const char *style);
   /* available styles:
    * default
    * pad_small
    * pad_medium
    * pad_large
    * pad_huge
    * outdent_top
    * outdent_bottom
    */
   /* smart callbacks called:
    */
       
   EAPI Evas_Object *elm_table_add(Evas_Object *parent);
   EAPI void         elm_table_homogenous_set(Evas_Object *obj, Evas_Bool homogenous);
   EAPI void         elm_table_pack(Evas_Object *obj, Evas_Object *subobj, int x, int y, int w, int h);
   /* smart callbacks called:
    */
   
   EAPI Evas_Object *elm_clock_add(Evas_Object *parent);
   EAPI void         elm_clock_time_set(Evas_Object *obj, int hrs, int min, int sec);
   EAPI void         elm_clock_time_get(const Evas_Object *obj, int *hrs, int *min, int *sec);
   EAPI void         elm_clock_edit_set(Evas_Object *obj, Evas_Bool edit);
   EAPI void         elm_clock_show_am_pm_set(Evas_Object *obj, Evas_Bool am_pm);
   EAPI void         elm_clock_show_seconds_set(Evas_Object *obj, Evas_Bool seconds);
   /* smart callbacks called:
    * "changed" - the user changed the time
    */

   EAPI Evas_Object *elm_layout_add(Evas_Object *parent);
   EAPI Eina_Bool    elm_layout_file_set(Evas_Object *obj, const char *file, const char *group);
   EAPI void         elm_layout_content_set(Evas_Object *obj, const char *swallow, Evas_Object *content);
   EAPI Evas_Object *elm_layout_edje_get(const Evas_Object *obj);
   /* smart callbacks called:
    */
   
   typedef enum _Elm_Hover_Axis
     {
	ELM_HOVER_AXIS_NONE,
          ELM_HOVER_AXIS_HORIZONTAL,
          ELM_HOVER_AXIS_VERTICAL,
          ELM_HOVER_AXIS_BOTH
     } Elm_Hover_Axis;
   EAPI Evas_Object *elm_hover_add(Evas_Object *parent);
   EAPI void         elm_hover_target_set(Evas_Object *obj, Evas_Object *target);
   EAPI void         elm_hover_parent_set(Evas_Object *obj, Evas_Object *parent);
   EAPI void         elm_hover_content_set(Evas_Object *obj, const char *swallow, Evas_Object *content);
   EAPI void         elm_hover_style_set(Evas_Object *obj, const char *style);
   EAPI const char  *elm_hover_best_content_location_get(const Evas_Object *obj, Elm_Hover_Axis pref_axis);
   /* available styles: 
    * default
    * popout
    * hoversel_vertical
    */
   /* smart callbacks called:
    * "clicked" - the user clicked the empty space in the hover to dismiss
    */

   typedef struct _Elm_Entry_Anchor_Info Elm_Entry_Anchor_Info;
   struct _Elm_Entry_Anchor_Info
     {
	const char *name;
	int button;
	Evas_Coord x, y, w, h;
     };
   EAPI Evas_Object *elm_entry_add(Evas_Object *parent);
   EAPI void         elm_entry_single_line_set(Evas_Object *obj, Evas_Bool single_line);
   EAPI void         elm_entry_password_set(Evas_Object *obj, Evas_Bool password);
   EAPI void         elm_entry_entry_set(Evas_Object *obj, const char *entry);
   EAPI const char  *elm_entry_entry_get(const Evas_Object *obj);
   EAPI const char  *elm_entry_selection_get(const Evas_Object *obj);
   EAPI void         elm_entry_entry_insert(Evas_Object *obj, const char *entry);
   EAPI void         elm_entry_line_wrap_set(Evas_Object *obj, Evas_Bool wrap);
   EAPI void         elm_entry_editable_set(Evas_Object *obj, Evas_Bool editable);
   EAPI void         elm_entry_select_none(Evas_Object *obj);
   EAPI void         elm_entry_select_all(Evas_Object *obj);
   EAPI char        *elm_entry_markup_to_utf8(const char *s);
   EAPI char        *elm_entry_utf8_to_markup(const char *s);
       
   /* smart callbacks called:
    * "changed" - the text content changed
    * "selection,start" - the user started selecting text
    * "selection,changed" - the user modified the selection size/location
    * "selection,cleared" - the user cleared the selection
    * "selection,paste" - the user rrequested a paste of text
    * "selection,copy" - the user copied the text
    * "selection,cut" - the user cut the text
    * "cursor,changed" - the cursor changed position
    * "anchor,clicked" - achor called was clicked | event_info = Elm_Entry_Anchor_Info
    * "activated" - when the enter key is pressed (useful for single line)
    */
   
   /* composite widgets - these basically put together basic widgets above
    * in convenient packages that do more than basic stuff */

   typedef enum _Elm_Text_Format
     {
	ELM_TEXT_FORMAT_PLAIN_UTF8,
	ELM_TEXT_FORMAT_MARKUP_UTF8
     } Elm_Text_Format;
   EAPI Evas_Object *elm_notepad_add(Evas_Object *parent);
   EAPI void         elm_notepad_file_set(Evas_Object *obj, const char *file, Elm_Text_Format format);
   /* smart callbacks called:
    */

   typedef struct _Elm_Entry_Anchorview_Info Elm_Entry_Anchorview_Info;
   struct _Elm_Entry_Anchorview_Info
     {
	const char *name;
	int button;
	Evas_Object *hover;
	struct {
	   Evas_Coord x, y, w, h;
	} anchor, hover_parent;
	Evas_Bool hover_left : 1;
	Evas_Bool hover_right : 1;
	Evas_Bool hover_top : 1;
	Evas_Bool hover_bottom : 1;
     };
   EAPI Evas_Object *elm_anchorview_add(Evas_Object *parent);
   EAPI void         elm_anchorview_text_set(Evas_Object *obj, const char *text);
   EAPI void         elm_anchorview_hover_parent_set(Evas_Object *obj, Evas_Object *parent);
   EAPI void         elm_anchorview_hover_style_set(Evas_Object *obj, const char *style);
   EAPI void         elm_anchorview_hover_end(Evas_Object *obj);
   /* smart callbacks called:
    * "anchor,clicked" - achor called was clicked | event_info = Elm_Entry_Anchorview_Info
    */
       
   typedef struct _Elm_Entry_Anchorblock_Info Elm_Entry_Anchorblock_Info;
   struct _Elm_Entry_Anchorblock_Info
     {
	const char *name;
	int button;
	Evas_Object *hover;
	struct {
	   Evas_Coord x, y, w, h;
	} anchor, hover_parent;
	Evas_Bool hover_left : 1;
	Evas_Bool hover_right : 1;
	Evas_Bool hover_top : 1;
	Evas_Bool hover_bottom : 1;
     };
   EAPI Evas_Object *elm_anchorblock_add(Evas_Object *parent);
   EAPI void         elm_anchorblock_text_set(Evas_Object *obj, const char *text);
   EAPI void         elm_anchorblock_hover_parent_set(Evas_Object *obj, Evas_Object *parent);
   EAPI void         elm_anchorblock_hover_style_set(Evas_Object *obj, const char *style);
   EAPI void         elm_anchorblock_hover_end(Evas_Object *obj);
   /* smart callbacks called:
    * "anchor,clicked" - achor called was clicked | event_info = Elm_Entry_Anchorblock_Info
    */
       
   EAPI Evas_Object *elm_bubble_add(Evas_Object *parent);
   EAPI void         elm_bubble_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_bubble_info_set(Evas_Object *obj, const char *info);
   EAPI void         elm_bubble_content_set(Evas_Object *obj, Evas_Object *content);
   EAPI void         elm_bubble_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_bubble_corner_set(Evas_Object *obj, const char *corner);
   /* smart callbacks called:
    */

   EAPI Evas_Object *elm_photo_add(Evas_Object *parent);
   EAPI Eina_Bool    elm_photo_file_set(Evas_Object *obj, const char *file);
   EAPI void         elm_photo_size_set(Evas_Object *obj, int size);
   /* smart callbacks called:
    * "clicked" - the user clicked the icon
    */

   typedef enum _Elm_Icon_Type
     {
        ELM_ICON_NONE,
          ELM_ICON_FILE,
          ELM_ICON_STANDARD
     } Elm_Icon_Type;
   typedef struct _Elm_Hoversel_Item Elm_Hoversel_Item;
   EAPI Evas_Object *elm_hoversel_add(Evas_Object *parent);
   EAPI void         elm_hoversel_hover_parent_set(Evas_Object *obj, Evas_Object *parent);
   EAPI void         elm_hoversel_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_hoversel_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_hoversel_hover_begin(Evas_Object *obj);
   EAPI void         elm_hoversel_hover_end(Evas_Object *obj);
   EAPI Elm_Hoversel_Item *elm_hoversel_item_add(Evas_Object *obj, const char *label, const char *icon_file, Elm_Icon_Type icon_type, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI void         elm_hoversel_item_del(Elm_Hoversel_Item *item);
   EAPI void        *elm_hoversel_item_data_get(Elm_Hoversel_Item *it);
   /* smart callbacks called:
    * "clicked" - the user clicked the hoversel button and popped up the sel
    * "selected" - an item in the hoversel list is selected
    * "dismissed" - the hover is dismissed
    */
   
   typedef struct _Elm_Toolbar_Item Elm_Toolbar_Item;
   EAPI Evas_Object *elm_toolbar_add(Evas_Object *parent);
   EAPI Elm_Toolbar_Item *elm_toolbar_item_add(Evas_Object *obj, Evas_Object *icon, const char *label, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI void         elm_toolbar_item_del(Elm_Toolbar_Item *item);
   EAPI void         elm_toolbar_item_select(Elm_Toolbar_Item *item);
   EAPI void         elm_toolbar_scrollable_set(Evas_Object *obj, Evas_Bool scrollable);
   /* smart callbacks called:
    * "clicked" - when the user clicks on a toolbar item and becomes selected
    */

   typedef enum _Elm_List_Mode
     {
        ELM_LIST_COMPRESS,
        ELM_LIST_SCROLL,
        ELM_LIST_LIMIT
     } Elm_List_Mode;
   typedef struct _Elm_List_Item Elm_List_Item;
   EAPI Evas_Object *elm_list_add(Evas_Object *parent);
   EAPI Elm_List_Item *elm_list_item_append(Evas_Object *obj, const char *label, Evas_Object *icon, Evas_Object *end, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI Elm_List_Item *elm_list_item_prepend(Evas_Object *obj, const char *label, Evas_Object *icon, Evas_Object *end, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI Elm_List_Item *elm_list_item_insert_before(Evas_Object *obj, Elm_List_Item *before, const char *label, Evas_Object *icon, Evas_Object *end, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI Elm_List_Item *elm_list_item_insert_after(Evas_Object *obj, Elm_List_Item *after, const char *label, Evas_Object *icon, Evas_Object *end, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI void         elm_list_clear(Evas_Object *obj);
   EAPI void         elm_list_go(Evas_Object *obj);
   EAPI void         elm_list_multi_select_set(Evas_Object *obj, Evas_Bool multi);
   EAPI void         elm_list_horizontal_mode_set(Evas_Object *obj, Elm_List_Mode mode);
   EAPI void         elm_list_always_select_mode_set(Evas_Object *obj, Evas_Bool always_select);
   EAPI const Eina_List     *elm_list_items_get(const Evas_Object *obj);
   EAPI Elm_List_Item       *elm_list_selected_item_get(const Evas_Object *obj);
   EAPI const Eina_List     *elm_list_selected_items_get(const Evas_Object *obj);
   EAPI void         elm_list_item_selected_set(Elm_List_Item *item, Evas_Bool selected);
   EAPI void         elm_list_item_show(Elm_List_Item *item);
   EAPI void         elm_list_item_del(Elm_List_Item *item);
   EAPI void         elm_list_item_del_cb_set(Elm_List_Item *item, void (*func)(void *data, Evas_Object *obj, void *event_info));
   EAPI const void  *elm_list_item_data_get(const Elm_List_Item *item);
   EAPI Evas_Object *elm_list_item_icon_get(const Elm_List_Item *item);
   EAPI Evas_Object *elm_list_item_end_get(const Elm_List_Item *item);
   EAPI Evas_Object *elm_list_item_base_get(const Elm_List_Item *item);
   EAPI const char  *elm_list_item_label_get(const Elm_List_Item *item);
   EAPI Elm_List_Item *elm_list_item_prev(const Elm_List_Item *it);
   EAPI Elm_List_Item *elm_list_item_next(const Elm_List_Item *it);

   /* smart callbacks called:
    * "clicked" - when the user double-clicked an item
    * "selected" - when the user selected an item
    * "unselected" - when the user selected an item
    */

   // FIXME: incomplete - carousel
   typedef struct _Elm_Carousel_Item Elm_Carousel_Item;
   EAPI Evas_Object *elm_carousel_add(Evas_Object *parent);
   EAPI Elm_Carousel_Item *elm_carousel_item_add(Evas_Object *obj, Evas_Object *icon, const char *label, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *data);
   EAPI void         elm_carousel_item_del(Elm_Carousel_Item *item);
   EAPI void         elm_carousel_item_select(Elm_Carousel_Item *item);
   /* smart callbacks called:
    * "clicked" - when the user clicks on a carousel item and becomes selected
    */
   
   EAPI Evas_Object *elm_slider_add(Evas_Object *parent);
   EAPI void         elm_slider_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_slider_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_slider_span_size_set(Evas_Object *obj, Evas_Coord size);
   EAPI void         elm_slider_unit_format_set(Evas_Object *obj, const char *format);
   EAPI void         elm_slider_indicator_format_set(Evas_Object *obj, const char *indicator);
   EAPI void         elm_slider_horizontal_set(Evas_Object *obj, Evas_Bool horizontal);
   EAPI void         elm_slider_min_max_set(Evas_Object *obj, double min, double max);
   EAPI void         elm_slider_value_set(Evas_Object *obj, double val);
   EAPI double       elm_slider_value_get(const Evas_Object *obj);
   EAPI void         elm_slider_inverted_set(Evas_Object *obj, Evas_Bool inverted);
   /* smart callbacks called:
    * "changed" - when the slider value changes
    * "delay,changed" - when the slider value changed, but a small time after a change (use this if you only want to respond to a change once the slider is held still for a short while).
    */
       
   typedef enum _Elm_Genlist_Item_Flags
     {
        ELM_GENLIST_ITEM_NONE = 0,
        ELM_GENLIST_ITEM_SUBITEMS = (1 << 0)
     } Elm_Genlist_Item_Flags;
   typedef struct _Elm_Genlist_Item_Class Elm_Genlist_Item_Class;
   typedef struct _Elm_Genlist_Item       Elm_Genlist_Item;
   typedef struct _Elm_Genlist_Item_Class_Func Elm_Genlist_Item_Class_Func;
   typedef char        *(*GenlistItemLabelGetFunc) (const void *data, Evas_Object *obj, const char *part);
   typedef Evas_Object *(*GenlistItemIconGetFunc)  (const void *data, Evas_Object *obj, const char *part);
   typedef Evas_Bool    (*GenlistItemStateGetFunc) (const void *data, Evas_Object *obj, const char *part);
   typedef void         (*GenlistItemDelFunc)      (const void *data, Evas_Object *obj);
                                               
   struct _Elm_Genlist_Item_Class
     {
        const char *item_style;
        struct _Elm_Genlist_Item_Class_Func {
           GenlistItemLabelGetFunc label_get;
           GenlistItemIconGetFunc icon_get;
           GenlistItemStateGetFunc state_get;
           GenlistItemDelFunc del;
        } func;
     };

   EAPI Evas_Object      *elm_genlist_add(Evas_Object *parent);
   EAPI Elm_Genlist_Item *elm_genlist_item_append(Evas_Object *obj, const Elm_Genlist_Item_Class *itc, const void *data, Elm_Genlist_Item *parent, Elm_Genlist_Item_Flags flags, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *func_data);
   EAPI Elm_Genlist_Item *elm_genlist_item_prepend(Evas_Object *obj, const Elm_Genlist_Item_Class *itc, const void *data, Elm_Genlist_Item *parent, Elm_Genlist_Item_Flags flags, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *func_data);
   EAPI Elm_Genlist_Item *elm_genlist_item_insert_before(Evas_Object *obj, const Elm_Genlist_Item_Class *itc, const void *data, Elm_Genlist_Item *before, Elm_Genlist_Item_Flags flags, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *func_data);
   EAPI Elm_Genlist_Item *elm_genlist_item_insert_after(Evas_Object *obj, const Elm_Genlist_Item_Class *itc, const void *data, Elm_Genlist_Item *after, Elm_Genlist_Item_Flags flags, void (*func) (void *data, Evas_Object *obj, void *event_info), const void *func_data);
   EAPI void              elm_genlist_clear(Evas_Object *obj);
   EAPI void              elm_genlist_multi_select_set(Evas_Object *obj, Evas_Bool multi);
   EAPI Elm_Genlist_Item *elm_genlist_selected_item_get(const Evas_Object *obj);
   EAPI const Eina_List  *elm_genlist_selected_items_get(const Evas_Object *obj);
   EAPI Elm_Genlist_Item *elm_genlist_first_item_get(const Evas_Object *obj);
   EAPI Elm_Genlist_Item *elm_genlist_last_item_get(const Evas_Object *obj);
   EAPI Elm_Genlist_Item *elm_genlist_item_next_get(const Elm_Genlist_Item *item);
   EAPI Elm_Genlist_Item *elm_genlist_item_prev_get(const Elm_Genlist_Item *item);
   EAPI Evas_Object      *elm_genlist_item_genlist_get(const Elm_Genlist_Item *item);
   EAPI Elm_Genlist_Item *elm_genlist_item_parent_get(const Elm_Genlist_Item *it);
   EAPI void              elm_genlist_item_subitems_clear(Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_selected_set(Elm_Genlist_Item *item, Evas_Bool selected);
   EAPI Evas_Bool         elm_genlist_item_selected_get(const Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_expanded_set(Elm_Genlist_Item *item, Evas_Bool expanded);
   EAPI Evas_Bool         elm_genlist_item_expanded_get(const Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_disabled_set(Elm_Genlist_Item *item, Evas_Bool disabled);
   EAPI Evas_Bool         elm_genlist_item_disabled_get(const Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_show(Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_del(Elm_Genlist_Item *item);
   EAPI const void       *elm_genlist_item_data_get(const Elm_Genlist_Item *item);
   EAPI void              elm_genlist_item_update(Elm_Genlist_Item *item);
   EAPI void              elm_genlist_horizontal_mode_set(Evas_Object *obj, Elm_List_Mode mode);
   EAPI void              elm_genlist_always_select_mode_set(Evas_Object *obj, Evas_Bool always_select);
   EAPI void              elm_genlist_no_select_mode_set(Evas_Object *obj, Evas_Bool no_select);
   /* available item styles: 
    * default
    * double_label
    */
   /* smart callbacks called:
    * "clicked" - when the user double-clicked an item
    * "selected" - when the user selected an item
    * "unselected" - when the user selected an item
    * "expanded" - when the user expanded an item
    * "contracted" - when the user contracted an item
    * "expand,request" - when the user requested to expand an item
    * "contract,request" - when the user requested to expand an item
    */
   
   EAPI Evas_Object *elm_check_add(Evas_Object *parent);
   EAPI void         elm_check_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_check_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_check_state_set(Evas_Object *obj, Evas_Bool state);
   EAPI Evas_Bool    elm_check_state_get(const Evas_Object *obj);
   EAPI void         elm_check_state_pointer_set(Evas_Object *obj, Evas_Bool *statep);
   /* smart callbacks called:
    * "changed" - the user toggled the state
    */
        
   EAPI Evas_Object *elm_radio_add(Evas_Object *parent);
   EAPI void         elm_radio_label_set(Evas_Object *obj, const char *label);
   EAPI void         elm_radio_icon_set(Evas_Object *obj, Evas_Object *icon);
   EAPI void         elm_radio_group_add(Evas_Object *obj, Evas_Object *group);
   EAPI void         elm_radio_state_value_set(Evas_Object *obj, int value);
   EAPI void         elm_radio_value_set(Evas_Object *obj, int value);
   EAPI int          elm_radio_value_get(const Evas_Object *obj);
   EAPI void         elm_radio_value_pointer_set(Evas_Object *obj, int *valuep);
   /* smart callbacks called:
    * "changed" - the user toggled the state
    */
   
   EAPI Evas_Object *elm_pager_add(Evas_Object *parent);
   EAPI void         elm_pager_content_push(Evas_Object *obj, Evas_Object *content);
   EAPI void         elm_pager_content_pop(Evas_Object *obj);
   EAPI void         elm_pager_content_promote(Evas_Object *obj, Evas_Object *content);
   EAPI Evas_Object *elm_pager_content_bottom_get(Evas_Object *obj);
   EAPI Evas_Object *elm_pager_content_top_get(Evas_Object *obj);
   /* smart callbacks called:
    */
        
#ifdef __cplusplus
}
#endif

  ////////////////////////////////////////////////////////////////////////////
 /// FIXME: TODO LIST ///////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
// 
//// (bugs - high priority)
// * scale change for hover doesnt seem to do new size alloc nicely
// * left/right arrow broken with password mode for entry + utf8 chars...
// * bubble doesnt handle child size changes right
// * table doesnt do homogenous properly
// 
//// (incomplete - medium priority)
// * disabled not supported
// * on the fly theme changes - test (should work)
// * need a hold-scroll counter in elm_widget
// * hoversel only vertical right now - make horizontal
// * when entries are in a scroller and change size, the scroller shows scrollbars. fix. same for selecting. for 1 line entries in a scroller should only have scroll arrow indicators.
// 
//// (more widgets/features - medium priority)
// * multiple genlist item styles (multi-label, 1 icon + 2 line label, header etc.)
// * carousel selector widget
// * auto-size label/text that adapts text size to its allocated region
// * [ scrollable dropdown combo box ]
// * [ notepad widget ]
// * [ toggle with 2x labelled button for 2 states ]
// * [ poker spinner with numbers + labels ]
// * [ wrapping text button bar ]
// * separator widget (h/v)
// * slide-open "panel" that can hold stuff and optionally scroll
// * calendar widget (select date)
// * range selector (select range of values from X to Y over an interval)
// * "dialogbutton" widget (bigger button for bottom of wins)
// * dialog window widget
// * phone-number widget (hilight country dial prefixes, add flags, photos of contacts that match etc.)
// * imageview widget (for large not iconic images)
// * tiled image + zoom widget (tiled map viewer)
// * dialpad widget - need one with a phone dialpad
// * file selector widget
// * progress bar widget
// * generic "tacho" widget (set min/max labels - and up to 3 intermediate labels etc.)
// * status widget (busy, stalled, running, etc.)
// * full window in window widget (so move/resize of window object does as you'd expect a child window to do within the canvas)
// * window frame widget for borderless windows that want the app to do its own frame (move, resize as well etc.)
// 
//// (improvements - low priority)
// * test for all bubble styles
// * test for all frame styles
// * test for all genlist item styles
// * test for all button styles
// * test for all hoversel styles
// * test for all inwin styles
// * test for all anchorblock styles
// * test for all anchorview styles
// * test more layout in layout
// * test normal evas (and edje) objects used as children in elm widgets
// * need a way to attach a "dnd detector" to any object
// * need a dnd handler (able to hook to dnd detector)
// * need another sample theme
// * need a way to set a preferred size of a widget (but not min or max).
// * merge with gurana
// * use evas's new box instead of a box smart
// * use evas's table instead of a table smart
// * use stack for win widget
// * determine prefix of app dynamically and export calls to get prefix info
// * load config from file
// * load config from x property
// * handle finger size property and on-the-fly changes like scaling does
// * somehow a pdf(ps) viewer widget that doesnt make it gpl (lgpl)
// * emotion widget
// * ewebkit widget
// * flash (gnash) widget
// * menu bar + menu widget
// * need url and path entry modes for vkbd
// * return list of toplevel window objects
// * focus should have an object that is layered above all others (definable layer) that moves + resizes (slides about - animated) from one focused widget to the next for focus. also emit focus/unfocus signals too
// * scroller could do with page up/down/left/right buttons and and idea of a page size
// * current sizing tree inefficient
// * need a way to filter entry data for entry (eg for phone numbers)
// * win should emit signals based on vkbd type - if it gets a message and is a vkbd win
// * win needs a way of setting aspect too
// * use the wrong call on the wrong widget and *BOOM* ... crashland
// 
//////////////////////////////////////////////////////////////////////////////
#endif
