# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
Models specific to the Amazon plugin.
"""

from elisa.core.components.model import Model


class AmazonItemModel(Model):

    """
    A item model contains one result for a search query to the Amazon Web
    Services.

    @ivar asin: the item's Amazon Standard Identification Number
    @type asin: C{unicode}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(AmazonItemModel, self).__init__()
        self.asin = None


class AmazonItemListModel(Model):

    """
    A item list model contains a list of items corresponding to the results
    returned by a search query to the Amazon Web Services.

    @ivar items: a list of items
    @type items: C{list} of L{elisa.plugins.amazon.models.AmazonItemModel}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(AmazonItemListModel, self).__init__()
        self.items = []
