# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampann <benjamin@fluendo.com>


import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-search',
    version='0.0.1',
    description='The general search architecture and system',
    license='GPL3', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    cmdclass=cmdclass,
    entry_points="""
    [elisa.core.components.resource_provider]
    SearchMetaresourceProvider = elisa.plugins.search.search_metaresource_provider:SearchMetaresourceProvider
    """)
