import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-smb_win32',
    version='0.0.1', 
    description='Samba share provider for Elisa',
    license='GPL3', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    cmdclass=cmdclass,
    entry_points="""
    [elisa.core.components.resource_provider]
    SmbWin32Resource = elisa.plugins.smbwin32.smbwin32_resource:SmbWin32Resource
    """)
