/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "ENMApp.h"
#include "ENMTaskTray.h"
#include "wx/image.h"
#include "wx/filename.h"

#include "ENMUtil.h"
#if defined(__UNIX__)
#include <sdk/DCSApi.h>
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#endif

#include "FileTar.h"
#include "DataCenter.h"
#include "SchoolSettingImporter.h"
#include "DeployThread.h"
#include <fstream>

#include "NetworkManagerDlg.h"
#include "ProfileManagerDlg.h"
#include "PolicyManager.h"
#include "LGetMAC.h"
#include <wx/textfile.h>
#include "MeshInfoManager.h"
static wxString dcLogENMApp(_T("C:\\ENMApp.log"));;
bool ENMApp::m_bStartPublishTimer = false;
bool ENMApp::m_bStartBrowse = false;
int ENMApp::m_iReBrowse = 0;
IMPLEMENT_APP(ENMApp)

const int ENMApp::ID_TIMER_INIT = ::wxNewId();
const int ENMApp::ID_TIMER_EXIT = ::wxNewId();
const int ENMApp::ID_TIMER_NOTIFY = ::wxNewId();

BEGIN_EVENT_TABLE(ENMApp, wxApp)
    EVT_TIMER(ID_TIMER_INIT, ENMApp::OnTimerInit)
    EVT_TIMER(ID_TIMER_EXIT, ENMApp::OnTimerExit)
    EVT_TIMER(ID_TIMER_NOTIFY, ENMApp::CloseNotification)
END_EVENT_TABLE()

ENMApp::ENMApp() : wxApp()
        , m_timerInit(this, ID_TIMER_INIT)
        , m_notificationtimer(this, ID_TIMER_NOTIFY)
        , m_timerExit(this, ID_TIMER_EXIT)
{
    m_taskBarIcon = NULL;
}

bool ENMApp::OnInit()
{
    wxInitAllImageHandlers();
    m_notificationDlg = NULL;
    m_ifExit = false;
    m_popBalloon = false;
    m_MeshpopBalloon = false;
    m_bSupportMesh = false;
    if ( ENMUtil::IsGuest() )
    {
        return false;
    }

    LoadResource();

    if ( !GetLock() )
    {
        if ( IsProtocolSupported() )
        {
            ShowMainFrame();
            PopupNotification();
            m_ifExit = true;
            return true;
        }
        else
        {
            system("/usr/share/EnhancedEasyNetwork/restart.sh");
            return false;
        }
    }
    else
    {
        m_popBalloon = true;
    }

    pthread = NULL;

    //get mac address
    GetMAC getmac;
    char macaddress[20];
    bool bSuccess = getmac.ReturnLocalMACAddress(macaddress);
    if (!bSuccess)
        bSuccess = getmac.ReturnLocalMACAddress(macaddress);
    if (!bSuccess)
        bSuccess = getmac.ReturnLocalMACAddress(macaddress);
    if (bSuccess)
    {
        m_timerExit.Start(3000, wxTIMER_CONTINUOUS );
    }
    else
    {
        wxMessageBox(_T("Can't register student pc, please reboot computer."));
    }
    printf("after getmac: %s\n", macaddress);

    m_timerInit.Start(20000, wxTIMER_ONE_SHOT);

    m_bSupportMesh = GetSupportMeshFlag();
    if(m_bSupportMesh)
    {
        printf("Support mesh \n");
    }
    else
    {
        printf("Don't support mesh \n");
    }


    StartDeploy();

    m_nMeshStatus = MESHSTATUS_MESHCLOSE;
    m_bMeshServer_Ra0 = false;

    return true;
}

int ENMApp::OnExit()
{
    if ( m_taskBarIcon != NULL )
    {
        delete m_taskBarIcon;
        m_taskBarIcon = NULL;
    }
    return wxApp::OnExit();
}

bool ENMApp::SetImage(char* image)
{
    wxIcon icon(&image);
    return m_taskBarIcon->SetIcon(icon, _T("Enhanced Easy Network"));
}

ENMTaskTray* ENMApp::GetENMTaskTray()
{
    return m_taskBarIcon;
}

bool ENMApp::GetLock()
{
#if defined(__UNIX__)
    struct flock fl;
    int fdlock = 0;

    fl.l_type = F_WRLCK;
    fl.l_whence = SEEK_SET;
    fl.l_start = 0;
    fl.l_len = 1;
    string file = ENMUtil::WxStringToString(::wxGetHomeDir()) + "/.enm_lock";
    if( (fdlock = open(file.c_str(), O_WRONLY|O_CREAT, 0666)) == -1 )
        return false;

    return fcntl(fdlock, F_SETLK, &fl) != -1;
#endif
}

bool ENMApp::ShowMainFrame()
{
    return true;
}

void ENMApp::OnTimerInit(wxTimerEvent& event)
{
    if ( !InitializeDCS() )
    {
        ::wxExit();
        return;
    }

    ENM_InitUserInfo userInfo;
    memcpy(userInfo.userPath.dcsString, ENMUtil::WxStringToString(ENMUtil::GetCurrentUserAppDataFolder()).c_str(), 256);
    DCS_InitUserInfo(userInfo);

#if defined(__UNIX__)
    system("killall nm-applet");
    char appName[256] = { 0 };
    readlink ("/proc/self/exe", appName, 256);
    strAppPath = wxString::FromUTF8(appName);
    strAppPath = strAppPath.SubString(0, strAppPath.Find('/', true));
#endif

#if defined(__UNIX__)
    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    resource = ENMUtil::GetLocaleFileName(langCode);
    m_locale.AddCatalogLookupPathPrefix(wxT("/usr/share/EnhancedEasyNetwork/resource"));
    wxString filePath = wxT("/usr/share/EnhancedEasyNetwork/resource/") + resource + wxT(".mo");

    if (wxFileExists(filePath))
    {
        m_locale.AddCatalog(resource);
    }
    else
    {
        m_locale.AddCatalog(wxT("en"));
    }
#endif

    if(m_bSupportMesh)
    {
        printf("Support mesh \n");
        DCS_TurnOnMesh(FALSE);

    }
//    wxInitAllImageHandlers();
    m_taskBarIcon = ENMTaskTray::GetInstance();
    m_taskBarIcon->init(argc == 2);
    ENMUtil::m_appPath = strAppPath;
}

bool ENMApp::InitializeDCS()
{
    return DCS_Initialize() == DCS_SUCCESS;
}

bool ENMApp::IsProtocolSupported()
{
#if defined(__UNIX__)
    Display *display = GDK_DISPLAY();
    Screen *screen = DefaultScreenOfDisplay(display);

    char name[32];
    g_snprintf(name, sizeof(name), "_NET_SYSTEM_TRAY_S%d", XScreenNumberOfScreen(screen));
    Atom atom = XInternAtom(display, name, False);
    Window manager = XGetSelectionOwner(display, atom);

    return manager != None;
#endif

}

void ENMApp::StartDeploy()
{
    DeployThread *dthread = new DeployThread();

    if ( dthread->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't create thread!"));
    }

    if ( dthread->Run() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't start thread!"));
    }
}

void ENMApp::Republish()
{
    printf("Enter Republish \n");
    ENMUtil::Log(dcLogENMApp, _T("Enter Republish \n"));
    #if defined(__UNIX__)
    wxString wxStrFileDir = _T("/tmp/");
    #endif
    wxString wxStrFilePath = wxStrFileDir + wxT("SchoolSettings.tar");

    if(wxFile::Exists(wxStrFilePath))
    {
        SchoolSettingImporter importer;
        wxArrayString as;
        importer.LoadSchoolSetting(wxStrFilePath, &as);

        ENMUtil::Log(dcLogENMApp, _T("Before Sleep\n"));

        wxMutexGuiEnter();
        if (DataCenter::GetInstance()->GetNetworkManagerDlgHandle()!=NULL)
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->SetNetworkProfile_NN();
    //        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->RefreshProfileList();
            printf("Refresh profile list\n");
        }
        if (DataCenter::GetInstance()->GetProfileManagerDlgHandle()!=NULL)
        {
            DataCenter::GetInstance()->GetProfileManagerDlgHandle()->RefreshProfile();
            printf("ProfileManagerDlg RefreshProfile\n");
        }
        if (DataCenter::GetInstance()->GetPolicyManager()!=NULL)
        {
            DataCenter::GetInstance()->GetPolicyManager()->ReloadPolicy();
            printf("ProfileManagerDlg ReloadPolicy\n");
        }
        wxMutexGuiLeave();
    }

    StartPublishTimer();

    return;
}

void ENMApp::OnTimerExit(wxTimerEvent& event)
{
    //checking republish
    if(m_bStartPublishTimer == true)
    {
        printf("m_bStartPublishTimer == true\n");
        if ( PublishThread::m_bExcuting == true )
        {
            pthread->ExcuteFreeAvahi();
        }
        else
        {
            ReconnectPublish();
            m_bStartPublishTimer = false;
        }
    }

}

void ENMApp::StopPublish()
{
    ENMUtil::Log(dcLogENMApp, _T("enter StopPublish \n"));
    if( pthread)
    {
        ENMUtil::Log(dcLogENMApp, _T("ExcuteFreeAvahi \n"));

        pthread->ExcuteFreeAvahi();
    }

}
void ENMApp::StartPublishTimer()
{
     ENMUtil::Log(dcLogENMApp, _T(" StartPublishTimer  \n"));
     m_bStartPublishTimer = true;
}



void ENMApp::ReconnectPublish()
{
    ENMUtil::Log(dcLogENMApp, _T("start ReconnectPublish \n"));
    printf("ReconnectPublish()\n");

    pthread = new PublishThread;

    if ( pthread->Create() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't create thread!"));
        return;
    }

    if ( pthread->Run() != wxTHREAD_NO_ERROR )
    {
        wxLogError(wxT("Can't start thread!"));
    }

    ENMUtil::Log(dcLogENMApp, _T("end ReconnectPublish \n"));

}


void CALLBACK DCSAbortHandler()
{

}

/**************************************************************************************************
* Function Name : CloseNotification                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
bool ENMApp::LoadResource()
{
#if defined(__UNIX__)
    system("killall nm-applet");
    char appName[256] = { 0 };
    readlink("/proc/self/exe", appName, 256);
    strAppPath = wxString::FromUTF8(appName);
    strAppPath = strAppPath.SubString(0, strAppPath.Find('/', true));

    int langCode = wxLocale::GetSystemLanguage();
    wxString resource;
    resource = ENMUtil::GetLocaleFileName(langCode);
    strResourcePath = strAppPath + _T("resource/");
    strImagePath = strAppPath + _T("pic/");
    strManualPath = _T("/usr/share/doc/enhanced-easy-network/");
    strManualFileName = strManualPath + _T("Intel_CMPC2.0_Enhanced_Easy_Network_User_Manual_Ubuntu") + resource + _T(".pdf.gz");
    m_locale.AddCatalogLookupPathPrefix(strResourcePath);
    return m_locale.AddCatalog(_T("resource_") + resource);
#endif
}


void ENMApp::PopupNotification()
{
    if (NULL == m_notificationDlg)
    {
        m_notificationDlg = new ENExistBalloon(NULL);
//        m_notificationDlg->PopupNotification();
        m_notificationDlg->Show(true);
    }

    m_notificationtimer.Start(3000, wxTIMER_ONE_SHOT);
}

void ENMApp::CloseNotificationHandler()
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    m_notificationtimer.Stop();
    if ( m_ifExit )
    {
        ::wxExit();
    }
}

void ENMApp::CloseNotification(wxTimerEvent & event)
{
    CloseNotificationHandler();
}
bool ENMApp::GetSupportMeshFlag()
{
    bool bResult = false;
    system("iwpriv ra0 driverVer > /tmp/support-mesh.txt");
    wxSleep(1);
    wxTextFile file(_T("/tmp/support-mesh.txt"));
    if ( file.Open() )
    {
        //printf("Number of lines: %u\n", file.GetLineCount());
        //printf("Last line: '%s'\n", file.GetLastLine().c_str());
        wxString s;

        for ( s = file.GetFirstLine(); !file.Eof(); s = file.GetNextLine() )
        {
            s = s.Lower();
            if(wxNOT_FOUND  != s.Find(wxT("support mesh")))
            {
                bResult = true;
            }
        }
    }
    else
    {
        printf("ERROR: can't open '%s'\n", file.GetName());
    }
    file.Close();
    system("rm /tmp/support-mesh.txt");
    return bResult;
}
