/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_APP_H_
#define _ENM_APP_H_

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif

#include <wx/app.h>
#include "ENMTaskTray.h"
#include <wx/snglinst.h>
#include <fcntl.h>

#include "PublishThread.h"
#include "ENExistBalloon.h"

#define MESHSTATUS_MESHCLOSE    1
#define MESHSTATUS_MESHONLY     2
#define MESHSTATUS_MESHSERVER   3
#define MESHSTATUS_MESHCLIENT   4

class ENMApp : public wxApp
{
    public:
        ENMApp();
        virtual bool OnInit();
        virtual int OnExit();
        bool GetSupportMeshFlag();
        bool m_bSupportMesh;
        bool SetImage(char* image);
        ENMTaskTray* GetENMTaskTray();

        wxString strAppPath;
        wxString strResourcePath;
        wxString strImagePath;
        wxString strManualPath;
        wxString strManualFileName;
        bool m_bMeshServer_Ra0;
        wxLocale m_locale;
        bool m_popBalloon;
        bool m_MeshpopBalloon;

        void Republish();
        void ReconnectPublish();
        void StopPublish();
        void StartDeploy();
        wxCriticalSection m_critsectPublish;
        void StartPublishTimer();

        static bool   m_bStartPublishTimer;
        static bool   m_bStartBrowse;
        static int m_iReBrowse;
        int m_nMeshStatus;
        NETWORK_MODE m_BeforeMeshNetworkMode;
        wxString m_BeforeMeshAppliedProfile;
    private:
        static const int ID_TIMER_INIT;
        static const int ID_TIMER_EXIT;
    static const int ID_TIMER_NOTIFY;

        wxTimer m_timerInit;
        wxTimer m_timerExit;
        wxTimer m_notificationtimer;
        ENMTaskTray* m_taskBarIcon;
        ENExistBalloon* m_notificationDlg;

        wxSingleInstanceChecker* m_checker;
        bool m_ifExit;
        bool GetLock();
        bool ShowMainFrame();
        bool InitializeDCS();
        bool IsProtocolSupported();
        bool LoadResource();

        void OnTimerInit(wxTimerEvent& event);
        void OnTimerExit(wxTimerEvent& event);
        void PopupNotification();
        void CloseNotificationHandler();

        PublishThread *pthread;
        void CloseNotification(wxTimerEvent& event);

        DECLARE_EVENT_TABLE()
};

DECLARE_APP(ENMApp)

void CALLBACK DCSAbortHandler();

#endif // _ENM_APP_H_
