/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMPopupMenu.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "ENMApp.h"
#include "DataCenter.h"
#include "ProfileManagementControl.h"
#include "ENMUtil.h"
#include "PolicyManager.h"
#include "MeshShareMyInternetDlg.h"
#include "MeshUseOthersInternetDlg.h"
#include "MeshConfigurationDlg.h"
#include "MeshInfoManager.h"
#include "ViewMeshNeighborsDlg.h"
#include "IPDlg.h"
#include "Profile.h"
#include "ENMUtil.h"

static wxString logFile(_T("/tmp/ENMPopupMenu.log"));
static bool m_bTurnOnMesh = false;

const int ENMPopupMenu::ID_MENU_ITEM_HELP       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_MANAGE     = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_SCAN       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE    = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE_MIN = ENMPopupMenu::ID_MENU_ITEM_PROFILE + 1;
const int ENMPopupMenu::MENU_ITEM_PROFILE_MARGIN_WIDTH  = 24;
const int ENMPopupMenu::MENU_ITEM_MARGIN_WIDTH  = 32;
const int ENMPopupMenu::ID_MENU_ITEM_CONNCETTOMESH = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_SHARE_MY_INTERNET = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_USER_OTHERS_INTERNET = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_ONLY  = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_TURNON_MESH = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_MESH = ::wxNewId();

ENMPopupMenu::ENMPopupMenu() : wxMenu(), id(::wxNewId())
{
    m_bmpCheck.LoadFile(::wxGetApp().strImagePath + _T("tick.png"), wxBITMAP_TYPE_PNG);
    m_bmpEmpty.LoadFile(::wxGetApp().strImagePath + _T("empty.png"), wxBITMAP_TYPE_PNG);

    InitMenu();
}

ENMPopupMenu::~ENMPopupMenu()
{
}

void ENMPopupMenu::InitMenu()
{
    LoadProfileMenuItems();

    this->AppendSeparator();

//#ifdef __USE_MESH__
    if(::wxGetApp().m_bSupportMesh)
        LoadMeshMenuItems();
//#endif

    m_pmiScan = new wxMenuItem(this, ID_MENU_ITEM_SCAN, _("Scan for Networks"));
#if defined(__UNIX__)
    m_pmiScan->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_scan.png"))));
#endif
    Connect(ID_MENU_ITEM_SCAN, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemScanClicked);
    this->Append(m_pmiScan);
    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    m_pmiScan->Enable(networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT);

    if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
    {
        if(::wxGetApp().m_bMeshServer_Ra0)
        {
            m_pmiScan->Enable(true);
        }
    }
    m_pmiManage = new wxMenuItem(this, ID_MENU_ITEM_MANAGE, _("Manage Network"));
#if defined(__UNIX__)
    m_pmiManage->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_manage.png"))));
#endif

    Connect(ID_MENU_ITEM_MANAGE, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemManageClicked);
    this->Append(m_pmiManage);

    this->AppendSeparator();

    m_pmiHelp = new wxMenuItem(this, ID_MENU_ITEM_HELP, _("Help..."));
    m_pmiHelp->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_help.png"))));

    Connect(ID_MENU_ITEM_HELP, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemHelpClicked);
    this->Append(m_pmiHelp);
}

void ENMPopupMenu::LoadProfileMenuItems()
{
    ENMUtil::Log(logFile, _T("Enter ENMPopupMenu::LoadProfileMenuItems"));
    m_pmiProfile = new wxMenuItem(this, ID_MENU_ITEM_PROFILE, _("Connect to Profile"));
    m_pmiProfile->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_pro.png"))));

    ENMUtil::Log(logFile, _T("\t Menu \"Connect to Profile\" created successfully."));

    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
    wxString _cpName = cp.sProfileName;
    ENMUtil::Log(logFile, _T("\t Get current profile: ") + _cpName);
    vector<ProfileList_t> profileVector;
    bool hasSubMenu = false;
    if ( pController->GetUserProfiles(profileVector, ENMUtil::IsAdministrator(), true) && profileVector.size() > 0 )
    {
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow == _T("1") )
                hasSubMenu = true;
        }
    }
    if ( hasSubMenu )
    {
        wxMenu* profileSubMenu = new wxMenu();
        wxMenu* pEventSource = this;
#if defined(__UNIX__)
        pEventSource = profileSubMenu;
#endif
        ENMUtil::Log(logFile, wxString::Format(_T("\t Get %d profiles"), profileVector.size()));
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow != _T("1") )
                continue;

            wxString profileName = profile.sProfileName;
            profileName.Replace(_T("&"), _T("&&"));
            int id = ID_MENU_ITEM_PROFILE_MIN + i;
            wxMenuItem* pItem = new wxMenuItem(profileSubMenu, id, profileName, _T(""), wxITEM_NORMAL, NULL);

            ENMUtil::Log(logFile, _T("\t Create menu item ") + profileName);
            if ( profile.sProfileName == cp.sProfileName && profile.sPermission == cp.sPermission )
                pItem->SetBitmap(m_bmpCheck);
            else
                pItem->SetBitmap(m_bmpEmpty);
            pEventSource->Connect(id, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemProfileClicked);
            profileSubMenu->Append(pItem);
            ENMUtil::Log(logFile, _T("\t Append menu item ") + profileName);
        }
        ENMUtil::Log(logFile, _T("\t Append menu item \"Connect to Profile\""));
        m_pmiProfile->SetSubMenu(profileSubMenu);
//        m_pmiProfile = this->AppendSubMenu(profileSubMenu, _("Connect to Profile"));
    }
    this->Append(m_pmiProfile);
    if ( !hasSubMenu )
    {
        ENMUtil::Log(logFile, _T("\t No profile"));
        m_pmiProfile->Enable(false);
    }
    ENMUtil::Log(logFile, _T("Return ENMPopupMenu::LoadProfileMenuItems\n"));
}


void ENMPopupMenu::LoadMeshMenuItems()
{
    m_pmiMesh = new wxMenuItem(this, ID_MENU_ITEM_MESH, _("Connect to Mesh Network"));
#if defined(__UNIX__)
    m_pmiMesh->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/Mesh32.png"))));
#endif
	wxMenu* pMeshSubMenu = new wxMenu();
	wxMenu* pEventSource = this;
#if defined(__UNIX__)
	pEventSource = pMeshSubMenu;
#endif

	wxMenuItem* pItem = new wxMenuItem(pMeshSubMenu, 0, _T("Mesh Server (Share My Internet)"), _T(""), wxITEM_NORMAL, NULL);

	if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
	{
		pItem->SetBitmap(m_bmpCheck);
	}
	else
	{
		pItem->SetBitmap(m_bmpEmpty);
	}

	pEventSource->Connect(0, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemShareMyInternetClicked);
	pMeshSubMenu->Append(pItem);

    bool WirelessConnected = (MeshInfoManager::GetInstance()->IsAdapterConnect( DCS_ADAPTER_WIREDLESS)) && (MeshInfoManager::GetInstance()->CheckWirelessLink());
    bool WiredConnected = MeshInfoManager::GetInstance()->IsAdapterConnect(DCS_ADAPTER_WIRED);

    pItem->Enable(WirelessConnected || WiredConnected);



	wxMenuItem* pItem1 = new wxMenuItem(pMeshSubMenu, 1, _T("Mesh Client (Use Other's Internet)"), _T(""), wxITEM_NORMAL, NULL);
	if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHCLIENT)
	{
		pItem1->SetBitmap(m_bmpCheck);
	}
	else
	{
		pItem1->SetBitmap(m_bmpEmpty);
	}

	pEventSource->Connect(1, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemUseOthersInternetClicked);
	pMeshSubMenu->Append(pItem1);

	wxMenuItem* pItem2 = new wxMenuItem(pMeshSubMenu, 2, _T("Mesh Only"), _T(""), wxITEM_NORMAL, NULL);
	if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHONLY)
	{
		pItem2->SetBitmap(m_bmpCheck);
	}
	else
	{
		pItem2->SetBitmap(m_bmpEmpty);
	}

	pEventSource->Connect(2, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemOnlyClicked);
	pMeshSubMenu->Append(pItem2);


	if(MeshInfoManager::GetInstance()->MeshHaveOpen())
	{
		wxMenuItem* pItem3 = new wxMenuItem(pMeshSubMenu, 3, _T("Turn off Mesh"), _T(""), wxITEM_NORMAL, NULL);
		pEventSource->Connect(3, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemTurnOffClicked);
		pMeshSubMenu->Append(pItem3);
	}

	m_pmiMesh->SetSubMenu(pMeshSubMenu);

    this->Append(m_pmiMesh);
}


void ENMPopupMenu::OnMenuItemHelpClicked(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/doc/enhanced-easy-network/Intel_CMPC2.0_Enhanced_Easy_Network_User_Manual_Ubuntu.pdf.gz")))
    {
        wxString cmd = wxT("evince /usr/share/doc/enhanced-easy-network/Intel_CMPC2.0_Enhanced_Easy_Network_User_Manual_Ubuntu.pdf.gz --page-label=1");
        wxExecute(cmd);
    }
#endif
}

void ENMPopupMenu::OnMenuItemManageClicked(wxCommandEvent& event)
{
    NetworkManagerDlg* networkManagerDlg = DataCenter::GetInstance()->GetNetworkManagerDlgHandle();
    if ( NULL == networkManagerDlg )
    {
        return;
    }
//    networkManagerDlg->SetNetworkProfile();
    networkManagerDlg->Iconize(false);
    networkManagerDlg->Show();
    networkManagerDlg->Raise();
}

void ENMPopupMenu::OnMenuItemScanClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids scanning for wireless networks."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( scanNetworkDlg->IsShown() )
    {
        scanNetworkDlg->CloseDialog(wxID_CANCEL);
    }
    scanNetworkDlg->SetDialogMode(true);
    scanNetworkDlg->Iconize(false);
    scanNetworkDlg->Show();
    scanNetworkDlg->Raise();
}

void ENMPopupMenu::OnMenuItemProfileClicked(wxCommandEvent& event)
{
    if ( ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE &&
     ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHSERVER)
    {
        MeshInfoManager::GetInstance()->TurnOffMesh();
    }

    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( scanNetworkDlg->IsShown() )
    {
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    int id = event.GetId();
    wxMenu* pMenu = static_cast<wxMenu*>(event.GetEventObject());
    wxMenuItem* pItem = pMenu->FindItem(id);
    wxString profileName = pItem->GetItemLabel();
    ProfileList_t* pProfile;
    pProfile = DataCenter::GetInstance()->GetProfileController()->GetProfile(id - ID_MENU_ITEM_PROFILE_MIN);
    if ( NULL == pProfile )
        return;
    if ( !DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsProfileAcceptable(*pProfile) )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids turning on/off wireless."), wxEmptyString, wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER )
    {
        if ( ::wxGetApp().m_MeshpopBalloon == false )
        {
            wxString ProfileType = pProfile->stGenernalSet.ConnecType;
            if ( (ProfileType.Cmp(_T("wireless")) == 0) && (::wxGetApp().m_bMeshServer_Ra0 == false))
            {
                wxMessageDialog dlg(NULL, _("You are sharing the wired interface, please select a wried profile to connect."), wxEmptyString, wxOK | wxICON_INFORMATION);
                dlg.ShowModal();
                return;
            }
            else if ( (ProfileType.Cmp(_T("lan")) == 0) && (::wxGetApp().m_bMeshServer_Ra0 == true))
            {
                wxMessageDialog dlg(NULL, _("You are sharing the wireless interface, please select a wireless profile to connect."), wxEmptyString, wxOK | wxICON_INFORMATION);
                dlg.ShowModal();
                return;
            }
        }
        wxMessageDialog dlg(NULL, _("Are you sure you want to disconnect current network and turn off mesh server?"),
            wxEmptyString, wxYES_NO | wxNO_DEFAULT |wxICON_EXCLAMATION);
        if(wxID_YES != dlg.ShowModal())
        {
            return;
        }
        MeshInfoManager::GetInstance()->TurnOffMesh();
    }
    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->ShowApplyingProcessDialog(profileName, true);
    DataCenter::GetInstance()->GetProfileController()->ApplyProfile(*pProfile);
}

// Turn on mesh
void ENMPopupMenu::TurnOnMesh()
{
    printf("TurnOn m_nMeshStatus = %d\n",::wxGetApp().m_nMeshStatus);

    ::wxGetApp().m_BeforeMeshNetworkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    ::wxGetApp().m_BeforeMeshAppliedProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();

    DCS_TurnOnMesh(TRUE);

    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->m_menuMeshDC->Enable(true);
}
//if wireless connected, turn on mesh is different
void ENMPopupMenu::TurnOnMesh_Wireless()
{
    printf("TurnOn m_nMeshStatus = %d\n",::wxGetApp().m_nMeshStatus);

    ::wxGetApp().m_BeforeMeshNetworkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    ::wxGetApp().m_BeforeMeshAppliedProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();

//    DCS_TurnOnMesh(TRUE);
    DCS_SetMeshChannelOFFSET(5);

    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->m_menuMeshDC->Enable(true);
}

void ENMPopupMenu::OnMenuItemTurnOffClicked(wxCommandEvent& event)
{
    printf("TurnOff m_nMeshStatus\n");
    if ( MESHSTATUS_MESHSERVER==::wxGetApp().m_nMeshStatus )
    {
        MeshInfoManager::GetInstance()->SetHostNameToClient();
    }

    //turn off mesh
    MeshInfoManager::GetInstance()->TurnOffMesh();

    MeshUseOthersInternetDlg* pMeshUseOtherInternetDlg = DataCenter::GetInstance()->GetMeshUseOthersInternetDlgHandle();
    if ( NULL != pMeshUseOtherInternetDlg && pMeshUseOtherInternetDlg->IsShown() )
    {
        pMeshUseOtherInternetDlg->Show(false);
    }
    MeshShareMyInternetDlg* pMeshShareMyInternetDlg = DataCenter::GetInstance()->GetMeshShareMyInternetDlgHandle();
    if ( NULL != pMeshShareMyInternetDlg && pMeshShareMyInternetDlg->IsShown() )
    {
        pMeshShareMyInternetDlg->Show(false);
    }
    MeshConfigurationDlg* pMeshConfigurationDlg = DataCenter::GetInstance()->GetMeshConfigurationDlgHandle();
    if ( NULL != pMeshConfigurationDlg && pMeshConfigurationDlg->IsShown() )
    {
        pMeshConfigurationDlg->Show(false);
    }
    ViewMeshNeighborsDlg* pViewMeshNeighborsDlg = DataCenter::GetInstance()->GetViewMeshNeighborsDlgHandle();
    if ( NULL != pViewMeshNeighborsDlg && pViewMeshNeighborsDlg->IsShown() )
    {
        pViewMeshNeighborsDlg->Show(false);
    }
    //stop browse
    //stop publish
    MeshInfoManager::GetInstance()->ChangeMeshClientMode(false);
    MeshInfoManager::GetInstance()->ChangeMeshServerMode(false);

    // ifconfig eth up
    DCS_SetMeshChannelOFFSET(3);

    wxString strProfile = ::wxGetApp().m_BeforeMeshAppliedProfile;

    printf("get profile \n");
    bool bIsAdmin = ENMUtil::IsAdministrator();
    ProfileList_t* profilelist = DataCenter::GetInstance()->GetProfileController()->GetProfile(strProfile, bIsAdmin);

    if (strProfile.IsEmpty() || NULL == profilelist)
    {
        printf("if (strProfile.IsEmpty())\n");

        NETWORK_MODE NetworkMode = ::wxGetApp().m_BeforeMeshNetworkMode;
        if ( NETWORK_MODE_WIRED_LAN_CONNECT == NetworkMode ||
             NETWORK_MODE_WIRED_LAN_DISCONNECT == NetworkMode)
        {
            printf("ADAPTER_WIRED\n");
            DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIRED, true);
            printf("ADAPTER_WIRED enabled \n");
        }
        else if ( NETWORK_MODE_WIRELESS_LAN_CONNECT == NetworkMode ||
                  NETWORK_MODE_WIRELESS_LAN_DISCONNECT == NetworkMode)
        {
            printf("ADAPTER_WIRELESS\n");
             DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, true);
             printf("ADAPTER_WIRELESS enabled \n");
        }
    }
    else
    {
        printf("else (strProfile.IsEmpty())\n");
        bool bIsAdmin = ENMUtil::IsAdministrator();
        printf("Is admin \n");
        //ProfileList_t* profilelist = DataCenter::GetInstance()->GetProfileController()->GetProfile(strProfile, bIsAdmin);
        //printf("ProfileList_t*");
        if (NULL != profilelist)
        {
            DataCenter::GetInstance()->GetProfileController()->ApplyProfile(*profilelist);
        }
        printf("ApplyProfile enabled\n");
    }
}

void ENMPopupMenu::OnMenuItemShareMyInternetClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsMeshEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids using mesh."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    bool WirelessConnected = MeshInfoManager::GetInstance()->IsAdapterConnect(DCS_ADAPTER_WIREDLESS);
    bool WiredConnected = MeshInfoManager::GetInstance()->IsAdapterConnect(DCS_ADAPTER_WIRED);

    if(!WirelessConnected)
    {
        // ifconfig ra0 up
        DCS_SetMeshChannelOFFSET(4);
        // ifconfig ra0 down
        DCS_SetMeshChannelOFFSET(2);
    }

    if (MESHSTATUS_MESHCLOSE == ::wxGetApp().m_nMeshStatus)
    {
        if (WirelessConnected)
        {
            TurnOnMesh_Wireless();
            wxSleep(8);
        }
        else
        {
            TurnOnMesh();
            wxSleep(8);
        }

        //change hostname
        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        DCS_GetMeshHostName(sHostName);
        char* strHostNameAll = (char *)(sHostName->dcsString);
        printf("[MeshConfiguration] dcs_gethostname = %s \n", (char *)(sHostName->dcsString));
        int iNameLen = strlen(strHostNameAll);
        if ( strHostNameAll[iNameLen-1] == '?' )
        {
            strHostNameAll +=12;
            wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
            if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
            {
                wxString wxHostName = wxTemp.Left(wxTemp.Length()-1);
                ENM_String* sHostName = new ENM_String();
                memset(sHostName, 0, sizeof(ENM_String));
                strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(wxHostName).c_str());
                DCS_SetMeshHostName(sHostName);
            }
        }
        //register as mesh only
       ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHONLY;
    }

    if(WiredConnected)   // if eth connected
    {
        printf("WiredConnect\n");
       //change mesh hostname

        MeshInfoManager::GetInstance()->SetHostNameToServer();

        wxString strEthName = MeshInfoManager::GetInstance()->GetEthName();

        //register as mesh server
        ENM_String exif;
        strcpy((char *)(exif.dcsString), (ENMUtil::WxStringToString(strEthName)).c_str());
        DCS_EnableMeshServer(&exif);

        ::wxGetApp().m_bMeshServer_Ra0 = false;
        ::wxGetApp().m_MeshpopBalloon = true;
        //register as mesh server
        ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHSERVER;
    }
    else if(WirelessConnected)  //else if ra0 connected
    {
        printf("WirelessConnected\n");

        // ifconfig eth down
        DCS_SetMeshChannelOFFSET(1);

        //change mesh hostname
        MeshInfoManager::GetInstance()->SetHostNameToServer();
        //register as mesh server
        ENM_String exif;
        strcpy((char *)(exif.dcsString), (ENMUtil::WxStringToString(wxT("ra0"))).c_str());
        DCS_EnableMeshServer(&exif);

        ::wxGetApp().m_bMeshServer_Ra0 = true;
        ::wxGetApp().m_MeshpopBalloon = true;
        //register as mesh server
        ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHSERVER;
    }
//    else    // both eth and ra can't connected
//    {
//        printf("NoConnected\n");
//        MeshShareMyInternetDlg* pMeshShareMyInternetDlg = DataCenter::GetInstance()->GetMeshShareMyInternetDlgHandle();
//        pMeshShareMyInternetDlg->Show();
//
//        ::wxGetApp().m_MeshpopBalloon = false;
//    }
}

void ENMPopupMenu::OnMenuItemUseOthersInternetClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsMeshEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids using mesh."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    if (MESHSTATUS_MESHCLOSE==::wxGetApp().m_nMeshStatus)
    {
        // ifconfig eth down
        DCS_SetMeshChannelOFFSET(1);

        // ifconfig ra0 up
        DCS_SetMeshChannelOFFSET(4);
        // ifconfig ra0 down
        DCS_SetMeshChannelOFFSET(2);

        TurnOnMesh();
        wxSleep(5);

        //change hostname
        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        DCS_GetMeshHostName(sHostName);
        char* strHostNameAll = (char *)(sHostName->dcsString);
        printf("[MeshConfiguration] dcs_gethostname = %s \n", (char *)(sHostName->dcsString));
        int iNameLen = strlen(strHostNameAll);
        if ( strHostNameAll[iNameLen-1] == '?' )
        {
            strHostNameAll +=12;
            wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
            if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
            {
                wxString wxHostName = wxTemp.Left(wxTemp.Length()-1);
                ENM_String* sHostName = new ENM_String();
                memset(sHostName, 0, sizeof(ENM_String));
                strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(wxHostName).c_str());
                DCS_SetMeshHostName(sHostName);
            }
        }
        //register as mesh only
       ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHONLY;
    }

    MeshUseOthersInternetDlg* pMeshUseOthersInternetDlg = DataCenter::GetInstance()->GetMeshUseOthersInternetDlgHandle();

    MeshInfoManager::GetInstance()->ChangeMeshServerMode(false);

    pMeshUseOthersInternetDlg->Show(true);
}

void ENMPopupMenu::OnMenuItemOnlyClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsMeshEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids using mesh."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    // ifconfig eth down
    DCS_SetMeshChannelOFFSET(1);
//    DataCenter::GetInstance()->CloseWlanConnection();

    // ifconfig ra0 up
    DCS_SetMeshChannelOFFSET(4);
    // ifconfig ra0 down
    DCS_SetMeshChannelOFFSET(2);

    if ( MESHSTATUS_MESHSERVER==::wxGetApp().m_nMeshStatus )
    {
        MeshInfoManager::GetInstance()->SetHostNameToClient();
    }
    if (MESHSTATUS_MESHCLOSE==::wxGetApp().m_nMeshStatus)
    {
        TurnOnMesh();
        wxSleep(5);

        //change hostname
        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        DCS_GetMeshHostName(sHostName);
        char* strHostNameAll = (char *)(sHostName->dcsString);
        printf("[MeshConfiguration] dcs_gethostname = %s \n", (char *)(sHostName->dcsString));
        int iNameLen = strlen(strHostNameAll);
        if ( strHostNameAll[iNameLen-1] == '?' )
        {
            strHostNameAll +=12;
            wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
            if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
            {
                wxString wxHostName = wxTemp.Left(wxTemp.Length()-1);
                ENM_String* sHostName = new ENM_String();
                memset(sHostName, 0, sizeof(ENM_String));
                strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(wxHostName).c_str());
                DCS_SetMeshHostName(sHostName);
            }
        }
    }
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHONLY;
    MeshInfoManager::GetInstance()->ChangeMeshServerMode(false);
}

//bool ENMPopupMenu::IsAdapterConnect(ENM_ADAPTER_TYPE AdpaterType)
//{
//    BOOL existAdapter;
//    DCS_IsExistAdapter(AdpaterType, &existAdapter);
//    if ( existAdapter )
//    {
//        printf("adapter exists \n ");
//        BOOL bIfConnect;
//        DCS_IsExistConnectAdapter(AdpaterType, &bIfConnect);
//        if (!bIfConnect)
//        {
//            printf("adpater not connecct. \n");
//            return false;
//        }
//        DCS_UpAdapter(AdpaterType);
//        ENM_String* IP = new ENM_String();
//        memset(IP, 0, sizeof(ENM_String));
//        DCS_GetIPAddressHLAN(IP);
//        string strIP((const char*)IP->dcsString);
//        delete IP;
//
//        if ( (strIP == "127.0.0.1") || (strIP.empty()) )
//        {
//            return false;
//        }
//        else
//        {
//            return true;
//        }
//    }
//}

