/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

// For compilers that support precompilation, includes "wx.h".
//#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "ENMApp.h"
#include "ENMTaskTray.h"
#include "ENMPopupMenu.h"
#include "pic/Mesh.xpm"
#include "DataCenter.h"
#include "ProfileManagementControl.h"
#include "ENMUtil.h"
#include "wlanacmevent.h"
#include "PopupConfirmDialog.h"

#if defined(__UNIX__)
#include <X11/Xatom.h>
#include <gdk/gdkx.h>
#endif

static wxString logFile(_T("/tmp/ENMTaskTray.log"));

ENMTaskTray* ENMTaskTray::instance = NULL;
const long ENMTaskTray::ID_TIMER_CLICK = wxNewId();
const long ENMTaskTray::ID_TIMER_TICK = wxNewId();
const int ENMTaskTray::ID_NOTI_TIMER = ::wxNewId();
const long DOUBLE_CLICK_TIME = 500;
const long BALLOON_TIME = 4000;

BEGIN_EVENT_TABLE(ENMTaskTray, wxTaskBarIcon)
//    EVT_TASKBAR_LEFT_DCLICK  (ENMTaskTray::OnLeftButtonDClick)
    EVT_TASKBAR_LEFT_UP (ENMTaskTray::OnLeftButtonUp)
    EVT_TASKBAR_RIGHT_UP (ENMTaskTray::OnRightButtonUp)
    EVT_TASKBAR_MOVE (ENMTaskTray::OnMouseOver)
    EVT_TIMER(ID_TIMER_TICK,ENMTaskTray::OnTimerTick)
    EVT_WLAN_ACM(ID_WLAN_ACM_CONNECT, ENMTaskTray::OnWlanAcmEvent)
    EVT_TIMER(ID_TIMER_CLICK,ENMTaskTray::ClickTimeEvent)
    EVT_PROFILE(ID_PROFILE_APPLY, ENMTaskTray::OnProfileChangedEvent)
    EVT_WIRELESS(ID_WIRELESS_NETWORK_SWITCH, ENMTaskTray::OnWirelessSwitchEvent)
    EVT_SWITCH_ADAPTER(ID_SWITCH_ADAPTER, ENMTaskTray::OnAdapterSwitched)
    EVT_TIMER(ID_NOTI_TIMER,ENMTaskTray::CloseNotification)
END_EVENT_TABLE()

ENMTaskTray::ENMTaskTray():m_clickTimer(this,ID_TIMER_CLICK)
{
    m_ap = NULL;
    balloon = NULL;
    m_balloonLAN = NULL;
    m_balloonMesh = NULL;
    disconBalloon = NULL;
    eNMApplyProfileBalloon = NULL;
    m_netInfo = new NETWORK_INFO;
    iVector = 0;
    bApplyFinish = false;
    m_bDoubleClick = false;
    m_MousePos.x = m_MousePos.y = 0;
    SetApplyWirelessFlag(true);
    m_ApplyWirelessProfileBalloon = NULL;
    m_ApplyWiredProfileBalloon = NULL;
    SetApplyWiredFlag(true);
    m_notificationtimer = NULL;
    m_notificationDlg = NULL;
}

ENMTaskTray::~ENMTaskTray()
{
    if ( eNMApplyProfileBalloon != NULL )
    {
        delete eNMApplyProfileBalloon;
        eNMApplyProfileBalloon = NULL;
    }

    if ( m_ApplyWirelessProfileBalloon != NULL )
    {
        delete m_ApplyWirelessProfileBalloon;
        m_ApplyWirelessProfileBalloon = NULL;
    }

    if ( m_ApplyWiredProfileBalloon != NULL )
    {
        delete m_ApplyWiredProfileBalloon;
        m_ApplyWiredProfileBalloon = NULL;
    }
}

ENMTaskTray* ENMTaskTray::GetInstance()
{
    if ( NULL == instance )
    {
        instance = new ENMTaskTray();
    }

    return instance;
}

void ENMTaskTray::OnMouseOver(wxTaskBarIconEvent&)
{
//    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnMouseOver"));
    if ( m_MousePos.x == 0 && m_MousePos.y == 0 )
    {
        m_MousePos = wxGetMousePosition();
    }
    else
    {
        wxPoint temp = wxGetMousePosition();

        if ( temp == m_MousePos )
        {
            m_MousePos = wxGetMousePosition();
            return;
        }
        else
        {
            m_MousePos = wxGetMousePosition();
        }
    }

    m_ap = DataCenter::GetInstance()->GetCurrentAPStatus();

    wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();

    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    switch ( networkMode )
    {
        case NETWORK_MODE_WIRED_LAN_CONNECT:
        {
            if ( NULL == m_balloonLAN )
            {
                m_balloonLAN = new TaskBarBalloonLAN(NULL, _T("balloon"));
                m_balloonLAN->SetConnectionTip(_("Connection successful!"));
                m_balloonLAN->SetConnectionType(_("Wired LAN"));
                wxString strLanType = DataCenter::GetInstance()->GetConnectTypeHLAN();
                wxString strType = _("Wired LAN - ");
                wxString strSpeed = strLanType.SubString(strType.length(), strLanType.length());
                m_balloonLAN->SetConnectionSpeed(strSpeed);
                if ( strProfileName.Length() == 0 )
                {
                    strProfileName = _("Wired LAN");
                }
                m_balloonLAN->SetConnectionStatus(strProfileName);
                timer = new wxTimer(this,ID_TIMER_TICK);
                m_balloonLAN->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            }
        }
            break;
        case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
            break;
        case NETWORK_MODE_WIRELESS_LAN_CONNECT:
        {
            if ( NULL == m_ap )
            {
                if ( NULL == disconBalloon )
                {
                    disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                    disconBalloon->SetScanHyperLink();
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    disconBalloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                }
            }
            else if ( NULL == balloon )
            {
                balloon = new TaskBarBalloon(NULL, _T("balloon"));
                balloon->SetConnectionTip(_("Connection successful!"));
                balloon->SetConnectionType(_("Wireless LAN"));

                if ( m_ap->type == WLAN_802_11_B )
                {
                    balloon->SetConnectionSpeed(_("11.0 Mbps"));
                }
                else if ( m_ap->type == WLAN_802_11_G )
                {
                    balloon->SetConnectionSpeed(_("54.0 Mbps"));
                }
                else if ( m_ap->type == WLAN_802_11_N )
                {
                    balloon->SetConnectionSpeed(_("108.0 Mbps"));
                }
                else
                {
                    balloon->SetConnectionSpeed(_("54.0 Mbps"));
                }


                if ( strProfileName.Length() == 0 && m_ap != NULL )
                {
                    strProfileName = wxString::FromUTF8((const char*)m_ap->ssid.ucSsid, m_ap->ssid.length);
                }

                balloon->SetConnectionStatus(strProfileName);

                if ( 0 == m_ap->signalQuality )
                {
                    m_ap->signalQuality = 80;
                }
                balloon->SetSignalQuality(DataCenter::GetInstance()->GetCurrentAPStatus()->signalQuality);
                balloon->SetSignalQualityBmp(DataCenter::GetInstance()->GetCurrentAPStatus()->signalQuality);
                timer = new wxTimer(this,ID_TIMER_TICK);
                balloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            }
        }
            break;
        case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        {
            APStatus* pAP = DataCenter::GetInstance()->GetCurrentAPStatus();
            if ( NULL == pAP || 0 == strlen((const char*)DataCenter::GetInstance()->GetCurrentAPStatus()->ssid.ucSsid) )
            {
                if ( NULL == disconBalloon )
                {
                    disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                    disconBalloon->SetScanHyperLink();
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    disconBalloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

                }
            }

        }
            break;
        case NETWORK_MODE_MESH_CONNECT:
        {
            if ( NULL == m_balloonMesh )
            {
                m_balloonMesh = new TaskBarBalloonMesh(NULL, _T("balloon"));
                m_balloonMesh->SetConnectionTip(_("Connection successful!"));
                //get mesh hostname
                ENM_String* sHostName = new ENM_String();
                memset(sHostName, 0, sizeof(ENM_String));
                DCS_GetMeshHostName(sHostName);
                char* strHostNameAll = (char *)(sHostName->dcsString);
                //just for unexpected situation
                wxString wxHostName;
                int iNameLen = strlen(strHostNameAll);
                if ( MESHSTATUS_MESHSERVER ==::wxGetApp().m_nMeshStatus ||  strHostNameAll[iNameLen-1] == '?' )
                {
                    strHostNameAll +=12;
                    wxString wxTemp = ENMUtil::StringToWxString(strHostNameAll);
                    if ( 0==wxTemp.Right(1).Cmp(wxT("?")) )
                    {
                        wxHostName = wxTemp.Left(wxTemp.Length()-1);
                    }
                }
                else
                {
                    wxHostName = ENMUtil::StringToWxString(strHostNameAll);
                }
                m_balloonMesh->SetConnectionName(wxHostName);

                if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHONLY )
                {
                    m_balloonMesh->SetConnectionType(_("Mesh Only"));
                }
                else if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER )
                {
                    m_balloonMesh->SetConnectionType(_("Mesh Server"));
                }
                else if ( ::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHCLIENT )
                {
                    m_balloonMesh->SetConnectionType(_("Mesh Client"));
                }

                m_balloonMesh->SetConnectionStatus(_("Connected"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                m_balloonMesh->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            }
        }
        break;
        case NETWORK_MODE_MESH_DISCONNECT:
            break;
        case NETWORK_MODE_DISCONNECTED:
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
            break;
        default:
            break;
     }
//     ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnMouseOver"));
}

void ENMTaskTray::OnLeftButtonUp(wxTaskBarIconEvent& event)
{
#ifdef __WXMSW__
    if ( m_clickTimer.IsRunning() )
    {
        m_bDoubleClick = true;
    }
    else
    {
        m_bDoubleClick = false;
        m_clickTimer.Start(DOUBLE_CLICK_TIME, wxTIMER_ONE_SHOT);
    }
#endif
#ifdef __UNIX__
    ShowMenu();
#endif
}

void ENMTaskTray::OnRightButtonUp(wxTaskBarIconEvent& event)
{
    ShowMenu();
}

// Overridables
wxMenu *ENMTaskTray::CreatePopupMenu()
{
    return NULL;
}

void ENMTaskTray::ShowMenu()
{
    if ( balloon )
    {
        balloon->Show(false);
    }
    if ( disconBalloon )
    {
        disconBalloon->Show(false);
    }
    if ( m_balloonLAN != NULL )
    {
        m_balloonLAN->Show(false);
    }
    ENMPopupMenu tMenu;
    this->PopupMenu(&tMenu);
}

void ENMTaskTray::ClickTimeEvent(wxTimerEvent & event)
{
    if (m_bDoubleClick)
    {
//        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->SetNetworkProfile();
        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Iconize(false);
        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show();
        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Raise();
    }
    else
    {
        ShowMenu();
    }
    m_bDoubleClick = false;
}

void ENMTaskTray::init(bool AutoRun)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::init"));
    DataCenter::GetInstance()->InitData();
    DataCenter::GetInstance()->GetProfileController()->GetUserProfiles(m_vProfiles, ENMUtil::IsAdministrator());
    DataCenter::GetInstance()->SwitchAdapterParameter(ADAPTER_TYPE(0), ADAPTER_WIRED, NULL);
    m_NotifiArea = false;
//    AutoRun = true;
    if ( AutoRun )
    {
        int iCount = 0;
        bool bNoPanel = false;
        do
        {
            if ( iCount >= 60 )
            {
//                wxExit();
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                break;
            }

            if( bNoPanel = IsProtocolSupported() )
            {
                m_NotifiArea = true;
                break;
            }
            ::wxMilliSleep(500);
            iCount++;
        }
        while( bNoPanel==false );
    }
    else
    {
       if( !IsProtocolSupported() )
       {
           DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
       }
       else
       {
           m_NotifiArea = true;
       }
    }
    DCS_UpAdapter(DCS_ADAPTER_WIRED);
    ENM_String* IP = new ENM_String();
    memset(IP, 0, sizeof(ENM_String));
    DCS_GetIPAddressLAN(IP);
    string strIP((const char*)IP->dcsString);
    delete IP;
    BOOL bIfConnect;
    DCS_IsExistConnectAdapter(DCS_ADAPTER_WIRED, &bIfConnect);
    if ( strIP != "127.0.0.1" && !strIP.empty() && bIfConnect )
    {
        bApplyFinish = true;
        DataCenter::GetInstance()->StartGlobalTimer();
       if( !IsProtocolSupported() )
       {
           DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
       }
        return;
    }

    if ( m_vProfiles.size() > 0 )
    {
        if (eNMApplyProfileBalloon == NULL)
        {
            int iSize = m_vProfiles.size();
            eNMApplyProfileBalloon = new ENMApplyProfileBalloon(NULL, _("EN"));
            while ( (iVector < iSize) && (m_vProfiles[iVector].sShow == _T("0")) )
            {
                iVector++;
            }
            if ( iVector < iSize )
            {
                eNMApplyProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                eNMApplyProfileBalloon->SetTurningOnNetwork(strType);
                eNMApplyProfileBalloon->Show();

                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                bApplyFinish = true;
//                if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIRED) &&
//                     DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
//                {
//                    DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, false);
////                    wxSleep(5);
//                }
                DataCenter::GetInstance()->StartGlobalTimer();

                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
                iVector = 0;

                eNMApplyProfileBalloon->Show(false);
                delete eNMApplyProfileBalloon;
                eNMApplyProfileBalloon = NULL;
            }
        }
    }
    else
    {
        bApplyFinish = true;
//        if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIRED) &&
//                     DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
//        {
//            DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, false);
//            wxSleep(5);
//        }
        DataCenter::GetInstance()->StartGlobalTimer();
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
        iVector = 0;

        if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                disconBalloon->SetScanHyperLink();
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
        else
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::init"));
}

void ENMTaskTray::OnTimerTick(wxTimerEvent & event)
{
    ENMUtil::Log(logFile, wxString::Format(_T("Enter ENMTaskTray::OnTimerTick(%08X)"), &event));
    if ( balloon != NULL )
    {
        ENMUtil::Log(logFile, wxString(_T("balloon != NULL---begin")));
        if ( balloon->HasCapture() )
        {
            return;
        }
        balloon->Show(false);
        delete balloon;
        balloon = NULL;
        if ( timer != NULL )
        {
            timer->Stop();
            delete timer;
            timer = NULL;
        }
        ENMUtil::Log(logFile, wxString(_T("balloon != NULL---end")));
    }

    if ( m_balloonLAN != NULL )
    {
        ENMUtil::Log(logFile, wxString(_T("m_balloonLAN != NULL---begin")));
        if ( m_balloonLAN->HasCapture() )
        {
            return;
        }
        m_balloonLAN->Show(false);
        delete m_balloonLAN;
        m_balloonLAN = NULL;
        if ( timer != NULL )
        {
            timer->Stop();
            delete timer;
            timer = NULL;
        }
        ENMUtil::Log(logFile, wxString(_T("m_balloonLAN != NULL---end")));
    }
    if ( m_balloonMesh != NULL )
    {
        if ( m_balloonMesh->HasCapture() )
        {
            return;
        }
        m_balloonMesh->Show(false);
        delete m_balloonMesh;
        m_balloonMesh = NULL;
        if ( timer != NULL )
        {
            timer->Stop();
            delete timer;
            timer = NULL;
        }
    }
    if ( disconBalloon != NULL )
    {
        ENMUtil::Log(logFile, wxString(_T("disconBalloon != NULL---begin")));

        if ( disconBalloon->HasCapture() )
        {
            return;
        }
        disconBalloon->Show(false);
        delete disconBalloon;
        disconBalloon = NULL;
        if ( timer != NULL )
        {
            timer->Stop();
            delete timer;
            timer = NULL;
        }
        timer = NULL;
        ENMUtil::Log(logFile, wxString(_T("disconBalloon != NULL---end")));
    }
    ENMUtil::Log(logFile, wxString::Format(_T("Leave ENMTaskTray::OnTimerTick(%08X)"), &event));
}

/**************************************************************************************************
* Function Name : SetTaskbarIcon                                                                     *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void ENMTaskTray::SetTaskbarIcon(const NETWORK_MODE& networkMode, const UI_NETWORK_STATUS_INFO& statusInfo)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::SetTaskbarIcon-NETWORK_MODE"));
    wxString strTip(_("Easy Network"));
    wxIcon iconLanBlack(::wxGetApp().strAppPath + _T("pic/LAN_black.png"));
    wxIcon iconLan(::wxGetApp().strAppPath + _T("pic/LAN.png"));
    wxIcon iconDisconnectBlack(::wxGetApp().strAppPath + _T("pic/disconnect_black.png"));
    wxIcon iconDisconnect(::wxGetApp().strAppPath + _T("pic/disconnect.png"));
    wxIcon iconWirelessBlack(::wxGetApp().strAppPath + _T("pic/wireless_black.png"));
    wxIcon iconWireless(::wxGetApp().strAppPath + _T("pic/wireless.png"));
    if ( IsProtocolSupported() )
    {
         switch ( networkMode )
         {
            case NETWORK_MODE_WIRED_LAN_CONNECT:
            {
                this->SetIcon(iconLanBlack, strTip);
                this->SetIcon(iconLan, strTip);
            }
                break;
            case NETWORK_MODE_WIRED_LAN_DISCONNECT:
            {
                this->SetIcon(iconDisconnectBlack, strTip);
                this->SetIcon(iconDisconnect, strTip);
            }
                break;
            case NETWORK_MODE_WIRELESS_LAN_CONNECT:
            {
                this->SetIcon(iconWirelessBlack, strTip);
                this->SetIcon(iconWireless, strTip);
            }
                break;
            case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
            {
                this->SetIcon(iconDisconnectBlack, strTip);
                this->SetIcon(iconDisconnect, strTip);
            }
                break;
            case NETWORK_MODE_MESH_CONNECT:
            {
                switch(::wxGetApp().m_nMeshStatus)
                {
                    case MESHSTATUS_MESHONLY:
                    {
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/Mesh_black.png")), _("Enhanced Easy Network"));
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/Mesh.png")), _("Enhanced Easy Network"));
                    }
                        break;
                    case MESHSTATUS_MESHCLIENT:
                    {
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/MeshClient_black.png")), _("Enhanced Easy Network"));
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/MeshClient.png")), _("Enhanced Easy Network"));
                    }
                        break;
                    case MESHSTATUS_MESHSERVER:
                    {
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/MeshPortal_black.png")), _("Enhanced Easy Network"));
                        this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/MeshPortal.png")), _("Enhanced Easy Network"));
                    }
                        break;
                    default:
                        break;

                }
            }
                break;

            case NETWORK_MODE_MESH_DISCONNECT:
                {
                    this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/disconnect_black.png")), _("Enhanced Easy Network"));
                    this->SetIcon(wxIcon(::wxGetApp().strAppPath + _T("pic/disconnect.png")), _("Enhanced Easy Network"));
                }
                break;
            case NETWORK_MODE_DISCONNECTED:
            {
                this->SetIcon(iconDisconnectBlack, strTip);
                this->SetIcon(iconDisconnect, strTip);
            }
                break;
            default:
                break;
         }
        if ( ::wxGetApp().m_popBalloon )
        {
            if ( NULL == m_notificationDlg )
            {
                m_notificationDlg = new ENExistBalloon(NULL);
            }
            m_notificationDlg->Show(true);
            if (NULL == m_notificationtimer)
            {
                m_notificationtimer = new wxTimer(this, ID_NOTI_TIMER);
            }
            m_notificationtimer->Start(3000, wxTIMER_ONE_SHOT);
            ::wxGetApp().m_popBalloon = false;
        }
    }
}

void ENMTaskTray::OnWlanAcmEvent(WlanAcmEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnWlanAcmEvent"));
//    wxMessageBox(wxString::Format(_("Connect event: %d\nApplyWirelessFlag: %d"), event.GetEventCode(), GetApplyWirelessFlag()));
    if ( !bApplyFinish )
    {
        ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnWlanAcmEvent !bApplyFinish"));
        if ( event.GetEventCode() == WLAN_ACM_EVENT_CONNECT_SUCCESS )
        {
            //success
            eNMApplyProfileBalloon->CallExit();
            DataCenter::GetInstance()->StartGlobalTimer();
            if ( !m_NotifiArea )
            {
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
            }
            bApplyFinish = true;
            iVector = 0;
            eNMApplyProfileBalloon->Show(false);
            if ( eNMApplyProfileBalloon != NULL )
            {
                delete eNMApplyProfileBalloon;
                eNMApplyProfileBalloon = NULL;
            }

            m_ap = DataCenter::GetInstance()->GetCurrentAPStatus();

            wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();

            if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
            {
                if ( NULL == m_ap )
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        disconBalloon->SetScanHyperLink();
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
                else if ( NULL == balloon )
                {
                    balloon = new TaskBarBalloon(NULL, _T("balloon"));
                    balloon->SetConnectionTip(_("Connection successful!"));
                    balloon->SetConnectionType(_("Wireless LAN"));

                    if ( m_ap->type == WLAN_802_11_B )
                    {
                        balloon->SetConnectionSpeed(_("11.0 Mbps"));
                    }
                    else if ( m_ap->type == WLAN_802_11_G )
                    {
                        balloon->SetConnectionSpeed(_("54.0 Mbps"));
                    }
                    else if ( m_ap->type == WLAN_802_11_N )
                    {
                        balloon->SetConnectionSpeed(_("108.0 Mbps"));
                    }
                    else
                    {
                        balloon->SetConnectionSpeed(_("54.0 Mbps"));
                    }


                    if ( strProfileName.Length() == 0 && m_ap != NULL )
                    {
                        strProfileName = wxString::FromUTF8((const char*)m_ap->ssid.ucSsid, m_ap->ssid.length);
                    }

                    balloon->SetConnectionStatus(strProfileName);

                    if ( 0 == m_ap->signalQuality )
                    {
                        m_ap->signalQuality = 80;
                    }
                    balloon->SetSignalQuality(m_ap->signalQuality);
                    balloon->SetSignalQualityBmp(m_ap->signalQuality);
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    balloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
                }
            }
            else if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIRED) )
            {
                if ( NULL == m_balloonLAN )
                {
                    m_balloonLAN = new TaskBarBalloonLAN(NULL, _T("balloon"));
                    m_balloonLAN->SetConnectionTip(_("Connection successful!"));
                    m_balloonLAN->SetConnectionType(_("Wired LAN"));
                    wxString strLanType = DataCenter::GetInstance()->GetConnectTypeHLAN();
                    wxString strType = _("Wired LAN - ");
                    wxString strSpeed = strLanType.SubString(strType.length(), strLanType.length());
                    m_balloonLAN->SetConnectionSpeed(strSpeed);
                    if ( strProfileName.Length() == 0 )
                    {
                        strProfileName = _("Wired LAN");
                    }
                    m_balloonLAN->SetConnectionStatus(strProfileName);
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    m_balloonLAN->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
                }
            }
            else
            {

            }
        }
        else
        {
            //fail
            iVector++;

            int iSize = m_vProfiles.size();
            while ( (iVector < iSize) && (m_vProfiles[iVector].sShow == _T("0")) )
            {
                iVector++;
            }

            if ( iVector < iSize )
            {
                eNMApplyProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                eNMApplyProfileBalloon->SetTurningOnNetwork(strType);
                eNMApplyProfileBalloon->Show();
                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                eNMApplyProfileBalloon->CallExit();
                DataCenter::GetInstance()->StartGlobalTimer();
                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
                bApplyFinish = true;
                iVector = 0;
                eNMApplyProfileBalloon->Show(false);
                if ( eNMApplyProfileBalloon != NULL )
                {
                    delete eNMApplyProfileBalloon;
                    eNMApplyProfileBalloon = NULL;
                }

                if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        disconBalloon->SetScanHyperLink();
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
                else
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
            }
        }
        ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWlanAcmEvent !bApplyFinish"));
    }

    if ( !GetApplyWirelessFlag() )
    {
        ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnWlanAcmEvent !GetApplyWirelessFlag()"));
        if ( event.GetEventCode() == WLAN_ACM_EVENT_CONNECT_SUCCESS )
        {
            //success
            m_ApplyWirelessProfileBalloon->CallExit();
            DataCenter::GetInstance()->StartGlobalTimer();
            if ( !m_NotifiArea )
            {
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
            }
            SetApplyWirelessFlag(true);
            iVector = 0;
//            DataCenter::GetInstance()->SetAutoWirelessFlag(true);
            m_ApplyWirelessProfileBalloon->Show(false);
            if ( m_ApplyWirelessProfileBalloon != NULL )
            {
                delete m_ApplyWirelessProfileBalloon;
                m_ApplyWirelessProfileBalloon = NULL;
            }

            m_ap = DataCenter::GetInstance()->GetCurrentAPStatus();
            wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
            if ( NULL == m_ap )
            {
                if ( NULL == disconBalloon )
                {
                    disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                    disconBalloon->SetScanHyperLink();
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    disconBalloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                }
            }
            else if ( NULL == balloon )
            {
                balloon = new TaskBarBalloon(NULL, _T("balloon"));
                balloon->SetConnectionTip(_("Connection successful!"));
                balloon->SetConnectionType(_("Wireless LAN"));

                if ( m_ap->type == WLAN_802_11_B )
                {
                    balloon->SetConnectionSpeed(_("11.0 Mbps"));
                }
                else if ( m_ap->type == WLAN_802_11_G )
                {
                    balloon->SetConnectionSpeed(_("54.0 Mbps"));
                }
                else if ( m_ap->type == WLAN_802_11_N )
                {
                    balloon->SetConnectionSpeed(_("108.0 Mbps"));
                }
                else
                {
                    balloon->SetConnectionSpeed(_("54.0 Mbps"));
                }


                if ( strProfileName.Length() == 0 && m_ap != NULL )
                {
                    strProfileName = wxString::FromUTF8((const char*)m_ap->ssid.ucSsid, m_ap->ssid.length);
                }

                balloon->SetConnectionStatus(strProfileName);
                balloon->SetSignalQuality(m_ap->signalQuality);
                if ( 0 == m_ap->signalQuality )
                {
                    m_ap->signalQuality = 80;
                }
                balloon->SetSignalQualityBmp(m_ap->signalQuality);
                timer = new wxTimer(this,ID_TIMER_TICK);
                balloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            }
        }
        else
        {
            //fail
            iVector++;
            int iSize = m_vProfiles.size();
            while ( (iVector < iSize) && !(m_vProfiles[iVector].sShow == _T("1") && m_vProfiles[iVector].stGenernalSet.ConnecType == _T("wireless")) )
            {
                iVector++;
            }
            if ( iVector < iSize )
            {
                m_ApplyWirelessProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                m_ApplyWirelessProfileBalloon->SetTurningOnNetwork(strType);
                m_ApplyWirelessProfileBalloon->Show();
                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                m_ApplyWirelessProfileBalloon->CallExit();
                DataCenter::GetInstance()->StartGlobalTimer();

                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
                SetApplyWirelessFlag(true);

                iVector = 0;

//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);

                m_ApplyWirelessProfileBalloon->Show(false);
                if ( m_ApplyWirelessProfileBalloon != NULL )
                {
                    delete m_ApplyWirelessProfileBalloon;
                    m_ApplyWirelessProfileBalloon = NULL;
                }

                if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        disconBalloon->SetScanHyperLink();
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

                    }
                }
                else
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
            }
        }
        ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWlanAcmEvent !GetApplyWirelessFlag()"));
    }


    if ( !GetApplyWiredFlag() )
    {
        ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnWlanAcmEvent !GetApplyWiredFlag()"));
        if ( event.GetEventCode() == WLAN_ACM_EVENT_CONNECT_SUCCESS )
        {
            //success
            m_ApplyWiredProfileBalloon->CallExit();
            DataCenter::GetInstance()->StartGlobalTimer();
            if ( !m_NotifiArea )
            {
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
            }
            SetApplyWiredFlag(true);
            iVector = 0;
//            DataCenter::GetInstance()->SetAutoWirelessFlag(true);
            m_ApplyWiredProfileBalloon->Show(false);
            if ( m_ApplyWiredProfileBalloon != NULL )
            {
                delete m_ApplyWiredProfileBalloon;
                m_ApplyWiredProfileBalloon = NULL;
            }

            wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();

            if ( NULL == m_balloonLAN )
            {
                m_balloonLAN = new TaskBarBalloonLAN(NULL, _T("balloon"));
                m_balloonLAN->SetConnectionTip(_("Connection successful!"));
                m_balloonLAN->SetConnectionType(_("Wired LAN"));
                wxString strLanType = DataCenter::GetInstance()->GetConnectTypeHLAN();
                wxString strType = _("Wired LAN - ");
                wxString strSpeed = strLanType.SubString(strType.length(), strLanType.length());
                m_balloonLAN->SetConnectionSpeed(strSpeed);
                if ( strProfileName.Length() == 0 )
                {
                    strProfileName = _("Wired LAN");
                }
                m_balloonLAN->SetConnectionStatus(strProfileName);
                timer = new wxTimer(this,ID_TIMER_TICK);
                m_balloonLAN->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            }
        }
        else
        {
            //fail
            iVector++;
            int iSize = m_vProfiles.size();
            while ( (iVector < iSize) && !(m_vProfiles[iVector].sShow == _T("1") && m_vProfiles[iVector].stGenernalSet.ConnecType == _T("lan")) )
            {
                iVector++;
            }
            if ( iVector < iSize )
            {
                m_ApplyWiredProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                m_ApplyWiredProfileBalloon->SetTurningOnNetwork(strType);
                m_ApplyWiredProfileBalloon->Show();
                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                m_ApplyWiredProfileBalloon->CallExit();
                DataCenter::GetInstance()->StartGlobalTimer();

                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
                SetApplyWiredFlag(true);

                iVector = 0;

//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);

                m_ApplyWiredProfileBalloon->Show(false);
                if ( m_ApplyWiredProfileBalloon != NULL )
                {
                    delete m_ApplyWiredProfileBalloon;
                    m_ApplyWiredProfileBalloon = NULL;
                }

                if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        disconBalloon->SetScanHyperLink();
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

                    }
                }
                else
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
            }
        }
//        ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWlanAcmEvent !GetApplyWiredFlag()"));
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWlanAcmEvent"));
}

bool ENMTaskTray::IsProtocolSupported()
{
#if defined(__UNIX__)
    Display *display = GDK_DISPLAY();
    Screen *screen = DefaultScreenOfDisplay(display);

    char name[32];
    g_snprintf(name, sizeof(name), "_NET_SYSTEM_TRAY_S%d", XScreenNumberOfScreen(screen));
    Atom atom = XInternAtom(display, name, False);
    Window manager = XGetSelectionOwner(display, atom);

    return manager != None;
#endif
}

void ENMTaskTray::ApplyWirelessProfile()
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::ApplyWirelessProfile"));
    DataCenter::GetInstance()->GetProfileController()->GetUserProfiles(m_vProfiles, ENMUtil::IsAdministrator());
    if ( m_vProfiles.size() > 0 )
    {
        if (m_ApplyWirelessProfileBalloon == NULL)
        {
            int iSize = m_vProfiles.size();
            ENMUtil::Log(logFile, wxString::Format(_T("\t m_ApplyWirelessProfileBalloon is NULL\n\t Get %d profiles, iVector = %d."), iSize, iVector));
            m_ApplyWirelessProfileBalloon = new ENMApplyProfileBalloon(NULL, _("EN"));
            while ( (iVector < iSize) && !(m_vProfiles[iVector].sShow == _T("1") && m_vProfiles[iVector].stGenernalSet.ConnecType == _T("wireless")) )
            {
                iVector++;
            }
            if ( iVector < iSize )
            {
                m_ApplyWirelessProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                m_ApplyWirelessProfileBalloon->SetTurningOnNetwork(strType);
                m_ApplyWirelessProfileBalloon->Show();

                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                SetApplyWirelessFlag(true);
                DataCenter::GetInstance()->StartGlobalTimer();
                delete m_ApplyWirelessProfileBalloon;
                m_ApplyWirelessProfileBalloon = NULL;
                iVector = 0;
//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);
                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
            }
        }
        else
        {
            ENMUtil::Log(logFile, _T("Enter ENMTaskTray::ApplyWirelessProfile m_ApplyWirelessProfileBalloon not NULL"));
            bApplyWirelessFinish = true;
            DataCenter::GetInstance()->StartGlobalTimer();
            iVector = 0;
//            DataCenter::GetInstance()->SetAutoWirelessFlag(true);

            if ( !m_NotifiArea )
            {
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
            }
        }
    }
    else
    {
        SetApplyWirelessFlag(true);
        iVector = 0;
        DataCenter::GetInstance()->StartGlobalTimer();
//        DataCenter::GetInstance()->SetAutoWirelessFlag(true);
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::ApplyWirelessProfile"));
}

void ENMTaskTray::ApplyWiredProfile()
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::ApplyWiredProfile"));
    DataCenter::GetInstance()->GetProfileController()->GetUserProfiles(m_vProfiles, ENMUtil::IsAdministrator());
    if ( m_vProfiles.size() > 0 )
    {
        if (m_ApplyWiredProfileBalloon == NULL)
        {
            int iSize = m_vProfiles.size();
            m_ApplyWiredProfileBalloon = new ENMApplyProfileBalloon(NULL, _("EN"));
            while ( (iVector < iSize) && !(m_vProfiles[iVector].sShow == _T("1") && m_vProfiles[iVector].stGenernalSet.ConnecType == _T("lan")) )
            {
                iVector++;
            }
            if ( iVector < iSize )
            {
                m_ApplyWiredProfileBalloon->SetApplyProfileName(m_vProfiles[iVector].sProfileName);
                wxString type = m_vProfiles[iVector].stGenernalSet.ConnecType;
                wxString strType = _T("");
                if ( type == _T("wireless") )
                {
                    strType = _("Wireless");
                }
                else
                {
                    strType = _("Wired");
                }
                m_ApplyWiredProfileBalloon->SetTurningOnNetwork(strType);
                m_ApplyWiredProfileBalloon->Show();

                DataCenter::GetInstance()->GetProfileController()->ApplyProfile(m_vProfiles[iVector]);
            }
            else
            {
                SetApplyWiredFlag(true);
                DataCenter::GetInstance()->StartGlobalTimer();
                iVector = 0;
//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);
                if ( !m_NotifiArea )
                {
                    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
                }
            }
        }
        else
        {
            bApplyWiredFinish = true;
            DataCenter::GetInstance()->StartGlobalTimer();

            iVector = 0;
//            DataCenter::GetInstance()->SetAutoWirelessFlag(true);

            if ( !m_NotifiArea )
            {
                DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
            }
        }
    }
    else
    {
        SetApplyWiredFlag(true);
        DataCenter::GetInstance()->StartGlobalTimer();
        iVector = 0;
//        DataCenter::GetInstance()->SetAutoWirelessFlag(true);
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::ApplyWiredProfile"));
}


void ENMTaskTray::SetApplyWirelessFlag(bool bFlag)
{
    bApplyWirelessFinish = bFlag;
}

void ENMTaskTray::SetApplyWiredFlag(bool bFlag)
{
    bApplyWiredFinish = bFlag;
}


bool ENMTaskTray::GetApplyWirelessFlag()
{
    return bApplyWirelessFinish;
}

bool ENMTaskTray::GetApplyWiredFlag()
{
    return bApplyWiredFinish;
}


void ENMTaskTray::StopApplyWirelessDlg()
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::StopApplyWirelessDlg"));
    //success
    m_ApplyWirelessProfileBalloon->CallExit();
    if ( !m_NotifiArea )
    {
        DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
    }
    SetApplyWirelessFlag(true);
    iVector = 0;
//    DataCenter::GetInstance()->SetAutoWirelessFlag(true);
    m_ApplyWirelessProfileBalloon->Show(false);
    delete m_ApplyWirelessProfileBalloon;
    m_ApplyWirelessProfileBalloon = NULL;
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::StopApplyWirelessDlg"));
//    ENMUtil::ShowSwitchWirelessSuccDlg();
}

void ENMTaskTray::OnProfileChangedEvent(ProfileEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnProfileChangedEvent"));
    if ( !bApplyFinish || !GetApplyWirelessFlag() )
    {
        return;
    }
    int id = event.GetId();
    unsigned long code = event.GetEventCode();
    if ( (unsigned int)id == ID_PROFILE_APPLY )
    {
    //    if ( code != PEVT_PROFILE_APPLY_DISCONNECT )
    //    {
    //        m_btnCtrlConnect->Enable(true);
    //    }
        switch ( code )
        {
        case PEVT_PROFILE_APPLY_SUCCESS:
        {
            m_ap = DataCenter::GetInstance()->GetCurrentAPStatus();
            ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
            wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
            if ( profile.stGenernalSet.ConnecType == _T("wireless") )
            {
                ENMUtil::Log(logFile, _T("\t profile.stGenernalSet.ConnecType == wireless"));
                if ( NULL == m_ap )
                {
                    if ( NULL == disconBalloon )
                    {
                        disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                        disconBalloon->SetScanHyperLink();
                        timer = new wxTimer(this,ID_TIMER_TICK);
                        disconBalloon->Show();
                        timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                    }
                }
                else if ( NULL == balloon )
                {
                    balloon = new TaskBarBalloon(NULL, _T("balloon"));
                    balloon->SetConnectionTip(_("Connection successful!"));
                    balloon->SetConnectionType(_("Wireless LAN"));

                    if ( m_ap->type == WLAN_802_11_B )
                    {
                        balloon->SetConnectionSpeed(_("11.0 Mbps"));
                    }
                    else if ( m_ap->type == WLAN_802_11_G )
                    {
                        balloon->SetConnectionSpeed(_("54.0 Mbps"));
                    }
                    else if ( m_ap->type == WLAN_802_11_N )
                    {
                        balloon->SetConnectionSpeed(_("108.0 Mbps"));
                    }
                    else
                    {
                        balloon->SetConnectionSpeed(_("54.0 Mbps"));
                    }


                    if ( strProfileName.Length() == 0 && m_ap != NULL )
                    {
                        strProfileName = wxString::FromUTF8((const char*)m_ap->ssid.ucSsid, m_ap->ssid.length);
                    }

                    if ( 0 == m_ap->signalQuality )
                    {
                        m_ap->signalQuality = 80;
                    }
                    balloon->SetConnectionStatus(strProfileName);
                    balloon->SetSignalQuality(m_ap->signalQuality);
                    balloon->SetSignalQualityBmp(m_ap->signalQuality);
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    balloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
                }
                ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnProfileChangedEvent profile.stGenernalSet.ConnecType == wireless"));
            }
            else
            {
                if ( NULL == m_balloonLAN )
                {
                    m_balloonLAN = new TaskBarBalloonLAN(NULL, _T("balloon"));
                    m_balloonLAN->SetConnectionTip(_("Connection successful!"));
                    m_balloonLAN->SetConnectionType(_("Wired LAN"));
                    wxString strLanType = DataCenter::GetInstance()->GetConnectTypeHLAN();
                    wxString strType = _("Wired LAN - ");
                    wxString strSpeed = strLanType.SubString(strType.length(), strLanType.length());
                    m_balloonLAN->SetConnectionSpeed(strSpeed);
                    if ( strProfileName.Length() == 0 )
                    {
                        strProfileName = _("Wired LAN");
                    }
                    m_balloonLAN->SetConnectionStatus(strProfileName);
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    m_balloonLAN->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
                }

            }
        }
            break;
        case PEVT_PROFILE_APPLY_FAILED:
        {
            ProfileList_t profile = DataCenter::GetInstance()->GetProfileController()->GetCurrentUsedProfile();
            if ( profile.stGenernalSet.ConnecType == _T("wireless") && DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
            {
                if ( NULL == disconBalloon )
                {
                    disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                    disconBalloon->SetScanHyperLink();
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    disconBalloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

                }
            }
            else
            {
                if ( NULL == disconBalloon )
                {
                    disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                    timer = new wxTimer(this,ID_TIMER_TICK);
                    disconBalloon->Show();
                    timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                }
            }
        }
            break;
        case PEVT_PROFILE_APPLY_REAPPLY:
        {

        }
            break;
        default:
            break;
        }
    }
    else if ( (unsigned int)id == ID_PROFILE_CHANGED )
    {
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnProfileChangedEvent"));
}


void ENMTaskTray::OnWirelessSwitchEvent(const WirelessSwitchEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnWirelessSwitchEvent"));
    if ( !bApplyFinish || !GetApplyWirelessFlag() )
    {
        ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWirelessSwitchEvent cannot fulfil the condition"));
        return;
    }

    ENMUtil::Log(logFile, wxString::Format(_T("\t Get wireless switch event: %d"), &event));
    WlanSsid oldSsid = event.GetOldSsid();
    WlanSsid newSsid = event.GetNewSsid();
    if ( newSsid.length == 0 )
    {
        ENMUtil::Log(logFile, _T("\t Disconnect from ") + wxString::FromUTF8((char*)oldSsid.ucSsid, oldSsid.length));
        if ( NULL == disconBalloon )
        {
            disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
            disconBalloon->SetScanHyperLink();
            timer = new wxTimer(this,ID_TIMER_TICK);
            disconBalloon->Show();
            timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
        }
    }
    else
    {
        m_ap = DataCenter::GetInstance()->GetCurrentAPStatus();
        ENMUtil::Log(logFile, wxString::Format(_T("\t call DataCenter::GetCurrentAPStatus() : %08X"), m_ap));
        wxString strProfileName = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
        ENMUtil::Log(logFile, _T("\t call ProfileManagementControl::GetCurrentProfile() : ") + strProfileName);
        if ( NULL == m_ap )
        {
            if ( NULL == disconBalloon )
            {
                ENMUtil::Log(logFile, _T("\t Create disconnect balloon"));
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                disconBalloon->SetScanHyperLink();
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
                ENMUtil::Log(logFile, _T("\t Show disconnect balloon OK"));
            }
        }
        else if ( NULL == balloon )
        {
            ENMUtil::Log(logFile, _T("\t Create taskbar balloon"));
            balloon = new TaskBarBalloon(NULL, _T("balloon"));
            ENMUtil::Log(logFile, _T("\t Set balloon text"));
            balloon->SetConnectionTip(_("Connection successful!"));
            balloon->SetConnectionType(_("Wireless LAN"));

            ENMUtil::Log(logFile, _T("\t Set connect speed"));
            if ( m_ap->type == WLAN_802_11_B )
            {
                balloon->SetConnectionSpeed(_("11.0 Mbps"));
            }
            else if ( m_ap->type == WLAN_802_11_G )
            {
                balloon->SetConnectionSpeed(_("54.0 Mbps"));
            }
            else if ( m_ap->type == WLAN_802_11_N )
            {
                balloon->SetConnectionSpeed(_("108.0 Mbps"));
            }
            else
            {
                balloon->SetConnectionSpeed(_("54.0 Mbps"));
            }

            if ( strProfileName.Length() == 0 && m_ap != NULL )
            {
                strProfileName = wxString::FromUTF8((const char*)m_ap->ssid.ucSsid, m_ap->ssid.length);
            }
            ENMUtil::Log(logFile, _T("\t Set profile name \"") + strProfileName + _T("\" OK"));

            balloon->SetConnectionStatus(strProfileName);
            if ( 0 == m_ap->signalQuality )
            {
                m_ap->signalQuality = 80;
            }
            balloon->SetSignalQuality(m_ap->signalQuality);
            balloon->SetSignalQualityBmp(m_ap->signalQuality);
            timer = new wxTimer(this,ID_TIMER_TICK);
            balloon->Show();
            timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS );
            ENMUtil::Log(logFile, _T("\t Show taskbar balloon OK"));
        }
    }
    ENMUtil::Log(logFile, _T("Leave ENMTaskTray::OnWirelessSwitchEvent"));
}

void ENMTaskTray::SetWaitingForSwitch(bool wait)
{
    m_isWaitingForSwitch = wait;
}

void ENMTaskTray::OnAdapterSwitched(SwitchAdapterEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter ENMTaskTray::OnAdapterSwitched"));
    if ( m_isWaitingForSwitch && event.GetDisabledAdapterType() == ADAPTER_WIREDLESS && event.GetEnabledAdapterType() == ADAPTER_WIRED )
    {
        m_isWaitingForSwitch = false;
        ENMUtil::Log(logFile, _T("\t Switch successfully, show balloon"));
        ENMUtil::ShowWirelessOnOffDlg(false);
    }
    ENMUtil::Log(logFile, _T("Return ENMTaskTray::OnAdapterSwitched\n"));
}

void ENMTaskTray::StopApplyConnecting()
{
    DataCenter::GetInstance()->GetProfileController()->StopApplying();
    if ( eNMApplyProfileBalloon != NULL )
    {
        eNMApplyProfileBalloon->CallExit();
        DataCenter::GetInstance()->StartGlobalTimer();
        iVector = 0;
    }

    if ( !bApplyFinish )
    {
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
        bApplyFinish = true;
        eNMApplyProfileBalloon->Show(false);

        if ( eNMApplyProfileBalloon != NULL )
        {
            delete eNMApplyProfileBalloon;
            eNMApplyProfileBalloon = NULL;
        }

        if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                disconBalloon->SetScanHyperLink();
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
        else
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
    }

    if ( m_ApplyWirelessProfileBalloon != NULL )
    {
        m_ApplyWirelessProfileBalloon->CallExit();
        DataCenter::GetInstance()->StartGlobalTimer();
        iVector = 0;
    }


    if ( !GetApplyWirelessFlag() )
    {
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
        SetApplyWirelessFlag(true);

//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);

        m_ApplyWirelessProfileBalloon->Show(false);
        if ( m_ApplyWirelessProfileBalloon != NULL )
        {
            delete m_ApplyWirelessProfileBalloon;
            m_ApplyWirelessProfileBalloon = NULL;
        }

        if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                disconBalloon->SetScanHyperLink();
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

            }
        }
        else
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }
    }

    if ( m_ApplyWiredProfileBalloon != NULL )
    {
        m_ApplyWiredProfileBalloon->CallExit();
        DataCenter::GetInstance()->StartGlobalTimer();
        iVector = 0;
    }

    if ( !GetApplyWiredFlag() )
    {
        if ( !m_NotifiArea )
        {
            DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->Show(true);
        }
        SetApplyWiredFlag(true);



//                DataCenter::GetInstance()->SetAutoWirelessFlag(true);

        m_ApplyWiredProfileBalloon->Show(false);
        if ( m_ApplyWiredProfileBalloon != NULL )
        {
            delete m_ApplyWiredProfileBalloon;
            m_ApplyWiredProfileBalloon = NULL;
        }

        if ( DataCenter::GetInstance()->IsInterfaceEnabled(ADAPTER_WIREDLESS) )
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                disconBalloon->SetScanHyperLink();
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);

            }
        }
        else
        {
            if ( NULL == disconBalloon )
            {
                disconBalloon = new DisConnectBalloon(NULL, _T("balloon"));
                timer = new wxTimer(this,ID_TIMER_TICK);
                disconBalloon->Show();
                timer->Start(BALLOON_TIME, wxTIMER_CONTINUOUS);
            }
        }

    }

}

/**************************************************************************************************
* Function Name :  CloseNotification                                                                    *
* Description  :                                                                       *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void ENMTaskTray::CloseNotification(wxTimerEvent & event)
{
   if (NULL != m_notificationDlg)
    {
        m_notificationDlg->Show(false);
        delete m_notificationDlg;
        m_notificationDlg = NULL;
    }

    if (NULL != m_notificationtimer)
    {

        m_notificationtimer->Stop();
        delete m_notificationtimer;
        m_notificationtimer = NULL;
    }
}
void ENMTaskTray::HideShownBalloon()
{
    if ( balloon )
    {
        balloon->Show(false);
    }
    if ( disconBalloon )
    {
        disconBalloon->Show(false);
    }
    if ( m_balloonLAN != NULL )
    {
        m_balloonLAN->Show(false);
    }
}
