/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_TASKTRAY_H_
#define _ENM_TASKTRAY_H_

#include <wx/utils.h>
#include <wx/bitmap.h>
#include <wx/event.h>
#include <wx/timer.h>
#include "wx/taskbar.h"
#include "ENMApplyProfileBalloon.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "TaskBarBalloon.h"
#include "TaskBarBalloonLAN.h"
#include "TaskBarBalloonMesh.h"
#include "DisConnectBalloon.h"
#include "WlanScanner.h"
#include "ProfileEditor.h"
#include "WirelessEvent.h"
#include <vector>
#include "ENExistBalloon.h"

class ENMTaskTray: public wxTaskBarIcon
{
public:
    static ENMTaskTray* GetInstance();
    void init(bool AutoRun);
    void SetTaskbarIcon(int iconID);
    void SetTaskbarIcon(const NETWORK_MODE& networkMode, const UI_NETWORK_STATUS_INFO& statusInfo);
    void ApplyWirelessProfile();
    void SetApplyWirelessFlag(bool bFlag);
    static bool IsProtocolSupported();
    bool GetApplyWirelessFlag();
    void StopApplyWirelessDlg();
    void SetWaitingForSwitch(bool wait);
    void ApplyWiredProfile();
    void SetApplyWiredFlag(bool bFlag);
    bool GetApplyWiredFlag();
    void StopApplyConnecting();
    virtual ~ENMTaskTray();
    ENExistBalloon* m_notificationDlg;
    wxTimer* m_notificationtimer;
    void HideShownBalloon();

protected:
    static const long ID_TIMER_ENMTASKTRAY;
    static const long ID_TIMER_CLICK;
    static const long ID_TIMER_TICK;
    static const int ID_NOTI_TIMER;

private:
    ENMTaskTray();

    void OnMouseOver(wxTaskBarIconEvent&);
    void OnLeftButtonUp(wxTaskBarIconEvent&);
    void OnRightButtonUp(wxTaskBarIconEvent&);
    wxMenu *CreatePopupMenu();
    void OnTimerTick(wxTimerEvent & event);
    void OnWlanAcmEvent(WlanAcmEvent& event);
    void ClickTimeEvent(wxTimerEvent & event);
    void OnProfileChangedEvent(ProfileEvent& event);
    void OnWirelessSwitchEvent(const WirelessSwitchEvent& event);
    void OnAdapterSwitched(SwitchAdapterEvent& event);
    void CloseNotification(wxTimerEvent & event);

    void ShowMenu();

    static ENMTaskTray* instance;

    TaskBarBalloon* balloon;
    TaskBarBalloonLAN* m_balloonLAN;
    TaskBarBalloonMesh* m_balloonMesh;
    DisConnectBalloon* disconBalloon;
    ENMApplyProfileBalloon* eNMApplyProfileBalloon;
    ENMApplyProfileBalloon* m_ApplyWirelessProfileBalloon;
    ENMApplyProfileBalloon* m_ApplyWiredProfileBalloon;
    wxTimer * timer;
    wxTimer m_clickTimer;
    bool m_bDoubleClick;

    vector<ProfileList_t> m_vProfiles;
    int iVector;
    APStatus* m_ap;
    NETWORK_INFO* m_netInfo;
    bool bApplyFinish;
    wxPoint m_MousePos;
    bool m_NotifiArea;
    bool bApplyWirelessFinish;
    bool bApplyWiredFinish;
    bool m_isWaitingForSwitch;

    DECLARE_EVENT_TABLE()

};

#endif // _ENM_TASKTRAY_H_
