/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _KEY_DIALOG_H
#define _KEY_DIALOG_H

#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
class KeyDialog: public wxDialog
{
public:

    KeyDialog(wxWindow* parent, bool ifEnableKeyIdx);
    virtual ~KeyDialog();

    wxString GetKey() const;
    int GetIdx() const;

protected:
    wxStaticText* m_pStxLabel1;
    wxStaticText* m_pStxLabel2;
    wxStaticText* m_pStxLabel3;
    wxStaticText* m_pStxLabel4;
    wxComboBox* m_cbbIndex;
    wxButton* m_btnOK;
    wxTextCtrl* m_txtKey;
    wxTextCtrl* m_txtConfirmKey;
    wxButton* m_btnCancel;

private:
    static const int ID_BTN_OK;
    static const int ID_BTN_CANCEL;

    wxString m_strKey;
    bool m_ifWEP;

    void OnInit(wxInitDialogEvent& event);
    void OnButtonClick(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif  // _KEY_DIALOG_H
