/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "MeshShareMyInternetDlg.h"
#include "ENMApp.h"
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include "MeshInfoManager.h"
#include "ENMUtil.h"
#include "ScanNetworkDlg.h"
#include "DataCenter.h"
#include "DataCenterLinux.h"

const long MeshShareMyInternetDlg::ID_LISTCTRL = wxNewId();
const long MeshShareMyInternetDlg::ID_STATICTEXT1 = wxNewId();
const long MeshShareMyInternetDlg::ID_BUTTON_REFRESH = wxNewId();
const long MeshShareMyInternetDlg::ID_BUTTON_OK = wxNewId();
const long MeshShareMyInternetDlg::ID_BUTTON_CANCEL = wxNewId();
const long MeshShareMyInternetDlg::ID_STATICBITMAP1 = wxNewId();
const long MeshShareMyInternetDlg::ID_PANEL1 = wxNewId();

const int MeshShareMyInternetDlg::ID_TIMER_REGISTERSERVER = ::wxNewId();

wxCriticalSection MeshShareMyInternetDlg::m_CriticalShareMy;

BEGIN_EVENT_TABLE(MeshShareMyInternetDlg,wxDialog)
	//(*EventTable(MeshShareMyInternetDlg)
	//*)
	EVT_CLOSE(MeshShareMyInternetDlg::OnCloseClicked)
END_EVENT_TABLE()

MeshShareMyInternetDlg::MeshShareMyInternetDlg(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
    wxString strImagePath = ::wxGetApp().strAppPath + _T("pic/MeshPortal48.png");
	//(*Initialize(MeshShareMyInternetDlg)
	Create(parent, wxID_ANY, _("Mesh Server Mode"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(450,330));
	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(450,330), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	m_list = new wxListCtrl(Panel1, ID_LISTCTRL, wxPoint(15,64), wxSize(420,208), wxLC_REPORT, wxDefaultValidator, _T("ID_LISTCTRL"));
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("Select one Internet Sharing interface to share or click \"Refresh\" to re-scan Internet Sharing interface."), wxPoint(70,10), wxSize(376,40), 0, _T("ID_STATICTEXT1"));
	ButtonRefresh = new wxButton(Panel1, ID_BUTTON_REFRESH, _("Refresh"), wxPoint(15,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_REFRESH"));
	ButtonOK = new wxButton(Panel1, ID_BUTTON_OK, _("OK"), wxPoint(256,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
	ButtonCancel = new wxButton(Panel1, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(352,285), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
	StaticBitmap1 = new wxStaticBitmap(Panel1, ID_STATICBITMAP1, wxBitmap(wxImage(strImagePath)), wxPoint(15,10), wxDefaultSize, 0, _T("ID_STATICBITMAP1"));

	Connect(ID_BUTTON_REFRESH,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshShareMyInternetDlg::OnButtonRefreshClick);
	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshShareMyInternetDlg::OnButtonOKClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&MeshShareMyInternetDlg::OnButtonCancelClick);
	//*)
	wxListItem itemCol;
    itemCol.SetText(_("Internet Sharing Interface"));
    m_list->InsertColumn(0, itemCol);
    m_list->SetColumnWidth(0, 200);

    itemCol.SetText(_("IP Address"));
    m_list->InsertColumn(1, itemCol);
    m_list->SetColumnWidth(1, 150);

    itemCol.SetText(_("Status"));
    m_list->InsertColumn(2, itemCol);
    m_list->SetColumnWidth(2, 80);

    itemCol.SetAlign(wxLIST_FORMAT_CENTRE);

    wxIcon icon;
    wxBitmap bitmap(wxImage(::wxGetApp().strAppPath + _T("pic/MeshPortal48.png")));
    icon.CopyFromBitmap(bitmap);
    SetIcon(icon);

    Center();

}

MeshShareMyInternetDlg::~MeshShareMyInternetDlg()
{
	//(*Destroy(MeshShareMyInternetDlg)
	//*)
}
void MeshShareMyInternetDlg::OnCloseClicked(wxCloseEvent& event)
{
    m_ReturnValue = wxID_CANCEL;
    Show(false);
}

void MeshShareMyInternetDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
    DrawList();
}

void MeshShareMyInternetDlg::OnButtonOKClick(wxCommandEvent& event)
{
    if ( !MeshInfoManager::GetInstance()->MeshHaveOpen() )
    {
        wxMessageBox(_("There is no mesh interface, please try again"));
        Show(false);
        return;
    }

	if (m_list->GetItemCount() <= 0)
	{
		wxMessageDialog meshdlg(this, _("There is no interface to be shared."),
			_("Mesh Share My Internet"), wxOK);
		meshdlg.ShowModal();
		Show(false);
		return;
	}

	long itemId = -1;
	itemId = m_list->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if ( itemId >= 0 )
	{
		wxMessageDialog dlg(this, _("Are you sure to make the local machine as Mesh Server?"),
			_("Mesh Share My Internet"), wxYES_NO | wxNO_DEFAULT |wxICON_EXCLAMATION);
		if(wxID_YES == dlg.ShowModal())
		{
			wxListItem item;
			item.SetId(itemId);
			item.SetColumn(0);
			m_list->GetItem(item);
			wxString ifname = item.GetText();
			if ( ifname.Left(2).Cmp(wxT("ra")) == 0 )
			{
			    // ifconfig eth down
                DCS_SetMeshChannelOFFSET(1);
				::wxGetApp().m_bMeshServer_Ra0 = true;
				ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
				if ( NULL == scanNetworkDlg )
				{
					return;
				}
				scanNetworkDlg->SetDialogMode(true);
				scanNetworkDlg->Iconize(false);
				scanNetworkDlg->Show();
				scanNetworkDlg->Raise();
			}
			else
			{
			    // ifconfig ra down
                DCS_SetMeshChannelOFFSET(2);
				::wxGetApp().m_bMeshServer_Ra0 = false;
			}
			//change mesh hostname

            MeshInfoManager::GetInstance()->SetHostNameToServer();

			//register as mesh server
			ENM_String exif;
			strcpy((char *)(exif.dcsString), (ENMUtil::WxStringToString(ifname)).c_str());
			DCS_EnableMeshServer(&exif);

			//register as mesh server
			::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHSERVER;

			m_ReturnValue = wxID_OK;
			Show(false);
		}
		else
		{
			m_ReturnValue = wxID_CANCEL;
			Show(false);
		}
	}
	else
	{
		wxMessageDialog meshdlg(this, _("Please choose an interface to share the internet."),
			_("Mesh Share My Internet"), wxOK);
		meshdlg.ShowModal();
	}
}

void MeshShareMyInternetDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    SetReturnCode(wxID_CANCEL);
    m_ReturnValue = wxID_CANCEL;
    Show(false);
}

void MeshShareMyInternetDlg::DrawList()
{
    printf("[MeshShareMyInternet]enter DrawList\n");
    m_CriticalShareMy.Enter();
    m_list->DeleteAllItems();
    wxListItem newItem;
    printf("[MeshShareMyInternet]DeleteAllItems\n");

    m_InternetStateList.clear();
    MeshInfoManager::GetInstance()->GetInternetStateList(m_InternetStateList);

    printf("[MeshShareMyInternet]GetMeshServerInfoList();\n");
    for (int i = 0; i< (int)m_InternetStateList.size(); i++)
    {
        newItem.SetId(i);

        newItem.SetColumn(0);
        wxString iInterface = m_InternetStateList[i].GetInterface();
        newItem.SetText(iInterface);
        m_list->InsertItem(newItem);

        newItem.SetColumn(1);
        newItem.SetText(m_InternetStateList[i].GetIPAddress());
        m_list->SetItem(newItem);

        newItem.SetColumn(2);
        newItem.SetText(m_InternetStateList[i].GetState());
        m_list->SetItem(newItem);
    }

    if (m_list->GetItemCount() > 0)
    {
        m_list->SetItemState(0, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
    }
    m_CriticalShareMy.Leave();
    printf("[MeshShareMyInternet]leave DrawList\n");
}

bool MeshShareMyInternetDlg::Show(bool ifShow)
{
    if ( ifShow )
    {
        DrawList();
    }
    return wxDialog::Show(ifShow);
}


