/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "PolicyManager.h"
#include <wx/xml/xml.h>

#if defined(__UNIX__)
const wxString PolicyManager::strPolicyFile(_T("/etc/Network Neighborhood/NetworkPolicy.xml"));
#endif

BEGIN_EVENT_TABLE(PolicyManager, wxEvtHandler)
END_EVENT_TABLE()

PolicyManager::PolicyManager()
{
    m_bIsAllowOwnerProfile = true;
    m_bIsAllowTurnOnWireless = true;
    m_bIsMeshEnable = true;
    m_bIsScanEnable = true;
}

PolicyManager::~PolicyManager()
{
}

bool PolicyManager::IsMeshEnable() const
{
    return m_bIsMeshEnable;
}

bool PolicyManager::IsScanEnable() const
{
    return m_bIsScanEnable;
}

bool PolicyManager::IsAllowOwnerProfile() const
{
    return m_bIsAllowOwnerProfile;
}

bool PolicyManager::IsAllowTurnOnWireless() const
{
    return m_bIsAllowTurnOnWireless;
}

bool PolicyManager::ReloadPolicy()
{
    bool enableMesh = false;
    bool enableScan = false;
    bool allowProfile = false;
    bool allowWireless = false;

    if ( !wxFileExists(strPolicyFile) )
        return false;

    //load xml file
	wxXmlDocument doc;
	if ( !doc.Load(strPolicyFile) )
		return false;

    //get root element
	wxXmlNode* pRoot = doc.GetRoot();
    if ( pRoot == NULL )
        return false;

	wxXmlNode* pChild = pRoot->GetChildren();
	wxString value;
	while ( pChild != NULL )
	{
		value.Clear();
		if ( pChild->GetName() == _T("EnableMeshNetwork") )
		{
			enableMesh = pChild->GetPropVal(_T("value"), &value) ? (value == _T("1")) : false;
		}
		else if ( pChild->GetName() == _T("EnableNetworkScan") )
		{
			enableScan = pChild->GetPropVal(_T("value"), &value) ? (value == _T("1")) : false;
		}
		else if ( pChild->GetName() == _T("AllowOwnerProfile") )
		{
			allowProfile = pChild->GetPropVal(_T("value"), &value) ? (value == _T("1")) : false;
		}
		else if ( pChild->GetName() == _T("AllowTurnOnWireless") )
		{
			allowWireless = pChild->GetPropVal(_T("value"), &value) ? (value == _T("1")) : false;
		}
		pChild = pChild->GetNext();
	}

    // update current policy
    m_bIsMeshEnable = enableMesh;
    m_bIsScanEnable = enableScan;
    m_bIsAllowOwnerProfile = allowProfile;
    m_bIsAllowTurnOnWireless = allowWireless;

    return true;
}
