/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _POLICY_MANAGER_H
#define _POLICY_MANAGER_H

#include <wx/event.h>

class PolicyManager : public wxEvtHandler
{
public:
    bool ReloadPolicy();

    bool IsMeshEnable() const;
    bool IsScanEnable() const;
    bool IsAllowOwnerProfile() const;
    bool IsAllowTurnOnWireless() const;

protected:
    PolicyManager();
    virtual ~PolicyManager();
    static const wxString strPolicyFile;

private:
    bool m_bIsMeshEnable;
    bool m_bIsScanEnable;
    bool m_bIsAllowOwnerProfile;
    bool m_bIsAllowTurnOnWireless;

    friend class DataCenter;

    DECLARE_EVENT_TABLE()
};

#endif // _POLICY_MANAGER_H
