/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ProfileWirelessSettings.h"
#include "ENMApp.h"
#include "PolicyManager.h"

const long ProfileWirelessSettings::ID_WNNAMETEXTCTRL = wxNewId();
const long ProfileWirelessSettings::ID_SNBUTTON = wxNewId();
const long ProfileWirelessSettings::ID_STCOMBOBOX = wxNewId();
const long ProfileWirelessSettings::ID_WTCOMBOBOX = wxNewId();
const long ProfileWirelessSettings::ID_KEYTEXTCTRL = wxNewId();
const long ProfileWirelessSettings::ID_CONFIRM_KEYTEXTCTRL = wxNewId();

BEGIN_EVENT_TABLE(ProfileWirelessSettings, wxWizardPageSimple)
	EVT_COMBOBOX(ID_STCOMBOBOX, ProfileWirelessSettings::OnSecurityTypeSelected)
	EVT_BUTTON(ID_SNBUTTON, ProfileWirelessSettings::OnButtonScanClicked)
	EVT_TEXT(ID_WNNAMETEXTCTRL, ProfileWirelessSettings::OnWirelessNetworkNameChanged)
END_EVENT_TABLE()

ProfileWirelessSettings::ProfileWirelessSettings(wxWizard* wizard)
        : wxWizardPageSimple(wizard)
{
    int width = 530, height = 290;
    int hm = 10, vm = 6;
    SetSize(width, height);
    wxBitmap bmpTitle(::wxGetApp().strImagePath + _T("step1.png"), wxBITMAP_TYPE_PNG);
	m_sbPic2 = new wxStaticBitmap(this, wxID_ANY, bmpTitle, wxPoint(0,0), wxDefaultSize);
	m_lineSt2 = new wxStaticLine(this, wxID_ANY, wxPoint(0, bmpTitle.GetHeight()), wxSize(width, 1), wxLI_HORIZONTAL);

	m_textWs = new CustomStaticText(this, wxID_ANY, _("Wireless Settings"), wxPoint(5, 5));
	wxFont m_textWsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textWs->SetFont(m_textWsFont);
	m_textDes2 = new CustomStaticText(this, wxID_ANY, _("Input wireless network settings"), wxPoint(hm, 30), wxSize(width - hm * 2, 18));

    int x = hm;
    int y = bmpTitle.GetHeight() + hm;
    int h = 26;
    wxSize labelSize(210, 20);
	m_textPn = new wxStaticText(this, wxID_ANY, _("Wireless Network Name (SSID):"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + hm;
	m_tcWNName = new wxTextCtrl(this, ID_WNNAMETEXTCTRL, wxEmptyString, wxPoint(x, y),  wxSize(width - x - hm * 2 + 22, h));
	m_tcWNName->SetMaxLength(32);

	y += vm + h;
	m_buttonSn = new wxButton(this, ID_SNBUTTON, _("Scan for Networks"), wxPoint(322, y), wxSize(210, 28));

	x = hm;
	y += vm + 28;
	m_textWirelessType = new wxStaticText(this, wxID_ANY, _("Wireless Type:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + hm;
	m_cbbWt = new wxComboBox(this, ID_WTCOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(140, h), 0, 0, wxCB_READONLY);
	m_cbbWt->Append(_("Automatic"));
	m_cbbWt->Append(_T("802.11b"));
	m_cbbWt->Append(_T("802.11g"));
	m_cbbWt->Append(_T("802.11n"));
	m_cbbWt->SetSelection(0);

    x = hm;
    y += vm + h;
	m_textSt = new wxStaticText(this, wxID_ANY, _("Security Type:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + hm;
	m_cbbSt = new wxComboBox(this, ID_STCOMBOBOX, wxEmptyString, wxPoint(x, y), wxSize(140, h), 0, 0, wxCB_READONLY);
	m_cbbSt->Append(_("NONE"));
	m_cbbSt->Append(_T("WEP"));
	m_cbbSt->Append(_T("WPA-PSK TKIP"));
	m_cbbSt->Append(_T("WPA-PSK AES"));
	m_cbbSt->Append(_T("WPA2-PSK TKIP"));
	m_cbbSt->Append(_T("WPA2-PSK AES"));
	m_cbbSt->Append(_("UNKNOWN"));
    m_cbbSt->SetSelection(0);

    x = hm;
    y += vm + h;
    m_textKey = new wxStaticText(this, wxID_ANY, _("Key:"), wxPoint(x, y + 3), labelSize);
    x += labelSize.GetWidth() + hm;
    m_tcKey = new wxTextCtrl(this, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - hm * 2 + 22, h), wxTE_PASSWORD);
    m_tcKey->Enable(false);

    x = hm;
    y += vm + h;
    m_textKeyIdx = new wxStaticText(this, wxID_ANY, _("Confirm Key:"), wxPoint(x, y + 3), labelSize);
    x += labelSize.GetWidth() + hm;
    m_tcConfirmKey = new wxTextCtrl(this, ID_KEYTEXTCTRL, wxEmptyString, wxPoint(x, y), wxSize(width - x - hm * 2 + 22, h), wxTE_PASSWORD);
    m_tcConfirmKey->Enable(false);
    m_tcKey->SetMaxLength(63);
    m_tcConfirmKey->SetMaxLength(63);

    x = hm;
    y += vm + h;
    m_textKeyIdx = new wxStaticText(this, wxID_ANY, _("Key Index:"), wxPoint(x, y + 3), labelSize);
    x += labelSize.GetWidth() + hm;
	m_cbbIndex = new wxComboBox(this, wxID_ANY, wxEmptyString, wxPoint(x, y), wxSize(60, h), 0, 0, wxCB_READONLY);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
	m_cbbIndex->Enable(false);

    y += vm + h;
    m_textTip = new wxStaticText(this, wxID_ANY, wxEmptyString, wxPoint(x, y), wxSize(width - x - hm * 2, 30));
	m_bNameChange = false;

	InitButtonStatus();
}

ProfileWirelessSettings::~ProfileWirelessSettings()
{
}

void ProfileWirelessSettings::InitButtonStatus()
{
    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    m_buttonSn->Enable( networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT );
    if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
    {
        if(::wxGetApp().m_bMeshServer_Ra0)
        {
            m_buttonSn->Enable(true);
        }
    }
}

void ProfileWirelessSettings::OnSecurityTypeSelected(wxCommandEvent& event)
{
    wxString currentText = m_cbbSt->GetValue();
    UpdateSecurityUI(currentText);
}

void ProfileWirelessSettings::OnButtonScanClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(this, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }
    bool bFind =(DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_CONNECT) && (DataCenter::GetInstance()->GetCurrentNetworkMode() != NETWORK_MODE_WIRELESS_LAN_DISCONNECT);

    if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
    {
        if(::wxGetApp().m_bMeshServer_Ra0)
        {
            bFind =  false;
        }
    }
    if ( bFind )
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), wxEmptyString, wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        return;
    }

    ScanNetworkDlg* pScanNetworkDialog = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( pScanNetworkDialog->IsShown() )
        pScanNetworkDialog->CloseDialog(wxID_CANCEL);
    pScanNetworkDialog->SetDialogMode(false);
    APStatus ap;
    memset(&ap, 0, sizeof(APStatus));
    if ( pScanNetworkDialog->ShowModal() == wxID_OK && pScanNetworkDialog->GetSelectedNetwork(&ap) )
    {
        SetApStatus(ap);
        wxString currentText = m_cbbSt->GetValue();
        UpdateSecurityUI(currentText);
    }
}

void ProfileWirelessSettings::SetApStatus(const APStatus& ap)
{
    m_tcWNName->SetValue(wxString::FromUTF8((const char*)ap.ssid.ucSsid, ap.ssid.length));
    switch ( ap.auth )
    {
	case WLAN_AUTH_OPEN_NONE:
		m_cbbSt->SetSelection(0);
		break;
	case WLAN_AUTH_OPEN_WEP:
		m_cbbSt->SetSelection(1);
		break;
	case WLAN_AUTH_WPAPSK_TKIP:
		m_cbbSt->SetSelection(2);
		break;
	case WLAN_AUTH_WPAPSK_AES:
		m_cbbSt->SetSelection(3);
		break;
	case WLAN_AUTH_WPA2PSK_TKIP:
		m_cbbSt->SetSelection(4);
		break;
	case WLAN_AUTH_WPA2PSK_AES:
		m_cbbSt->SetSelection(5);
		break;
	default:
		m_cbbSt->SetSelection(6);
		break;
    }

	switch ( ap.type )
	{
	case WLAN_802_11_B:
        m_cbbWt->SetSelection(1);
//		m_cbbWt->SetValue(_T("802.11b"));
		break;
	case WLAN_802_11_G:
        m_cbbWt->SetSelection(2);
//		m_cbbWt->SetValue(_T("802.11g"));
		break;
	case WLAN_802_11_N:
        m_cbbWt->SetSelection(3);
//		m_cbbWt->SetValue(_T("802.11n"));
		break;
	default:
        m_cbbWt->SetSelection(0);
//		m_cbbWt->SetValue(_("Automatic"));
		break;
	}
}
void ProfileWirelessSettings::UpdateSecurityUI(const wxString& strType)
{
    m_tcKey->SetValue(_T(""));
    m_tcConfirmKey->SetValue(_T(""));
    if (strType == _T("WPA-PSK TKIP") || strType == _T("WPA-PSK AES")
			|| strType == _T("WPA2-PSK TKIP") || strType == _T("WPA2-PSK AES") )
    {
        m_textTip->SetLabel(_T(""));
        m_tcKey->Enable(true);
        m_tcConfirmKey->Enable(true);
        m_cbbIndex->Enable(false);
    }
	else if ( strType == _T("WEP") )
    {
        m_textTip->SetLabel(_("Use hexadecimal digits (0-9, a-f)"));
        m_tcKey->Enable(true);
        m_tcConfirmKey->Enable(true);
        m_cbbIndex->Enable(true);
    }
	else if ( strType == _("NONE") || strType== _("UNKNOWN") )
    {
        m_textTip->SetLabel(_T(""));
        m_tcKey->Enable(false);
        m_tcConfirmKey->Enable(false);
        m_cbbIndex->Enable(false);
    }
}

void ProfileWirelessSettings::OnWirelessNetworkNameChanged(wxCommandEvent& event)
{
    m_bNameChange = true;
}
