/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ScanAPThread.h"
#include <wx/utils.h>
#include "DataCenter.h"
#include "ENMUtil.h"
#include "ScanEvent.h"

ScanAPThread::ScanAPThread() : wxThread()
{
}

ScanAPThread::~ScanAPThread()
{
}

void* ScanAPThread::Entry()
{
    wxString adapterName = DataCenter::GetInstance()->GetUsingAdapterName(ADAPTER_WIREDLESS);
    if (adapterName.IsEmpty())
    {
        return 0;
    }
    char cOrder[128];
    sprintf(cOrder, "iwlist %s scan > /tmp/scanresult.txt", ENMUtil::WxStringToString(adapterName).c_str());
    //printf("exec-------%s\n", cOrder);
//    system("killall nm-applet");
    system(cOrder);
    //printf("post event, go---------\n");
    ScanEvent event(ID_SCAN_OVER);
    ::wxPostEvent(DataCenter::GetInstance()->GetScanner(), event);
    //printf("post event, over---------\n");
    return NULL;
}
