/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "SwitchAdapterEvent.h"

DEFINE_EVENT_TYPE(wxEVT_SWITCH_ADAPTER);

SwitchAdapterEvent::SwitchAdapterEvent(ADAPTER_TYPE disabled, ADAPTER_TYPE enabled, NetworkOperationResult result)
        : wxEvent(ID_SWITCH_ADAPTER, wxEVT_SWITCH_ADAPTER)
{
    m_disabled = disabled;
    m_enabled = enabled;
    m_result = result;
}

SwitchAdapterEvent::~SwitchAdapterEvent()
{
}

wxEvent* SwitchAdapterEvent::Clone() const
{
    return new SwitchAdapterEvent(*this);
}

ADAPTER_TYPE SwitchAdapterEvent::GetDisabledAdapterType() const
{
    return m_disabled;
}

ADAPTER_TYPE SwitchAdapterEvent::GetEnabledAdapterType() const
{
    return m_enabled;
}

NetworkOperationResult SwitchAdapterEvent::GetOperationResult() const
{
    return m_result;
}

bool SwitchAdapterEvent::IsSuccess() const
{
    return m_result == OPERATION_SUCCESS;
}
