/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _SWITCH_ADAPTER_EVENT_H_
#define _SWITCH_ADAPTER_EVENT_H_

#include <wx/event.h>
#include "DataCenter.h"
#include "operation.h"

const unsigned int ID_SWITCH_ADAPTER = wxID_HIGHEST + 0x01100;

BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(wxEVT_SWITCH_ADAPTER, -1)
END_DECLARE_EVENT_TYPES()

class SwitchAdapterEvent : public wxEvent
{
    public:
        SwitchAdapterEvent(ADAPTER_TYPE disabled, ADAPTER_TYPE enabled, NetworkOperationResult result);
        virtual ~SwitchAdapterEvent();
        virtual wxEvent* Clone() const;
        ADAPTER_TYPE GetDisabledAdapterType() const;
        ADAPTER_TYPE GetEnabledAdapterType() const;
        NetworkOperationResult GetOperationResult() const;
        bool IsSuccess() const;

    private:
        ADAPTER_TYPE m_disabled;
        ADAPTER_TYPE m_enabled;
        NetworkOperationResult m_result;
};

typedef void (wxEvtHandler::*wxSwitchAdapterEventFunction)(SwitchAdapterEvent&);

#define EVT_SWITCH_ADAPTER(id, fn) DECLARE_EVENT_TABLE_ENTRY( wxEVT_SWITCH_ADAPTER, id, -1, \
    (wxObjectEventFunction) (wxEventFunction) (wxCommandEventFunction) (wxNotifyEventFunction) \
    wxStaticCastEvent( wxSwitchAdapterEventFunction, & fn ), (wxObject *) NULL ),


#endif // _SWITCH_ADAPTER_EVENT_H_
