/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _TASKBAR_BALLOON_H_
#define _TASKBAR_BALLOON_H_

#include <wx/event.h>
#include <wx/stattext.h>
#include <wx/statbmp.h>
#include "BitmapDialog.h"

class TaskBarBalloon : public wxBitmapDialog
{
    public:
    TaskBarBalloon(wxWindow* dlg, const wxString& title);
    virtual ~TaskBarBalloon();

        /** painting bg */
        void OnPaint(wxPaintEvent& event);
        /** click on the balloon */
        void OnClick(wxMouseEvent & event);

        void SetConnectionTip(const wxString& strTip);

        void SetConnectionType(const wxString& strType);

        void SetConnectionSpeed(const wxString& strSpeed);

        void SetConnectionStatus(const wxString& strStatus);

        void SetSignalQuality(int iSignalQuality);

        void SetSignalQualityBmp(int iSignalQuality);

        wxStaticText* m_SignalQuality;
		wxStaticText* m_TypeTip;
		wxStaticText* m_StatusTip;
		wxStaticText* m_SignalQualityTip;
		wxStaticText* m_SuccTip;
		wxStaticText* m_Type;
		wxStaticText* m_Speed;
		wxStaticText* m_Status;
		wxStaticText* m_SpeedTip;
        wxStaticBitmap* m_bmpSignalQuality;

private:

        DECLARE_EVENT_TABLE();

};

#endif // TASKBARBALLOON_H_INCLUDED
