/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef VIEWAPNEIGHBORSDLG_H
#define VIEWAPNEIGHBORSDLG_H

#include <wx/listctrl.h>
#include <wx/stattext.h>
#include <wx/statline.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/event.h>
#include <wx/timer.h>
#if defined(__UNIX__)
#include "ScanEvent.h"
#endif

#include "GaugeDialog.h"

#define MAX_HOST_NAME_LEN 200
#define MAX_IPADDR_LEN 15
#define MAX_IPADDR_NUM 255

/** Definition of AP Neighbors Information. */
typedef struct AP_NEIGHBORS_INFO_S
{
	wchar_t HostName[MAX_HOST_NAME_LEN];		/**< The neighbors host name. */
	wxString IPAddress;	    /**< The neighbors IP Address. */
} AP_NEIGHBORS_INFO, *PAP_NEIGHBORS_INFO;


class ViewAPNeighborsDlg: public wxDialog
{
public:
    ViewAPNeighborsDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
    virtual ~ViewAPNeighborsDlg();

    AP_NEIGHBORS_INFO* m_pNeighborsInfo;
    int m_count;
    virtual bool Show(bool show = true);
    void UpdateApNeighborsInfo(PAP_NEIGHBORS_INFO ap_NeighborsInfo, int iCount, int searchIndex);
#if defined(__UNIX__)
    void ScanOver(ScanEvent& event);
#endif

protected:
    static const long ID_BUTTON_OKVIEWAPNEIGHBORS;
    static const long ID_LISTCTRL_VIEWAPNEIGHBORS;
    static const long ID_BUTTON_REFRESHVIEWAPNEIGHBORS;
    static const long ID_BUTTON_CANCELVIEWAPNEIGHBORS;
    static const long ID_TIMER_VIEWNEIGHBOR;

    wxStaticBitmap* m_bmpImage;
    wxButton* m_btnOk;
    wxButton* m_btnCancel;
    wxButton* m_btnRefresh;
    wxListCtrl* m_listNeighbors;

private:
    class ScanThread : public wxThread
    {
        public:
            ScanThread();
            ScanThread(ViewAPNeighborsDlg* pViewAPNeighborsDlg, int searchIndex = 0);
            virtual ~ScanThread();
            virtual void* Entry();
            virtual void OnExit();
        private:
            const int m_iSearchIndex;
            ViewAPNeighborsDlg* m_pViewAPNeighborsDlg;
    };

    bool m_isSearching;
    int m_iSearchCount;
    AP_NEIGHBORS_INFO* m_apNeighborsInfo;
    ScanThread* m_pScanThread;
    GaugeDialog* m_pGaugeDialog;

    void OnInit(wxInitDialogEvent& event);
    void OnButtonCancelClick(wxCommandEvent& event);
    void OnButtonRefreshClick(wxCommandEvent& event);
    void OnButtonOKClick(wxCommandEvent& event);
    void OnButtonRefreshClick1(wxCommandEvent& event);

    void OnClose(wxCloseEvent& event);

#if defined(__UNIX__)
    wxString ParseIPAddFile(void);
#endif
    bool BeginSearchAPNeighbors();
    DECLARE_EVENT_TABLE()
};

#endif
