/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef XMLOPERATOR_H
#define XMLOPERATOR_H

#include <wx/string.h>
#include <wx/arrstr.h>
#include <wx/xml/xml.h>

#include<vector>
using namespace std;
#include "MeshConfigurationEntity.h"

class XMLOperator
{
    public:

        XMLOperator();
        virtual ~XMLOperator();

        bool        CreateVersionInfoXmlFile(const wxArrayString& VersionInfo);
        bool        ReadVersionInfoXmlFile(wxArrayString &VersionInfo);

        bool  CreateMeshConfigurationXmlFile(MeshConfigurationEntity &meshConfiguration);
        bool  ReadMeshConfigurationXmlFile(MeshConfigurationEntity &meshConfiguration);

        static wxString   GetNNfilePath();
    bool ModifyVersionInfoXmlFile(const wxArrayString& VersionInfo);
    private:

        static const wxString CLIENTFILEPATH;
        static const wxString VERSIONFILEPATH;
        static const wxString NNFILEPATH;
        #if defined(__UNIX__)
        static const wxString SYSTEM_MESH_DIR;
        static const wxString USER_MESH_DIR;
        static const wxString MESHCONFIGURATIONFILEPATH;
        #endif

};

#endif // XMLOPERATOR_H
