/*
 * Enhanced Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_NET_H_
#define _ENM_NET_H_

#include <wx/string.h>

/** Definition of Network Mode. */
typedef enum NETWORK_MODE_E
{
	NETWORK_MODE_WIRED_LAN_CONNECT,
	NETWORK_MODE_WIRED_LAN_DISCONNECT,
	NETWORK_MODE_WIRELESS_LAN_CONNECT,
	NETWORK_MODE_WIRELESS_LAN_DISCONNECT,
	NETWORK_MODE_MESH_CONNECT,
	NETWORK_MODE_MESH_DISCONNECT,
	NETWORK_MODE_DISCONNECTED,
	NETWORK_MODE_DEFAULT
} NETWORK_MODE;

/** Definition of Network Mode. */
typedef enum ADAPTER_TYPE_E
{
    ADAPTER_NONE = 0,
	ADAPTER_WIRED = 1,
	ADAPTER_WIREDLESS,
	ADAPTER_MESH
} ADAPTER_TYPE;


/** Definition of Network Status Information. */
typedef struct NETWORK_WIRED_STATUS_INFO
{
    wxString Type;		/**< The network type. */
	wxString IPAddress;	/**< The IP Address.*/
} NETWORK_WIRED_STATUS_INFO, *PNETWORK_WIRED_STATUS_INFO;

/** Definition of Network Status Information. */
typedef struct UI_NETWORK_STATUS_INFO
{
    wxString Type;				/**< The network type. */
	int SignalQuality;		    /**< The network signal quality. */
	wxString IPAddress;	        /**< The IP Address.*/
} UI_NETWORK_STATUS_INFO, *PUI_NETWORK_STATUS_INFO;

#endif // _ENM_NET_H_
