-- $Id: test_bench.vhdl,v 1.2 2009-02-19 12:27:10 potyra Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library expect;
use expect.types.all;
use expect.procedures.all;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_ser : serial;

	signal term0_power_switch : boolean;

	signal term0_key : boolean_array(0 to 127);

	signal term0_screen_shot : integer;

	signal term1_power_switch : boolean;

	signal term1_key : boolean_array(0 to 127);

	signal term1_screen_shot : integer;

	signal term0_video : opt_rgb;
	signal term1_video : opt_rgb;

begin
	vt102_0 : vt102
		port map(
			power_switch => term0_power_switch,
			serial => ext_ser,
			key => term0_key,
			screen_shot => term0_screen_shot,
			opt_video => term0_video
		);
	vt102_1 : vt102
		port map(
			power_switch => term1_power_switch,
			serial => ext_ser,
			key => term1_key,
			screen_shot => term1_screen_shot,
			opt_video => term1_video
		);
	user : user
		port map(
			term0_power_switch => term0_power_switch,
			term0_key => term0_key,
			term0_screen_shot => term0_screen_shot,
			term0_opt_screen => term0_video,

			term1_power_switch => term1_power_switch,
			term1_key => term1_key,
			term1_screen_shot => term1_screen_shot,
			term1_opt_screen => term1_video
		);
end structural;
