/* $Id: glue-shm.h,v 1.11 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_SHM_H_INCLUDED
#define __GLUE_SHM_H_INCLUDED

#include "config.h" /* Needed for 64bit off_t. */

#include <sys/types.h>
#include <sys/mman.h>

extern void
shm_fd(const char *name, int nr, int *fdp, off_t *offsetp);

extern void *
shm_map(const char *name, int nr, unsigned int len, int code);
extern int
shm_unmap(void *addr, unsigned int len);

extern int
shm_create(const char *name, int nr, unsigned long len);
extern void
shm_destroy(const char *name, int nr);

#endif /* __GLUE_SHM_H_INCLUDED */
