/* $Id: glue-storage.h,v 1.8 2009-01-27 17:44:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_STORAGE_H_INCLUDED
#define __GLUE_STORAGE_H_INCLUDED

#include <inttypes.h>

struct storage_simple {
	int fd;
	int wflag;

	unsigned long long size;

	struct storage_simple_cache {
		struct storage_simple_cache *lru_prev;
		struct storage_simple_cache *lru_next;

		uint8_t *buf;
		unsigned long long pos;
	} cache[100];

	struct storage_simple_cache *lru_first;
	struct storage_simple_cache *lru_last;
};

struct storage {
	char path[1025];
	int cow;
	struct storage_simple media;
	struct storage_simple media_cow;
	struct storage_simple media_map;
};

extern int
storage_read(
	struct storage *s,
	void *buf,
	unsigned int buflen,
	unsigned long long pos
);
extern int
storage_write(
	struct storage *s,
	const void *buf,
	unsigned int buflen,
	unsigned long long pos
);

#define IO_READ  0
#define IO_WRITE 1

extern int
storage_read_write(
	int command,
	struct storage *media,
	unsigned char *buffer,
	unsigned long long pos,
	unsigned long count
);

extern unsigned long long
storage_size(struct storage *s);

extern int
storage_open(struct storage *s, int wflag);
extern int
storage_close(struct storage *s);

extern void
storage_change(struct storage *media, unsigned char *path);

extern void
storage_init(struct storage *s);

extern void
storage_create(struct storage *media,
	const char *name,
	int wflag,
	const char *image,
	int size,
	int blocksize,
	int create,
	int cow,
	int sync_out,
	int sparse
);
extern void
storage_destroy(struct storage *media);

#endif /* __GLUE_STORAGE_H_INCLUDED */
