/* $Id: sig_mech_mouse.c,v 1.5 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_mech_mouse.h"

struct sig_mech_mouse *
sig_mech_mouse_init(const char *name, unsigned int nr)
{
	struct sig_mech_mouse *c;
	char n[1000];

	c = shm_map(name, nr, sizeof(*c), 0);

	sprintf(n, "%s-button0", name);
	c->button0 = sig_boolean_init(n, nr);
	sprintf(n, "%s-button1", name);
	c->button1 = sig_boolean_init(n, nr);
	sprintf(n, "%s-button2", name);
	c->button2 = sig_boolean_init(n, nr);
	sprintf(n, "%s-button3", name);
	c->button3 = sig_boolean_init(n, nr);
	sprintf(n, "%s-button4", name);
	c->button4 = sig_boolean_init(n, nr);
	sprintf(n, "%s-wheel0", name);
	c->wheel0 = sig_integer_init(n, nr);
	sprintf(n, "%s-wheel1", name);
	c->wheel1 = sig_integer_init(n, nr);
	sprintf(n, "%s-wheel2", name);
	c->wheel2 = sig_integer_init(n, nr);

	return c;
}

void
sig_mech_mouse_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_mech_mouse));

	sprintf(n, "%s-button0", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-button1", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-button2", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-button3", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-button4", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-wheel0", name);
	sig_integer_create(n, nr);
	sprintf(n, "%s-wheel1", name);
	sig_integer_create(n, nr);
	sprintf(n, "%s-wheel2", name);
	sig_integer_create(n, nr);
}

void
sig_mech_mouse_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	shm_destroy(name, nr);

	sprintf(n, "%s-button0", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-button1", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-button2", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-button3", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-button4", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-wheel0", name);
	sig_integer_destroy(n, nr);
	sprintf(n, "%s-wheel1", name);
	sig_integer_destroy(n, nr);
	sprintf(n, "%s-wheel2", name);
	sig_integer_destroy(n, nr);
}
