/*
 * $Id: sig_parallel.c,v 1.6 2009-01-27 17:06:42 potyra Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_parallel.h"

void
sig_parallel_send(
	struct sig_parallel *b,
	void *s,
	struct sig_parallel_msg *msg
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv(b->member[nr].s, msg);
	}
}

void
sig_parallel_connect(
	struct sig_parallel *b,
	void *s,
	const struct sig_parallel_funcs *f
)
{
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));
	assert(b->type == SIG_GEN_PARALLEL);

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_parallel *
sig_parallel_init(const char *name, int nr)
{
	struct sig_parallel *sig;

	sig = shm_map(name, nr, sizeof(*sig), 0);

	sig->nmembers = 0;
	sig->type = SIG_GEN_PARALLEL;

	return sig;
}

void
sig_parallel_create(const char *name, int nr)
{
	shm_create(name, nr, sizeof(struct sig_parallel));
}

void
sig_parallel_destroy(const char *name, int nr)
{
	shm_destroy(name, nr);
}
