/*
 * $Id: sig_ps2.c,v 1.8 2009-01-27 17:06:42 potyra Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_ps2.h"

int
sig_ps2_send(struct sig_ps2 *b, void *s, uint8_t byte)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == sizeof(b->member) / sizeof(b->member[0])) {
			return 1;
		}
		if (b->member[nr].s == s) {
			/* Don't send to myself. */
			continue;
		}
		(b->member[nr].f->recv)(b->member[nr].s, byte);
		return 0;
	}
}

void
sig_ps2_connect(struct sig_ps2 *b, void *s, const struct sig_ps2_funcs *f)
{
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));
	assert(b->type == SIG_GEN_PS2);

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_ps2 *
sig_ps2_init(const char *name, int nr)
{
	struct sig_ps2 *sig;

	sig = shm_map(name, nr, sizeof(*sig), 0);

	sig->nmembers = 0;
	sig->type = SIG_GEN_PS2;

	return sig;
}

void
sig_ps2_create(const char *name, int nr)
{
	shm_create(name, nr, sizeof(struct sig_ps2));
}

void
sig_ps2_destroy(const char *name, int nr)
{
	shm_destroy(name, nr);
}
