/*
 * $Id: sig_ps2.h,v 1.5 2009-01-27 17:44:20 potyra Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_PS2_H_INCLUDED
#define __SIG_PS2_H_INCLUDED

#include <inttypes.h>
#include "sig_gen.h"

struct sig_ps2_funcs {
	void (*recv)(void *s, uint8_t byte);
};

struct sig_ps2 {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_ps2_funcs *f;
	} member[2];
	unsigned int nmembers;
};

extern int
sig_ps2_send(struct sig_ps2 *b, void *s, uint8_t byte);

extern void
sig_ps2_connect(struct sig_ps2 *b, void *s, const struct sig_ps2_funcs *f);

extern struct sig_ps2 *
sig_ps2_init(const char *name, int nr);

extern void
sig_ps2_create(const char *name, int nr);
extern void
sig_ps2_destroy(const char *name, int nr);

#endif /* __SIG_PS2_H_INCLUDED */
