/*
 * $Id: sig_vga.c,v 1.14 2009-01-27 17:06:42 potyra Exp $
 *  
 *  Implementation of the VGA cable.
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "glue-shm.h"
#include "sig_vga.h"

struct sig_vga *
sig_vga_init(const char *name, unsigned int nr)
{
	struct sig_vga *b;
	char n[1000];
	int ret;

	b = shm_map(name, nr, sizeof(*b), 0);
	b->type = SIG_GEN_VGA;

	ret = snprintf(n, sizeof(n), "%s-video", name);
	assert(0 < ret);
	b->video = sig_video_init(n, nr);

	ret = snprintf(n, sizeof(n), "%s-ddc", name);
	assert(0 < ret);
	b->ddc = sig_i2c_bus_init(n, nr);

	return b;
}

void
sig_vga_create(const char *name, unsigned int nr)
{
	char n[1000];
	int ret;

	shm_create(name, nr, sizeof(struct sig_vga));

	ret = snprintf(n, sizeof(n), "%s-video", name);
	assert(0 < ret);

	sig_video_create(n, nr);

	ret = snprintf(n, sizeof(n), "%s-ddc", name);
	assert(0 < ret);
	sig_i2c_bus_create(n, nr);
}

void
sig_vga_destroy(const char *name, unsigned int nr)
{
	char n[1000];
	int ret;

	shm_destroy(name, nr);

	ret = snprintf(n, sizeof(n), "%s-video", name);
	assert(0 < ret);

	sig_video_destroy(n, nr);

	ret = snprintf(n, sizeof(n), "%s-ddc", name);
	assert(0 < ret);
	sig_i2c_bus_destroy(n, nr);
}
