/* $Id: arch_gen_mem_Xx16.c,v 1.16 2009-01-28 12:59:15 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <inttypes.h>

#include <sys/types.h>
#include <sys/mman.h>
#include <assert.h>
#include "fixme.h"
#include <stdio.h>
#include <string.h>

#include "glue-log.h"
#include "glue-shm.h"

#include "sig_cs.h"
#include "sig_isa_bus.h"

#define COMP	SNAME

/*
 * Types
 */
struct chip {
	uint32_t *haddr;

	struct sig_cs *port_cs;
	struct sig_isa_bus_main *port_bus;
};

static unsigned char *
NAME_(access)(struct chip *chip, unsigned long addr)
{
	addr &= ~0xfffUL;

	return (unsigned char *) chip->haddr + addr;
}

static int
NAME_(readb)(
	void *_chip,
	uint8_t *valp,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*valp = *(uint8_t *) (va + addr - (addr & ~0xfffUL));

	return 0;
}

static int
NAME_(readw)(
	void *_chip,
	uint16_t *valp,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	assert((addr & 1) == 0);

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*valp = *(uint16_t *) (va + addr - (addr & ~0xfffUL));

	return 0;
}

static int
NAME_(writeb)(
	void *_chip,
	uint8_t val,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*(uint8_t *) (va + addr - (addr & ~0xfffUL)) = val;

	return 0;
}

static int
NAME_(writew)(
	void *_chip,
	uint16_t val,
	unsigned long addr
)
{
	struct chip *chip = (struct chip *) _chip;
	unsigned char *va;

	assert((addr & 1) == 0);

	addr &= MEM_SIZE - 1;

	va = NAME_(access)(chip, addr);

	*(uint16_t *) (va + addr - (addr & ~0xfffUL)) = val;

	return 0;
}

static int
NAME_(map)(
	void *_chip,
	unsigned long addr,
	unsigned int len,
	char **haddr_mr_p,
	char **haddr_mw_p
)
{
	fixme();
	#if 0
	struct chip *chip = (struct chip *) _chip;
	unsigned long haddr;
	unsigned long laddr;

	laddr = addr & ~0xfffUL & (MEM_SIZE - 1);
	haddr = addr & ~0xfffUL & ~(MEM_SIZE - 1);

	assert(/* 0 <= laddr && */ laddr < MEM_SIZE);

	*fdp = chip->fd;
	*offsetp = chip->offset + laddr;
	*startp = haddr;
	*lenp = MEM_SIZE;
	*wflagp = 1;
	#endif

	return 0;
}

static void
NAME_(power_set)(void *_chip, unsigned int val)
{
	struct chip *chip = (struct chip *) _chip;

	if (val) {
		memset(chip->haddr, 0, MEM_SIZE);
	}
}

void
NAME_(init)(
	unsigned int nr,
	struct sig_boolean *port_power,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus
)
{
	struct chip *chip;
	static const struct sig_boolean_funcs power_funcs = {
		.set = NAME_(power_set),
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb	= NAME_(readb),
		.readw	= NAME_(readw),
		.writeb	= NAME_(writeb),
		.writew	= NAME_(writew),
		.map	= NAME_(map),
	};

	chip = shm_map(COMP, nr, sizeof(*chip), 0);
	chip->haddr = shm_map(COMP ".ram", nr, MEM_SIZE, 0);

	sig_boolean_connect_in(port_power, chip, &power_funcs);

	chip->port_cs = port_cs;
	chip->port_bus = port_bus;
	sig_cs_connect(chip->port_cs, chip, &cs_funcs);
}

unsigned int
NAME_(create)(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct chip));
	shm_create(COMP ".ram", nr, MEM_SIZE);

	return nr++;
}

void
NAME_(destroy)(unsigned int nr)
{
	shm_destroy(COMP ".ram", nr);
	shm_destroy(COMP, nr);
}
