/*
 * $Id: cb_intel_eepro100_gui_gtk.c,v 1.14 2009-01-28 12:59:17 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "gui-gtk.h"

#include "cb_intel_eepro100_gui.h"

#define COMP "cb_intel_eepro100"

struct cpssp {
	GtkWidget *power_led;
	GtkWidget *busy_led;
	GtkWidget *fi_dialog;

	struct sig_fault *fault_recv_loss;
	struct sig_fault *fault_send_loss;
};

static struct cpssp *iface[100];

/*
 * Simulator Callbacks
 */
static void
cb_intel_eepro100_opt_power_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->power_led), val);
	gui_gtk_flush();
}

static void
cb_intel_eepro100_opt_busy_led_set(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	gui_gtk_led_set(GUI_GTK_LED(cpssp->busy_led), val);
	gui_gtk_flush();
}

/*
 * GUI Callbacks
 */
static void
cb_intel_eepro100_gui_recv_loss_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_recv_loss, cpssp, 0ULL, 0ULL, fault->state);

	free(fault);
}

static void
cb_intel_eepro100_gui_send_loss_event(
	GtkWidget *w,
	gpointer _fault,
	gpointer _cpssp
)
{
	struct fault {
		unsigned int state;
		const char *loc0[4];
		const char *loc1[4];
	} *fault = (struct fault *) _fault;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	sig_fault_set(cpssp->fault_send_loss, cpssp, 0ULL, 0ULL, fault->state);

	free(fault);
}

void
cb_intel_eepro100_gui_init(
	unsigned int nr,
	struct sig_cardbus *port_card,
	struct sig_eth *port_eth,
	struct sig_boolean *port_opt_power_led,
	struct sig_boolean *port_opt_busy_led,
	struct sig_fault *fault_recv_loss,
	struct sig_fault *fault_send_loss
)
{
	static const struct sig_boolean_funcs opt_power_led_funcs = {
		.set = cb_intel_eepro100_opt_power_led_set,
	};
	static const struct sig_boolean_funcs opt_busy_led_funcs = {
		.set = cb_intel_eepro100_opt_busy_led_set,
	};
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	/* Out */
	cpssp->fault_recv_loss = fault_recv_loss;
	cpssp->fault_send_loss = fault_send_loss;

	/* In */
	sig_boolean_connect_in(port_opt_power_led, cpssp, &opt_power_led_funcs);
	sig_boolean_connect_in(port_opt_busy_led, cpssp, &opt_busy_led_funcs);
}

void
cb_intel_eepro100_gui_create(
	unsigned int page,
	unsigned int nr,
	const char *name,
	const char *mac
)
{
	struct cpssp *cpssp;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *w;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	vbox = gtk_vbox_new(FALSE, 1);

	hbox = gtk_hbox_new(FALSE, 1);

	/* Power LED */
	cpssp->power_led = gui_gtk_led_new("Power");
	gtk_widget_show(cpssp->power_led);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->power_led, FALSE, FALSE, 1);

	/* Busy LED */
	cpssp->busy_led = gui_gtk_led_new("Busy");
	gtk_widget_show(cpssp->busy_led);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->busy_led, FALSE, FALSE, 1);

	gtk_widget_show(hbox);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 1);

	/* FI Dialog */
	cpssp->fi_dialog = gtk_vbox_new(FALSE, 1);
	
	w = gui_gtk_fi_new("Receive Loss", "Percentage");
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(cb_intel_eepro100_gui_recv_loss_event),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->fi_dialog), w, FALSE, FALSE, 1);

	w = gui_gtk_fi_new("Send Loss", "Percentage");
	g_signal_connect(G_OBJECT(w), "fi-change",
			G_CALLBACK(cb_intel_eepro100_gui_send_loss_event),
			cpssp);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(cpssp->fi_dialog), w, FALSE, FALSE, 1);

	gui_comp_add(page, COMP, nr, name, vbox,
			FALSE, FALSE, cpssp->fi_dialog);

	iface[nr] = cpssp;
}

void
cb_intel_eepro100_gui_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = iface[nr];
	assert(cpssp);

	free(cpssp);

	iface[nr] = NULL;
}
